/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.providers.TornadoMemoryOrder;

@NodeInfo(nameTemplate="OCLAtomicWrite#{p#location/s}")
public class OCLWriteAtomicNode
extends AbstractWriteNode
implements LIRLowerableAccess {
    public static final NodeClass<OCLWriteAtomicNode> TYPE = NodeClass.create(OCLWriteAtomicNode.class);
    @Node.Input(value=InputType.Association)
    private AddressNode address;
    @Node.Input
    private ValueNode accumulator;
    private Stamp accStamp;
    private JavaKind elementKind;
    private ATOMIC_OPERATION operation;

    public OCLWriteAtomicNode(AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, ValueNode acc, Stamp accStamp, JavaKind elementKind, ATOMIC_OPERATION operation) {
        super(TYPE, address, location, value, barrierType);
        this.address = address;
        this.accumulator = acc;
        this.accStamp = accStamp;
        this.elementKind = elementKind;
        this.operation = operation;
    }

    protected OCLWriteAtomicNode(NodeClass<? extends OCLWriteAtomicNode> c, AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType) {
        super(c, address, location, value, barrierType);
        this.address = address;
    }

    public static void store() {
    }

    public MemoryOrderMode getMemoryOrder() {
        return null;
    }

    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    public OCLStamp getStampInt() {
        return switch (this.operation.ordinal()) {
            case 0 -> new OCLStamp(OCLKind.ATOMIC_ADD_INT);
            case 1 -> new OCLStamp(OCLKind.ATOMIC_MUL_INT);
            default -> throw new RuntimeException("Operation for reduction not supported yet: " + String.valueOf((Object)this.operation));
        };
    }

    public OCLStamp getStampFloat() {
        OCLStamp oclStamp = null;
        switch (this.operation.ordinal()) {
            case 0: {
                oclStamp = new OCLStamp(OCLKind.ATOMIC_ADD_FLOAT);
                break;
            }
            default: {
                throw new RuntimeException("Operation for reduction not supported yet: " + String.valueOf((Object)this.operation));
            }
        }
        return oclStamp;
    }

    public void generate(NodeLIRBuilderTool gen) {
        OCLStamp oclStamp = switch (this.elementKind) {
            case JavaKind.Int -> this.getStampInt();
            case JavaKind.Long -> new OCLStamp(OCLKind.ATOMIC_ADD_INT);
            case JavaKind.Float -> this.getStampFloat();
            default -> throw new RuntimeException("Data type for reduction not supported yet: " + String.valueOf(this.elementKind));
        };
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind((Stamp)oclStamp);
        LIRKind accKind = gen.getLIRGeneratorTool().getLIRKind(this.accStamp);
        gen.getLIRGeneratorTool().getArithmetic().emitStore((ValueKind)writeKind, gen.operand((Node)this.address), gen.operand((Node)this.value()), gen.state((DeoptimizingNode)this), TornadoMemoryOrder.GPU_MEMORY_MODE);
        gen.getLIRGeneratorTool().getArithmetic().emitStore((ValueKind)accKind, gen.operand((Node)this.accumulator), gen.operand((Node)this.value()), gen.state((DeoptimizingNode)this), TornadoMemoryOrder.GPU_MEMORY_MODE);
    }

    public boolean canNullCheck() {
        return true;
    }

    public LocationIdentity getKilledLocationIdentity() {
        TornadoInternalError.unimplemented();
        return null;
    }

    public NodeIterable<FrameState> states() {
        TornadoInternalError.unimplemented();
        return null;
    }

    public static enum ATOMIC_OPERATION {
        ADD,
        MUL,
        MAX,
        MIN,
        SUB,
        CUSTOM;

    }
}

