/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.Opcode;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;

@Opcode(value="VSEL")
public class OCLVectorElementSelect
extends OCLLIROp {
    final Value vector;
    private final Value selection;

    public OCLVectorElementSelect(LIRKind lirKind, Value vector, Value selection) {
        super(lirKind);
        this.vector = vector;
        this.selection = selection;
    }

    public static char convertForWithOf16(int value) {
        if (value >= 10 && value <= 15) {
            return (char)(65 + value - 10);
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    @Override
    public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
        asm.emitValueOrOp(crb, this.vector);
        int idx = Integer.parseInt(OCLAssembler.getAbsoluteIndexFromValue(this.selection));
        String vectorIndex = idx > 9 ? String.valueOf(OCLVectorElementSelect.convertForWithOf16(idx)) : OCLAssembler.getAbsoluteIndexFromValue(this.selection);
        asm.emitSymbol(".s" + vectorIndex);
    }

    public String toString() {
        return String.format("vselect(%s, %s)", this.vector, this.selection);
    }
}

