/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Opcode;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.meta.OCLMemorySpace;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLBarrierNode;

public class OCLUnary {

    public static class OCLAddressCast
    extends UnaryConsumer {
        private final OCLArchitecture.OCLMemoryBase base;

        public OCLAddressCast(OCLArchitecture.OCLMemoryBase base, LIRKind lirKind) {
            super(OCLAssembler.OCLUnaryTemplate.CAST_TO_POINTER, lirKind, null);
            this.base = base;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            OCLKind oclKind = this.getOCLPlatformKind();
            asm.emit(((OCLAssembler.OCLUnaryTemplate)this.opcode).getTemplate(), this.base.getMemorySpace().name() + " " + oclKind.toString());
        }

        OCLMemorySpace getMemorySpace() {
            return this.base.getMemorySpace();
        }
    }

    public static class MemoryAccess
    extends UnaryConsumer {
        private final OCLArchitecture.OCLMemoryBase base;
        private Value index;

        MemoryAccess(OCLArchitecture.OCLMemoryBase base, Value value) {
            super(null, LIRKind.Illegal, value);
            this.base = base;
        }

        MemoryAccess(OCLArchitecture.OCLMemoryBase base, Value value, Value index) {
            super(null, LIRKind.Illegal, value);
            this.base = base;
            this.index = index;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emitValue(crb, this.value);
        }

        public OCLArchitecture.OCLMemoryBase getBase() {
            return this.base;
        }

        public Value getIndex() {
            return this.index;
        }

        @Override
        public String toString() {
            return String.format("%s", this.value);
        }
    }

    public static class FloatCast
    extends UnaryConsumer {
        public FloatCast(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(opcode, lirKind, value);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("isnan(");
            asm.emitValueOrOp(crb, this.value);
            asm.emit(")? 0 : ");
            this.opcode.emit(crb, this.value);
        }

        @Override
        public String toString() {
            return String.format("isnan(%s) ? 0 : %s %s", this.value, this.opcode.toString(), this.value);
        }
    }

    public static class Barrier
    extends UnaryConsumer {
        OCLBarrierNode.OCLMemFenceFlags flags;

        public Barrier(OCLAssembler.OCLUnaryOp opcode, OCLBarrierNode.OCLMemFenceFlags flags) {
            super(opcode, LIRKind.Illegal, null);
            this.flags = flags;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit(this.toString());
        }

        @Override
        public String toString() {
            return String.format("%s(CLK_%s_MEM_FENCE)", this.opcode.toString(), this.flags.toString().toUpperCase());
        }
    }

    public static class LoadOCLKernelContext
    extends UnaryConsumer {
        public LoadOCLKernelContext(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(opcode, lirKind, value);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit(this.opcode.toString());
            asm.emit("[");
            asm.emitValueOrOp(crb, this.value);
            asm.emit("]");
        }

        @Override
        public String toString() {
            return String.format("%s[%s] ", this.opcode.toString(), this.value);
        }
    }

    public static class IntrinsicAtomicDeclaration
    extends UnaryConsumer {
        AllocatableValue lhs;

        public IntrinsicAtomicDeclaration(OCLAssembler.OCLUnaryOp opcode, AllocatableValue lhs, Value initialValue) {
            super(opcode, LIRKind.Illegal, initialValue);
            this.lhs = lhs;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            StringBuffer lineGlobalScope = new StringBuffer();
            lineGlobalScope.append("__global atomic_int ");
            lineGlobalScope.append(asm.getStringValue(crb, (Value)this.lhs));
            lineGlobalScope.append(" = ");
            lineGlobalScope.append(this.opcode.toString());
            lineGlobalScope.append("(");
            lineGlobalScope.append(asm.getStringValue(crb, this.value));
            lineGlobalScope.append(")");
            lineGlobalScope.append(";");
            lineGlobalScope.append("\n");
            asm.emitLineGlobal(lineGlobalScope.toString());
        }
    }

    public static class IntrinsicAtomicGet
    extends UnaryConsumer {
        private static final String arrayName = OCLArchitecture.atomicSpace.getName();
        private int index;

        public IntrinsicAtomicGet(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value, int index) {
            super(opcode, lirKind, value);
            this.index = index;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit(this.toString());
        }

        @Override
        public String toString() {
            return String.format("%s[%s]", arrayName, this.index);
        }
    }

    public static class IntrinsicAtomicOperator
    extends UnaryConsumer {
        private static final String arrayName = OCLArchitecture.atomicSpace.getName();
        private int index;
        private final AtomicOperator atomicOperator;

        public IntrinsicAtomicOperator(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value, int index, AtomicOperator atomicOperator) {
            super(opcode, lirKind, value);
            this.index = index;
            this.atomicOperator = atomicOperator;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit(this.toString());
        }

        @Override
        public String toString() {
            switch (this.atomicOperator.ordinal()) {
                case 0: {
                    return String.format("%s(&%s[%s]) + %d", this.opcode.toString(), arrayName, this.index, 1);
                }
                case 2: {
                    return String.format("%s(&%s[%s]) - %d", this.opcode.toString(), arrayName, this.index, 1);
                }
                case 1: {
                    return String.format("%s(&%s[%s])", this.opcode.toString(), arrayName, this.index);
                }
                case 3: {
                    return String.format("%s(&%s[%s])", this.opcode.toString(), arrayName, this.index);
                }
            }
            return "";
        }
    }

    public static enum AtomicOperator {
        INCREMENT_AND_GET,
        GET_AND_INCREMENT,
        DECREMENT_AND_GET,
        GET_AND_DECREMENT;

    }

    public static class IntrinsicAtomicFetch
    extends UnaryConsumer {
        public IntrinsicAtomicFetch(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(opcode, lirKind, value);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit(this.toString());
        }

        @Override
        public String toString() {
            return String.format("%s(&%s, 1, memory_order_relaxed)", this.opcode.toString(), this.value.toString());
        }
    }

    @Opcode(value="AtomAdd")
    public static class AtomOperation
    extends UnaryConsumer {
        @LIRInstruction.Use
        MemoryAccess address;
        @LIRInstruction.Use
        OCLAssembler.OCLUnaryIntrinsic atomicOp;
        @LIRInstruction.Use
        Value inc;
        LIRKind destLirKind;

        public AtomOperation(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value, MemoryAccess address, OCLAssembler.OCLUnaryIntrinsic atomicOp, Value inc) {
            super(opcode, lirKind, value);
            this.address = address;
            this.atomicOp = atomicOp;
            this.inc = inc;
            this.destLirKind = lirKind;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            this.atomicOp.emit(crb);
            asm.emitSymbol("(");
            asm.emitSymbol("(");
            asm.emitSymbol("volatile");
            asm.space();
            asm.emitSymbol(this.address.getBase().getMemorySpace().name());
            asm.space();
            asm.emit(this.destLirKind.getPlatformKind().toString().toLowerCase());
            asm.space();
            asm.emitSymbol("*");
            asm.emitSymbol(")");
            asm.space();
            this.address.emit(crb, asm);
            asm.emitSymbol(",");
            asm.space();
            asm.emitValue(crb, this.inc);
            asm.emitSymbol(")");
        }
    }

    public static class Intrinsic
    extends UnaryConsumer {
        public Intrinsic(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(opcode, lirKind, value);
        }

        @Override
        public String toString() {
            return String.format("%s(%s)", this.opcode.toString(), this.value);
        }
    }

    public static class Expr
    extends UnaryConsumer {
        public Expr(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(opcode, lirKind, value);
        }
    }

    protected static class UnaryConsumer
    extends OCLLIROp {
        @Opcode
        protected final OCLAssembler.OCLUnaryOp opcode;
        @LIRInstruction.Use
        protected Value value;

        UnaryConsumer(OCLAssembler.OCLUnaryOp opcode, LIRKind lirKind, Value value) {
            super(lirKind);
            this.opcode = opcode;
            this.value = value;
        }

        public Value getValue() {
            return this.value;
        }

        public OCLAssembler.OCLUnaryOp getOpcode() {
            return this.opcode;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            this.opcode.emit(crb, this.value);
        }

        public String toString() {
            return String.format("%s %s", this.opcode.toString(), this.value);
        }
    }
}

