/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Opcode;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;

public class OCLTernary {

    public static class Intrinsic
    extends TernaryConsumer {
        public Intrinsic(OCLAssembler.OCLTernaryOp opcode, LIRKind lirKind, Value x, Value y, Value z) {
            super(opcode, lirKind, x, y, z);
        }

        @Override
        public String toString() {
            return String.format("%s(%s, %s, %s)", this.opcode.toString(), this.x, this.y, this.z);
        }
    }

    public static class Select
    extends TernaryConsumer {
        protected OCLLIROp condition;

        public Select(LIRKind lirKind, OCLLIROp condition, Value y, Value z) {
            super(OCLAssembler.OCLTernaryTemplate.SELECT, lirKind, null, y, z);
            this.condition = condition;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("(");
            this.condition.emit(crb, asm);
            asm.emit(")");
            asm.emit(" ? ");
            asm.emitValue(crb, this.y);
            asm.emit(" : ");
            asm.emitValue(crb, this.z);
        }
    }

    public static class Expr
    extends TernaryConsumer {
        public Expr(OCLAssembler.OCLTernaryOp opcode, LIRKind lirKind, Value x, Value y, Value z) {
            super(opcode, lirKind, x, y, z);
        }
    }

    protected static class TernaryConsumer
    extends OCLLIROp {
        @Opcode
        protected final OCLAssembler.OCLTernaryOp opcode;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;
        @LIRInstruction.Use
        protected Value z;

        protected TernaryConsumer(OCLAssembler.OCLTernaryOp opcode, LIRKind lirKind, Value x, Value y, Value z) {
            super(lirKind);
            this.opcode = opcode;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            this.opcode.emit(crb, this.x, this.y, this.z);
        }

        public String toString() {
            return String.format("%s %s %s %s", this.opcode.toString(), this.x, this.y, this.z);
        }
    }
}

