/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Opcode;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;

@Opcode(value="PRINTF")
public class OCLPrintf
extends OCLLIROp {
    private Value[] inputs;

    public OCLPrintf(Value[] inputs) {
        super(LIRKind.Illegal);
        this.inputs = inputs;
    }

    @Override
    public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
        int i;
        asm.emit("printf( \"tornado[%%3d,%%3d,%%3d]> %s\"", asm.formatConstant((ConstantValue)this.inputs[0]));
        for (i = 1; i < 4; ++i) {
            asm.emit(", ");
            asm.emitValue(crb, this.inputs[i]);
        }
        if (this.inputs.length > 4) {
            asm.emit(", ");
        }
        for (i = 4; i < this.inputs.length - 1; ++i) {
            asm.emitValue(crb, this.inputs[i]);
            asm.emit(", ");
        }
        if (this.inputs.length > 4) {
            asm.emitValue(crb, this.inputs[this.inputs.length - 1]);
        }
        asm.emit(")");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("printf( \"%s\"", this.inputs[0]));
        if (this.inputs.length > 4) {
            sb.append(", ");
        }
        for (int i = 4; i < this.inputs.length - 1; ++i) {
            sb.append(this.inputs[i]);
            sb.append(", ");
        }
        if (this.inputs.length > 4) {
            sb.append(this.inputs[this.inputs.length - 1]);
        }
        sb.append(" )");
        return sb.toString();
    }
}

