/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLVectorElementSelect;
import uk.ac.manchester.tornado.drivers.opencl.graal.meta.OCLMemorySpace;

public class OCLLIRStmt {

    @Opcode(value="Pragma")
    public static class PragmaExpr
    extends AbstractInstruction {
        public static final LIRInstructionClass<PragmaExpr> TYPE = LIRInstructionClass.create(PragmaExpr.class);
        @LIRInstruction.Use
        protected Value prg;

        public PragmaExpr(OCLLIROp prg) {
            super(TYPE);
            this.prg = prg;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            if (this.prg instanceof OCLLIROp) {
                ((OCLLIROp)this.prg).emit(crb, asm);
            } else {
                asm.emitValue(crb, this.prg);
            }
        }
    }

    @Opcode(value="RELOCATED_EXPR")
    public static class RelocatedExpressionStmt
    extends ExprStmt {
        public static final LIRInstructionClass<RelocatedExpressionStmt> TYPE = LIRInstructionClass.create(RelocatedExpressionStmt.class);
        @LIRInstruction.Use
        protected Value expr;

        public RelocatedExpressionStmt(OCLLIROp expr) {
            super(expr);
            this.expr = expr;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.expr instanceof OCLLIROp) {
                ((OCLLIROp)this.expr).emit(crb, asm);
            } else {
                asm.emitValue(crb, this.expr);
            }
            asm.eol();
        }

        @Override
        public Value getExpr() {
            return this.expr;
        }
    }

    @Opcode(value="EXPR")
    public static class ExprStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<ExprStmt> TYPE = LIRInstructionClass.create(ExprStmt.class);
        @LIRInstruction.Use
        protected Value expr;

        public ExprStmt(OCLLIROp expr) {
            super(TYPE);
            this.expr = expr;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.expr instanceof OCLLIROp) {
                ((OCLLIROp)this.expr).emit(crb, asm);
            } else {
                asm.emitValue(crb, this.expr);
            }
            asm.delimiter();
            asm.eol();
        }

        public Value getExpr() {
            return this.expr;
        }
    }

    @Opcode(value="VSTORE")
    public static class VectorStoreStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<VectorStoreStmt> TYPE = LIRInstructionClass.create(VectorStoreStmt.class);
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;
        @LIRInstruction.Use
        protected Value index;
        protected OCLAssembler.OCLTernaryIntrinsic op;

        public VectorStoreStmt(OCLAssembler.OCLTernaryIntrinsic op, Value index, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
            this.op = op;
            this.index = index;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit(this.op.toString());
            asm.emit("(");
            asm.emitValueWithFormat(crb, this.rhs);
            asm.emit(", ");
            asm.emit(OCLAssembler.getAbsoluteIndexFromValue(this.index));
            asm.emit(", ");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        public Value getRhs() {
            return this.rhs;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }

        public Value getIndex() {
            return this.index;
        }

        public OCLAssembler.OCLTernaryIntrinsic getOp() {
            return this.op;
        }
    }

    @Opcode(value="ATOMIC_MUL_STORE")
    public static class StoreAtomicMulStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<StoreStmt> TYPE = LIRInstructionClass.create(StoreStmt.class);
        public static final boolean GENERATE_ATOMIC = true;
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected Value left;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;

        public StoreAtomicMulStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
        }

        public StoreAtomicMulStmt(Value left, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.left = left;
        }

        private void emitAtomicMulStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("atomicMul_Tornado_Int( &(");
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")), ");
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        private void emitStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        private void emitScalarStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.left);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.left == null) {
                this.emitAtomicMulStore(crb, asm);
            }
        }

        public Value getRhs() {
            return this.rhs;
        }

        public Value getLeft() {
            return this.left;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="ATOMIC_SUB_STORE")
    public static class StoreAtomicSubStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<StoreStmt> TYPE = LIRInstructionClass.create(StoreStmt.class);
        public static final boolean GENERATE_ATOMIC = true;
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected Value left;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;

        public StoreAtomicSubStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
        }

        public StoreAtomicSubStmt(Value left, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.left = left;
        }

        private void emitAtomicSubStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("atomic_add( & (");
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")), ");
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        private void emitStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        private void emitScalarStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.left);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.left == null) {
                this.emitAtomicSubStore(crb, asm);
            }
        }

        public Value getRhs() {
            return this.rhs;
        }

        public Value getLeft() {
            return this.left;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="ATOMIC_ADD_FLOAT_STORE")
    public static class StoreAtomicAddFloatStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<StoreStmt> TYPE = LIRInstructionClass.create(StoreStmt.class);
        public static final boolean GENERATE_ATOMIC = true;
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected Value left;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;

        public StoreAtomicAddFloatStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
        }

        public StoreAtomicAddFloatStmt(Value left, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.left = left;
        }

        private void emitAtomicAddStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("atomicAdd_Tornado_Floats( &(");
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")), ");
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        private void emitStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        private void emitScalarStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.left);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.left == null) {
                this.emitAtomicAddStore(crb, asm);
            }
        }

        public Value getRhs() {
            return this.rhs;
        }

        public Value getLeft() {
            return this.left;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="ATOMIC_ADD_STORE")
    public static class StoreAtomicAddStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<StoreStmt> TYPE = LIRInstructionClass.create(StoreStmt.class);
        public static final boolean GENERATE_ATOMIC = true;
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected Value left;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;

        public StoreAtomicAddStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
        }

        public StoreAtomicAddStmt(Value left, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.left = left;
        }

        private void emitAtomicAddStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("atomic_add( & (");
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")), ");
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        private void emitStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        private void emitScalarStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.left);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.left == null) {
                this.emitAtomicAddStore(crb, asm);
            }
        }

        public Value getRhs() {
            return this.rhs;
        }

        public Value getLeft() {
            return this.left;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="STORE")
    public static class StoreStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<StoreStmt> TYPE = LIRInstructionClass.create(StoreStmt.class);
        @LIRInstruction.Use
        protected Value rhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;
        @LIRInstruction.Use
        protected Value index;

        public StoreStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
        }

        public StoreStmt(OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value rhs, Value index) {
            super(TYPE);
            this.rhs = rhs;
            this.cast = cast;
            this.address = address;
            this.index = index;
        }

        public void emitLocalAndPrivateStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            this.address.emit(crb, asm);
            asm.emit("[");
            asm.emitValue(crb, this.index);
            asm.emit("]");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValueOrOp(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        public void emitGlobalStore(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValueOrOp(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.isLocalOrPrivateStore()) {
                this.emitLocalAndPrivateStore(crb, asm);
            } else {
                this.emitGlobalStore(crb, asm);
            }
        }

        private boolean isLocalOrPrivateStore() {
            return this.cast.getMemorySpace().getBase().getMemorySpace() == OCLMemorySpace.LOCAL || this.cast.getMemorySpace().getBase().getMemorySpace() == OCLMemorySpace.PRIVATE;
        }

        public Value getRhs() {
            return this.rhs;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="VLOAD")
    public static class VectorLoadStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<VectorLoadStmt> TYPE = LIRInstructionClass.create(VectorLoadStmt.class);
        @LIRInstruction.Def
        protected AllocatableValue lhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;
        @LIRInstruction.Use
        protected Value index;
        protected OCLAssembler.OCLBinaryIntrinsic op;

        public VectorLoadStmt(AllocatableValue lhs, OCLAssembler.OCLBinaryIntrinsic op, Value index, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address) {
            super(TYPE);
            this.lhs = lhs;
            this.cast = cast;
            this.address = address;
            this.op = op;
            this.index = index;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, (Value)this.lhs);
            asm.space();
            asm.assign();
            asm.space();
            asm.emit(this.op.toString());
            asm.emit("(");
            asm.emitValue(crb, this.index);
            asm.emit(", ");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        public Value getResult() {
            return this.lhs;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }

        public OCLAssembler.OCLBinaryIntrinsic getOp() {
            return this.op;
        }
    }

    @Opcode(value="LOAD")
    public static class LoadStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<LoadStmt> TYPE = LIRInstructionClass.create(LoadStmt.class);
        @LIRInstruction.Def
        protected AllocatableValue lhs;
        @LIRInstruction.Use
        protected OCLUnary.OCLAddressCast cast;
        @LIRInstruction.Use
        protected OCLUnary.MemoryAccess address;
        @LIRInstruction.Use
        protected Value index;

        public LoadStmt(AllocatableValue lhs, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address) {
            super(TYPE);
            this.lhs = lhs;
            this.cast = cast;
            this.address = address;
        }

        public LoadStmt(AllocatableValue lhs, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address, Value index) {
            super(TYPE);
            this.lhs = lhs;
            this.cast = cast;
            this.address = address;
            this.index = index;
        }

        public void emitIntegerBasedIndexCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emitValue(crb, (Value)this.lhs);
            asm.space();
            asm.assign();
            asm.space();
            this.address.emit(crb, asm);
            asm.emit("[");
            asm.emitValue(crb, this.index);
            asm.emit("]");
            asm.delimiter();
            asm.eol();
        }

        public void emitPointerBaseIndexCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emitValue(crb, (Value)this.lhs);
            asm.space();
            asm.assign();
            asm.space();
            asm.emit("*(");
            this.cast.emit(crb, asm);
            asm.space();
            this.address.emit(crb, asm);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            if (this.isLocalOrPrivateLoad()) {
                this.emitIntegerBasedIndexCode(crb, asm);
            } else {
                this.emitPointerBaseIndexCode(crb, asm);
            }
        }

        private boolean isLocalOrPrivateLoad() {
            return this.cast.getMemorySpace().getBase().getMemorySpace() == OCLMemorySpace.LOCAL || this.cast.getMemorySpace().getBase().getMemorySpace() == OCLMemorySpace.PRIVATE;
        }

        public AllocatableValue getResult() {
            return this.lhs;
        }

        public OCLUnary.OCLAddressCast getCast() {
            return this.cast;
        }

        public OCLUnary.MemoryAccess getAddress() {
            return this.address;
        }
    }

    @Opcode(value="MOVE")
    public static class MoveStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<MoveStmt> TYPE = LIRInstructionClass.create(MoveStmt.class);
        @LIRInstruction.Def
        protected AllocatableValue lhs;
        @LIRInstruction.Use
        protected Value rhs;

        public MoveStmt(AllocatableValue lhs, Value rhs) {
            super(TYPE);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, (Value)this.lhs);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.rhs);
            asm.delimiter();
            asm.eol();
        }

        public AllocatableValue getResult() {
            return this.lhs;
        }

        public Value getExpr() {
            return this.rhs;
        }
    }

    @Opcode(value="DIV_HALF")
    public static class DivHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<DivHalfStmt> TYPE = LIRInstructionClass.create(DivHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public DivHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.x);
            asm.space();
            asm.emitSymbol("/");
            asm.space();
            asm.emitValue(crb, this.y);
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="VMULT_HALF")
    public static class VectorMultHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<VectorMultHalfStmt> TYPE = LIRInstructionClass.create(VectorMultHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public VectorMultHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            if (this.x instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectX = (OCLVectorElementSelect)this.x;
                selectX.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.x);
            }
            asm.space();
            asm.emitSymbol("*");
            asm.space();
            if (this.y instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectY = (OCLVectorElementSelect)this.y;
                selectY.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.y);
            }
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="MULT_HALF")
    public static class MultHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<MultHalfStmt> TYPE = LIRInstructionClass.create(MultHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public MultHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.x);
            asm.space();
            asm.emitSymbol("*");
            asm.space();
            asm.emitValue(crb, this.y);
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="VSUB_HALF")
    public static class VectorSubHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<VectorSubHalfStmt> TYPE = LIRInstructionClass.create(VectorSubHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public VectorSubHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            if (this.x instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectX = (OCLVectorElementSelect)this.x;
                selectX.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.x);
            }
            asm.space();
            asm.emitSymbol("-");
            asm.space();
            if (this.y instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectY = (OCLVectorElementSelect)this.y;
                selectY.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.y);
            }
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="SUB_HALF")
    public static class SubHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<SubHalfStmt> TYPE = LIRInstructionClass.create(SubHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public SubHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.x);
            asm.space();
            asm.emitSymbol("-");
            asm.space();
            asm.emitValue(crb, this.y);
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="ADD_HALF")
    public static class AddHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<AddHalfStmt> TYPE = LIRInstructionClass.create(AddHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public AddHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.x);
            asm.space();
            asm.emitSymbol("+");
            asm.space();
            asm.emitValue(crb, this.y);
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="VADD_HALF")
    public static class VectorAddHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<VectorAddHalfStmt> TYPE = LIRInstructionClass.create(VectorAddHalfStmt.class);
        @LIRInstruction.Def
        protected Value result;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        public VectorAddHalfStmt(Value result, Value x, Value y) {
            super(TYPE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.result);
            asm.space();
            asm.assign();
            asm.space();
            if (this.x instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectX = (OCLVectorElementSelect)this.x;
                selectX.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.x);
            }
            asm.space();
            asm.emitSymbol("+");
            asm.space();
            if (this.y instanceof OCLVectorElementSelect) {
                OCLVectorElementSelect selectY = (OCLVectorElementSelect)this.y;
                selectY.emit(crb, asm);
            } else {
                asm.emitValue(crb, this.y);
            }
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="CONVERT_FLOAT_TO_HALF")
    public static class ConvertFloatToHalfStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<ConvertFloatToHalfStmt> TYPE = LIRInstructionClass.create(ConvertFloatToHalfStmt.class);
        @LIRInstruction.Use
        protected Value floatValue;
        @LIRInstruction.Def
        protected Value halfValue;

        public ConvertFloatToHalfStmt(Value floatValue, Value halfValue) {
            super(TYPE);
            this.floatValue = floatValue;
            this.halfValue = halfValue;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.halfValue);
            asm.space();
            asm.assign();
            asm.space();
            asm.emit("(half) ");
            asm.emitValue(crb, this.floatValue);
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="CONVERT_HALF")
    public static class ConvertHalfToFloatStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<ConvertHalfToFloatStmt> TYPE = LIRInstructionClass.create(ConvertHalfToFloatStmt.class);
        @LIRInstruction.Def
        protected Value floatValue;
        @LIRInstruction.Use
        protected Value halfValue;

        public ConvertHalfToFloatStmt(Value floatValue, Value halfValue) {
            super(TYPE);
            this.floatValue = floatValue;
            this.halfValue = halfValue;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.floatValue);
            asm.space();
            asm.assign();
            asm.space();
            asm.emit("convert_float((float) ");
            asm.emitValue(crb, this.halfValue);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="DECOMPRESS_POINTER")
    public static class DecompressPointerStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<DecompressPointerStmt> TYPE = LIRInstructionClass.create(DecompressPointerStmt.class);
        @LIRInstruction.Def
        protected Value decompressed;
        @LIRInstruction.Use
        protected Value base;
        @LIRInstruction.Use
        protected Value compressed;

        public DecompressPointerStmt(Value decompressed, Value base, Value compressed) {
            super(TYPE);
            this.decompressed = decompressed;
            this.base = base;
            this.compressed = compressed;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.decompressed);
            asm.space();
            asm.assign();
            asm.space();
            asm.emitValue(crb, this.base);
            asm.space();
            asm.emit("+");
            asm.space();
            asm.emit("((ulong) ");
            asm.emitValue(crb, this.compressed);
            asm.space();
            asm.emit("<< 3)");
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="CAST_COMPRESSED")
    public static class CastCompressedStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<CastCompressedStmt> TYPE = LIRInstructionClass.create(CastCompressedStmt.class);
        @LIRInstruction.Def
        protected Value compressed;
        @LIRInstruction.Use
        protected Value address;

        public CastCompressedStmt(Value compressed, Value address) {
            super(TYPE);
            this.compressed = compressed;
            this.address = address;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, this.compressed);
            asm.space();
            asm.assign();
            asm.space();
            asm.emit("*((__global uint *)");
            asm.space();
            asm.emitValue(crb, this.address);
            asm.emit(")");
            asm.delimiter();
            asm.eol();
        }
    }

    @Opcode(value="ASSIGN")
    public static class AssignStmt
    extends AbstractInstruction {
        public static final LIRInstructionClass<AssignStmt> TYPE = LIRInstructionClass.create(AssignStmt.class);
        @LIRInstruction.Def
        protected AllocatableValue lhs;
        @LIRInstruction.Use
        protected Value rhs;

        public AssignStmt(AllocatableValue lhs, Value rhs) {
            super(TYPE);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitValue(crb, (Value)this.lhs);
            asm.space();
            asm.assign();
            asm.space();
            if (this.rhs instanceof OCLLIROp) {
                ((OCLLIROp)this.rhs).emit(crb, asm);
            } else {
                asm.emitValue(crb, this.rhs);
            }
            asm.delimiter();
            asm.eol();
        }

        public AllocatableValue getResult() {
            return this.lhs;
        }

        public Value getExpr() {
            return this.rhs;
        }
    }

    @Opcode(value="MARK_RELOCATE")
    public static class MarkRelocateInstruction
    extends AbstractInstruction {
        public static final LIRInstructionClass<MarkRelocateInstruction> TYPE = LIRInstructionClass.create(MarkRelocateInstruction.class);

        public MarkRelocateInstruction() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
        }
    }

    protected static abstract class AbstractInstruction
    extends LIRInstruction {
        protected AbstractInstruction(LIRInstructionClass<? extends AbstractInstruction> c) {
            super(c);
        }

        public final void emitCode(CompilationResultBuilder crb) {
            this.emitCode((OCLCompilationResultBuilder)crb, (OCLAssembler)crb.asm);
        }

        public abstract void emitCode(OCLCompilationResultBuilder var1, OCLAssembler var2);
    }
}

