/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble16;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble2;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble3;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble4;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble8;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat16;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat2;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat4;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat8;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf16;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf2;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf3;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf4;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf8;
import uk.ac.manchester.tornado.api.types.collections.VectorInt16;
import uk.ac.manchester.tornado.api.types.collections.VectorInt2;
import uk.ac.manchester.tornado.api.types.collections.VectorInt3;
import uk.ac.manchester.tornado.api.types.collections.VectorInt4;
import uk.ac.manchester.tornado.api.types.collections.VectorInt8;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageByte4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat8;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat4;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DFloat4;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Double16;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.Double3;
import uk.ac.manchester.tornado.api.types.vectors.Double4;
import uk.ac.manchester.tornado.api.types.vectors.Double8;
import uk.ac.manchester.tornado.api.types.vectors.Float16;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;
import uk.ac.manchester.tornado.api.types.vectors.Half16;
import uk.ac.manchester.tornado.api.types.vectors.Half2;
import uk.ac.manchester.tornado.api.types.vectors.Half3;
import uk.ac.manchester.tornado.api.types.vectors.Half4;
import uk.ac.manchester.tornado.api.types.vectors.Half8;
import uk.ac.manchester.tornado.api.types.vectors.Int16;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.vectors.Int4;
import uk.ac.manchester.tornado.api.types.vectors.Int8;
import uk.ac.manchester.tornado.api.types.vectors.Short2;
import uk.ac.manchester.tornado.api.types.vectors.Short3;
import uk.ac.manchester.tornado.api.types.volumes.VolumeShort2;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;

public enum OCLKind implements PlatformKind
{
    ATOMIC_ADD_INT(4, Integer.TYPE),
    ATOMIC_ADD_FLOAT(4, Float.TYPE),
    ATOMIC_SUB_INT(4, Integer.TYPE),
    ATOMIC_MUL_INT(4, Integer.TYPE),
    ATOMIC_ADD_LONG(8, Long.TYPE),
    BOOL(1, Boolean.TYPE),
    CHAR(1, Byte.TYPE),
    UCHAR(1, null),
    SHORT(2, Short.TYPE),
    USHORT(2, null),
    INT(4, Integer.TYPE),
    UINT(4, null),
    LONG(8, Long.TYPE),
    ULONG(8, null),
    HALF(2, Short.TYPE),
    FLOAT(4, Float.TYPE),
    DOUBLE(8, Double.TYPE),
    CHAR2(2, null, CHAR),
    UCHAR2(2, null, UCHAR),
    SHORT2(2, Short2.TYPE, SHORT),
    USHORT2(2, null, USHORT),
    VOLUMESHORT2(2, VolumeShort2.TYPE, SHORT),
    INT2(2, Int2.TYPE, INT),
    UINT2(2, null, UINT),
    LONG2(2, null, LONG),
    ULONG2(2, null, ULONG),
    FLOAT2(2, Float2.TYPE, FLOAT),
    DOUBLE2(2, Double2.TYPE, DOUBLE),
    HALF2(2, Half2.TYPE, HALF),
    VECTORDOUBLE2(2, VectorDouble2.TYPE, DOUBLE),
    VECTORINT2(2, VectorInt2.TYPE, INT),
    VECTORFLOAT2(2, VectorFloat2.TYPE, FLOAT),
    VECTORHALF2(2, VectorHalf2.TYPE, HALF),
    CHAR3(3, Byte3.TYPE, CHAR),
    IMAGEBYTE3(3, ImageByte3.TYPE, CHAR),
    UCHAR3(3, null, UCHAR),
    SHORT3(3, Short3.TYPE, SHORT),
    USHORT3(3, null, USHORT),
    INT3(3, Int3.TYPE, INT),
    UINT3(3, null, UINT),
    LONG3(3, null, LONG),
    ULONG3(3, null, ULONG),
    FLOAT3(3, Float3.TYPE, FLOAT),
    DOUBLE3(3, Double3.TYPE, DOUBLE),
    HALF3(3, Half3.TYPE, HALF),
    VECTORDOUBLE3(3, VectorDouble3.TYPE, DOUBLE),
    VECTORINT3(3, VectorInt3.TYPE, INT),
    VECTORFLOAT3(3, VectorFloat3.TYPE, FLOAT),
    VECTORHALF3(3, VectorHalf3.TYPE, HALF),
    IMAGEFLOAT3(3, ImageFloat3.TYPE, FLOAT),
    CHAR4(4, Byte4.TYPE, CHAR),
    IMAGEBYTE4(4, ImageByte4.TYPE, CHAR),
    UCHAR4(4, null, UCHAR),
    SHORT4(4, null, SHORT),
    USHORT4(4, null, USHORT),
    INT4(4, Int4.TYPE, INT),
    UINT4(4, null, UINT),
    LONG4(4, null, LONG),
    ULONG4(4, null, ULONG),
    FLOAT4(4, Float4.TYPE, FLOAT),
    HALF4(4, Half4.TYPE, HALF),
    MATRIX2DFLOAT4(4, Matrix2DFloat4.TYPE, FLOAT),
    MATRIX3DFLOAT4(4, Matrix3DFloat4.TYPE, FLOAT),
    MATRIX4X4FLOAT(4, Matrix4x4Float.TYPE, FLOAT),
    IMAGEFLOAT4(4, ImageFloat4.TYPE, FLOAT),
    DOUBLE4(4, Double4.TYPE, DOUBLE),
    VECTORDOUBLE4(4, VectorDouble4.TYPE, DOUBLE),
    VECTORINT4(4, VectorInt4.TYPE, INT),
    VECTORFLOAT4(4, VectorFloat4.TYPE, FLOAT),
    VECTORHALF4(4, VectorHalf4.TYPE, HALF),
    CHAR8(8, null, CHAR),
    UCHAR8(8, null, UCHAR),
    SHORT8(8, null, SHORT),
    USHORT8(8, null, USHORT),
    INT8(8, Int8.TYPE, INT),
    UINT8(8, null, UINT),
    LONG8(8, null, LONG),
    ULONG8(8, null, ULONG),
    FLOAT8(8, Float8.TYPE, FLOAT),
    DOUBLE8(8, Double8.TYPE, DOUBLE),
    HALF8(8, Half8.TYPE, HALF),
    VECTORDOUBLE8(8, VectorDouble8.TYPE, DOUBLE),
    VECTORDOUBLE16(16, VectorDouble16.TYPE, DOUBLE),
    VECTORINT8(8, VectorInt8.TYPE, INT),
    VECTORINT16(16, VectorInt16.TYPE, INT),
    VECTORFLOAT8(8, VectorFloat8.TYPE, FLOAT),
    VECTORHALF8(8, VectorHalf8.TYPE, HALF),
    VECTORFLOAT16(16, VectorFloat16.TYPE, FLOAT),
    VECTORHALF16(16, VectorHalf16.TYPE, HALF),
    IMAGEFLOAT8(8, ImageFloat8.TYPE, FLOAT),
    CHAR16(16, null, CHAR),
    UCHAR16(16, null, UCHAR),
    SHORT16(16, null, SHORT),
    USHORT16(16, null, USHORT),
    INT16(16, Int16.TYPE, INT),
    UINT16(16, null, UINT),
    LONG16(16, null, LONG),
    ULONG16(16, null, ULONG),
    DOUBLE16(16, Double16.TYPE, DOUBLE),
    FLOAT16(16, Float16.TYPE, FLOAT),
    HALF16(16, Half16.TYPE, HALF),
    ILLEGAL(0, null),
    INTEGER_ATOMIC_JAVA(4, AtomicInteger.class);

    private final int size;
    private final int vectorLength;
    private final OCLKind kind;
    private final OCLKind elementKind;
    private final Class<?> javaClass;
    private final PlatformKind.EnumKey key = new PlatformKind.EnumKey((Enum)this);

    private OCLKind(int size, Class<?> javaClass) {
        this(size, javaClass, null);
    }

    private OCLKind(int size, Class<?> javaClass, OCLKind kind) {
        this.kind = this;
        this.javaClass = javaClass;
        this.elementKind = kind;
        this.size = this.elementKind == null ? size : this.elementKind.size * size;
        this.vectorLength = this.elementKind == null ? 1 : size;
    }

    public static OCLKind fromResolvedJavaType(ResolvedJavaType type) {
        if (!type.isArray()) {
            for (OCLKind k : OCLKind.values()) {
                if (k.javaClass == null || !k.javaClass.getSimpleName().equalsIgnoreCase(type.getJavaKind().name()) && !k.javaClass.getSimpleName().equals(type.getUnqualifiedName())) continue;
                return k;
            }
        }
        return ILLEGAL;
    }

    public static OCLKind fromResolvedJavaKind(JavaKind javaKind) {
        for (OCLKind k : OCLKind.values()) {
            if (k.javaClass == null || !k.javaClass.getSimpleName().equalsIgnoreCase(javaKind.name())) continue;
            return k;
        }
        return ILLEGAL;
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivateTemplateType(JavaKind type) {
        if (type == JavaKind.Int) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_INT_ARRAY;
        }
        if (type == JavaKind.Double) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_DOUBLE_ARRAY;
        }
        if (type == JavaKind.Float) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_FLOAT_ARRAY;
        }
        if (type == JavaKind.Short) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_SHORT_ARRAY;
        }
        if (type == JavaKind.Long) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_LONG_ARRAY;
        }
        if (type == JavaKind.Char) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_CHAR_ARRAY;
        }
        if (type == JavaKind.Byte) {
            return OCLAssembler.OCLBinaryTemplate.NEW_PRIVATE_BYTE_ARRAY;
        }
        return null;
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivatePointerTemplate(JavaKind type) {
        return switch (type) {
            case JavaKind.Int -> OCLAssembler.OCLBinaryTemplate.PRIVATE_INT_ARRAY_PTR;
            case JavaKind.Double -> OCLAssembler.OCLBinaryTemplate.PRIVATE_DOUBLE_ARRAY_PTR;
            case JavaKind.Float -> OCLAssembler.OCLBinaryTemplate.PRIVATE_FLOAT_ARRAY_PTR;
            case JavaKind.Short -> OCLAssembler.OCLBinaryTemplate.PRIVATE_SHORT_ARRAY_PTR;
            case JavaKind.Long -> OCLAssembler.OCLBinaryTemplate.PRIVATE_LONG_ARRAY_PTR;
            case JavaKind.Char -> OCLAssembler.OCLBinaryTemplate.PRIVATE_CHAR_ARRAY_PTR;
            case JavaKind.Byte -> OCLAssembler.OCLBinaryTemplate.PRIVATE_BYTE_ARRAY_PTR;
            default -> null;
        };
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivatePointerCopyTemplate(JavaKind type) {
        return switch (type) {
            case JavaKind.Int -> OCLAssembler.OCLBinaryTemplate.PRIVATE_INT_ARRAY_PTR_COPY;
            case JavaKind.Double -> OCLAssembler.OCLBinaryTemplate.PRIVATE_DOUBLE_ARRAY_PTR_COPY;
            case JavaKind.Float -> OCLAssembler.OCLBinaryTemplate.PRIVATE_FLOAT_ARRAY_PTR_COPY;
            case JavaKind.Short -> OCLAssembler.OCLBinaryTemplate.PRIVATE_SHORT_ARRAY_PTR_COPY;
            case JavaKind.Long -> OCLAssembler.OCLBinaryTemplate.PRIVATE_LONG_ARRAY_PTR_COPY;
            case JavaKind.Char -> OCLAssembler.OCLBinaryTemplate.PRIVATE_CHAR_ARRAY_PTR_COPY;
            case JavaKind.Byte -> OCLAssembler.OCLBinaryTemplate.PRIVATE_BYTE_ARRAY_PTR_COPY;
            default -> null;
        };
    }

    public static OCLAssembler.OCLBinaryTemplate resolveTemplateType(JavaKind type, OCLKind kind) {
        if (type == JavaKind.Int) {
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_INT_ARRAY;
        }
        if (type == JavaKind.Double) {
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_DOUBLE_ARRAY;
        }
        if (type == JavaKind.Float) {
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_FLOAT_ARRAY;
        }
        if (type == JavaKind.Short) {
            if (kind == HALF) {
                return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_HALF_FLOAT_ARRAY;
            }
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_SHORT_ARRAY;
        }
        if (type == JavaKind.Long) {
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_LONG_ARRAY;
        }
        if (type == JavaKind.Char || type == JavaKind.Byte) {
            return OCLAssembler.OCLBinaryTemplate.NEW_LOCAL_CHAR_ARRAY;
        }
        return null;
    }

    public static OCLAssembler.OCLBinaryTemplate resolveTemplateType(ResolvedJavaType type, OCLKind kind) {
        return OCLKind.resolveTemplateType(type.getJavaKind(), kind);
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivateTemplateType(ResolvedJavaType type) {
        return OCLKind.resolvePrivateTemplateType(type.getJavaKind());
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivatePointerTemplate(ResolvedJavaType type) {
        return OCLKind.resolvePrivatePointerTemplate(type.getJavaKind());
    }

    public static OCLAssembler.OCLBinaryTemplate resolvePrivatePointerCopyTemplate(ResolvedJavaType type) {
        return OCLKind.resolvePrivatePointerCopyTemplate(type.getJavaKind());
    }

    public static OCLKind resolveToVectorKind(ResolvedJavaType type) {
        if (!type.isPrimitive() && type.getAnnotation(Vector.class) != null) {
            int index;
            String typeName = type.getName();
            String simpleName = typeName.substring((index = typeName.lastIndexOf("/")) + 1, typeName.length() - 1).toUpperCase();
            if (simpleName.startsWith("BYTE")) {
                simpleName = simpleName.replace("BYTE", "CHAR");
            }
            return OCLKind.valueOf(simpleName);
        }
        return ILLEGAL;
    }

    public static int lookupTypeIndex(OCLKind kind) {
        return switch (kind.ordinal()) {
            case 8 -> 0;
            case 10 -> 1;
            case 15 -> 2;
            case 6 -> 3;
            case 16 -> 4;
            case 14 -> 5;
            default -> -1;
        };
    }

    public static int lookupLengthIndex(int length) {
        return switch (length) {
            case 2 -> 0;
            case 3 -> 1;
            case 4 -> 2;
            case 8 -> 3;
            case 16 -> 4;
            default -> -1;
        };
    }

    public PlatformKind.Key getKey() {
        return this.key;
    }

    public int getSizeInBytes() {
        if (this.vectorLength == 3) {
            return this.size + this.elementKind.getSizeInBytes();
        }
        return this.size;
    }

    public Class<?> getJavaClass() {
        TornadoInternalError.guarantee((this.javaClass != null ? 1 : 0) != 0, (String)"undefined java class for: %s", (Object[])new Object[]{this});
        return this.javaClass;
    }

    public int getVectorLength() {
        return this.vectorLength;
    }

    public OCLKind getElementKind() {
        return this.isVector() ? this.elementKind : ILLEGAL;
    }

    public char getTypeChar() {
        switch (this.kind.ordinal()) {
            case 5: {
                return 'z';
            }
            case 6: 
            case 7: {
                return 'c';
            }
            case 8: 
            case 9: {
                return 's';
            }
            case 0: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                return 'i';
            }
            case 4: 
            case 12: 
            case 13: {
                return 'l';
            }
            case 14: {
                return 'h';
            }
            case 1: 
            case 15: {
                return 'f';
            }
            case 16: {
                return 'd';
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return 'v';
            }
        }
        return '-';
    }

    public String toString() {
        if (this == ATOMIC_ADD_INT) {
            return "int";
        }
        if (this == ATOMIC_SUB_INT) {
            return "int";
        }
        if (this == ATOMIC_MUL_INT) {
            return "int";
        }
        if (this == ATOMIC_ADD_LONG) {
            return "long";
        }
        if (this == ATOMIC_ADD_FLOAT) {
            return "float";
        }
        return this.name().toLowerCase();
    }

    public String getTypePrefix() {
        StringBuilder sb = new StringBuilder();
        if (this.isVector()) {
            sb.append('v');
            sb.append(this.getVectorLength());
        }
        if (this.isUnsigned()) {
            sb.append('u');
        }
        if (this.isVector()) {
            sb.append(this.getElementKind().getTypeChar());
        } else {
            sb.append(this.getTypeChar());
        }
        return sb.toString();
    }

    public boolean isUnsigned() {
        if (!this.isInteger()) {
            return false;
        }
        return this.kind.name().charAt(0) == 'U';
    }

    public boolean isInteger() {
        return this.kind != ILLEGAL && !this.isFloating();
    }

    public boolean isFloating() {
        return this.kind == FLOAT || this.kind == DOUBLE;
    }

    public boolean isHalf() {
        return this.kind == HALF2 || this.kind == HALF3 || this.kind == HALF4 || this.kind == HALF8 || this.kind == HALF16;
    }

    public boolean isVector() {
        return this.vectorLength > 1;
    }

    public boolean isPrimitive() {
        return this.vectorLength == 1 && this.kind != ILLEGAL;
    }

    public JavaConstant getDefaultValue() {
        if (!this.isVector()) {
            return JavaConstant.defaultForKind((JavaKind)this.asJavaKind());
        }
        TornadoInternalError.unimplemented();
        return JavaConstant.NULL_POINTER;
    }

    public int getByteCount() {
        return this.size;
    }

    public final int lookupLengthIndex() {
        return OCLKind.lookupLengthIndex(this.getVectorLength());
    }

    public final int lookupTypeIndex() {
        return OCLKind.lookupTypeIndex(this.getElementKind());
    }

    public JavaKind asJavaKind() {
        if (this.kind != ILLEGAL && !this.kind.isVector()) {
            switch (this.kind.ordinal()) {
                case 5: {
                    return JavaKind.Boolean;
                }
                case 6: 
                case 7: {
                    return JavaKind.Byte;
                }
                case 8: 
                case 9: {
                    return JavaKind.Short;
                }
                case 14: {
                    return JavaKind.Object;
                }
                case 10: 
                case 11: {
                    return JavaKind.Int;
                }
                case 12: 
                case 13: {
                    return JavaKind.Long;
                }
                case 15: {
                    return JavaKind.Float;
                }
                case 16: {
                    return JavaKind.Double;
                }
            }
            TornadoInternalError.shouldNotReachHere();
        }
        return JavaKind.Illegal;
    }
}

