/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import java.util.HashMap;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLNullary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorUtil;
import uk.ac.manchester.tornado.runtime.common.OCLTokens;

public class OCLGenTool {
    protected OCLLIRGenerator gen;
    private final HashMap<ParameterNode, Variable> parameterToVariable = new HashMap();

    public OCLGenTool(OCLLIRGenerator gen) {
        this.gen = gen;
    }

    public void emitVectorLoad(AllocatableValue result, OCLAssembler.OCLBinaryIntrinsic op, Value index, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitVectorLoad: %s = (%s) %s", (Object[])new Object[]{result.toString(), result.getPlatformKind().toString(), address.toString()});
        this.gen.append(new OCLLIRStmt.VectorLoadStmt(result, op, index, cast, address));
    }

    private String getParameterName(Local local) {
        Object parameterName = local.getName();
        if (OCLTokens.openCLTokens.contains(parameterName)) {
            parameterName = "_" + (String)parameterName;
        }
        return parameterName;
    }

    public Value emitParameterLoad(Local local, ParameterNode paramNode) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitParameterLoad: stamp=%s", (Object[])new Object[]{paramNode.stamp(NodeView.DEFAULT)});
        LIRKind lirKind = this.gen.getLIRKind(paramNode.stamp(NodeView.DEFAULT));
        OCLKind oclKind = (OCLKind)lirKind.getPlatformKind();
        OCLTargetDescription oclTarget = this.gen.target();
        Variable result = oclKind.isVector() ? this.gen.newVariable((ValueKind<?>)LIRKind.value((PlatformKind)oclTarget.getOCLKind(JavaKind.Object))) : this.gen.newVariable((ValueKind<?>)lirKind);
        String parameterName = this.getParameterName(local);
        this.gen.append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLNullary.Parameter(String.valueOf(OCLAssembler.OCLUnaryOp.CAST_TO_ULONG) + parameterName, lirKind)));
        this.parameterToVariable.put(paramNode, result);
        if (oclKind.isVector()) {
            Variable vector = this.gen.newVariable((ValueKind<?>)lirKind);
            OCLArchitecture.OCLMemoryBase base = OCLArchitecture.globalSpace;
            OCLAssembler.OCLBinaryIntrinsic intrinsic = VectorUtil.resolveLoadIntrinsic(oclKind);
            OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(base, LIRKind.value((PlatformKind)oclKind.getElementKind()));
            OCLUnary.MemoryAccess address = new OCLUnary.MemoryAccess(base, (Value)result);
            this.emitVectorLoad((AllocatableValue)vector, intrinsic, (Value)new ConstantValue((ValueKind)LIRKind.value((PlatformKind)OCLKind.INT), (Constant)PrimitiveConstant.INT_0), cast, address);
            result = vector;
        }
        return result;
    }

    public HashMap<ParameterNode, Variable> getParameterToVariable() {
        return this.parameterToVariable;
    }
}

