/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLUtils;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;

public class OCLDirectCall
extends OCLLIROp {
    protected DirectCallTargetNode target;
    protected LIRFrameState frameState;
    @LIRInstruction.Def
    protected Value result;
    @LIRInstruction.Use
    protected Value[] parameters;

    public OCLDirectCall(DirectCallTargetNode target, Value result, Value[] parameters, LIRFrameState frameState) {
        super(LIRKind.value((PlatformKind)result.getPlatformKind()));
        this.result = result;
        this.parameters = parameters;
        this.target = target;
        this.frameState = frameState;
    }

    @Override
    public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
        String methodName = OCLUtils.makeMethodName(this.target.targetMethod());
        asm.emit(methodName);
        asm.emit("(");
        int paramCounter = 0;
        asm.emit(((OCLArchitecture)crb.target.arch).getCallingConvention());
        asm.emit(", ");
        for (Value param : this.parameters) {
            asm.emit(asm.toString(param));
            if (paramCounter < this.parameters.length - 1) {
                asm.emit(", ");
            }
            ++paramCounter;
        }
        asm.emit(")");
        crb.addNonInlinedMethod(this.target.targetMethod());
    }
}

