/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

public class OCLControlFlow {

    public static class DeoptOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<DeoptOp> TYPE = LIRInstructionClass.create(DeoptOp.class);
        @LIRInstruction.Use
        private final Value actionAndReason;

        public DeoptOp(Value actionAndReason) {
            super(TYPE);
            this.actionAndReason = actionAndReason;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emit("slots[0] = (ulong) ");
            asm.emitValue(crb, this.actionAndReason);
            asm.delimiter();
            asm.eol();
            asm.ret();
        }
    }

    public static class LoopBreakOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<LoopBreakOp> TYPE = LIRInstructionClass.create(LoopBreakOp.class);

        public LoopBreakOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.loopBreak();
            asm.delimiter();
            asm.eol();
        }
    }

    public static class CaseBreakOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<CaseBreakOp> TYPE = LIRInstructionClass.create(CaseBreakOp.class);

        public CaseBreakOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitSymbol("break");
            asm.delimiter();
            asm.eol();
            asm.popIndent();
        }
    }

    public static class DefaultCaseOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<DefaultCaseOp> TYPE = LIRInstructionClass.create(DefaultCaseOp.class);

        public DefaultCaseOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitSymbol("default");
            asm.emitSymbol(":");
            asm.eol();
            asm.pushIndent();
        }
    }

    public static class CaseOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<CaseOp> TYPE = LIRInstructionClass.create(CaseOp.class);
        @LIRInstruction.Use
        private Constant value;

        public CaseOp(Constant value) {
            super(TYPE);
            this.value = value;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitSymbol("case");
            asm.space();
            asm.emitConstant(this.value);
            asm.emitSymbol(":");
            asm.eol();
            asm.pushIndent();
        }
    }

    public static class SwitchOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<SwitchOp> TYPE = LIRInstructionClass.create(SwitchOp.class);
        @LIRInstruction.Use
        private AllocatableValue value;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.CONST})
        private Constant[] keyConstants;
        @LIRInstruction.Use
        private LabelRef[] keyTargets;
        private LabelRef defaultTarget;

        public SwitchOp(AllocatableValue value, Constant[] keyConstants, LabelRef[] keyTargets, LabelRef defaultTarget) {
            super(TYPE);
            this.value = value;
            this.keyConstants = keyConstants;
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitSymbol("switch");
            asm.emitSymbol("(");
            asm.emitValue(crb, (Value)this.value);
            asm.emitSymbol(")");
            asm.emit(" ");
            asm.beginScope();
        }

        public Constant[] getKeyConstants() {
            return this.keyConstants;
        }

        public LabelRef[] getKeyTargets() {
            return this.keyTargets;
        }

        public LabelRef getDefaultTarget() {
            return this.defaultTarget;
        }
    }

    public static class ElseBranchOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<ElseBranchOp> TYPE = LIRInstructionClass.create(ElseBranchOp.class);

        public ElseBranchOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.elseStmt();
            asm.beginScope();
        }
    }

    public static class LinkedConditionalBranchOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<LinkedConditionalBranchOp> TYPE = LIRInstructionClass.create(LinkedConditionalBranchOp.class);
        @LIRInstruction.Use
        private final Value condition;

        public LinkedConditionalBranchOp(Value condition) {
            super(TYPE);
            this.condition = condition;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.elseIfStmt(crb, this.condition);
        }
    }

    public static class ConditionalBranchOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<ConditionalBranchOp> TYPE = LIRInstructionClass.create(ConditionalBranchOp.class);
        @LIRInstruction.Use
        private final Value condition;

        public ConditionalBranchOp(Value condition) {
            super(TYPE);
            this.condition = condition;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.ifStmt(crb, this.condition);
        }
    }

    public static class LoopConditionOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<LoopConditionOp> TYPE = LIRInstructionClass.create(LoopConditionOp.class);
        @LIRInstruction.Use
        private final Value condition;
        private boolean generateIfBreakStatement = true;

        public LoopConditionOp(Value condition) {
            super(TYPE);
            this.condition = condition;
        }

        public void setGenerateIfBreakStatement(boolean value) {
            this.generateIfBreakStatement = value;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            if (this.generateIfBreakStatement) {
                asm.indent();
                asm.emitSymbol("if");
                asm.emitSymbol("(");
                asm.emitSymbol("!");
                asm.emitSymbol("(");
            }
            if (this.condition instanceof OCLLIROp) {
                ((OCLLIROp)this.condition).emit(crb, asm);
            } else {
                asm.emitValue(crb, this.condition);
            }
            if (this.condition.getPlatformKind() == OCLKind.INT) {
                asm.emit(" == 1");
            }
            if (this.generateIfBreakStatement) {
                asm.emitSymbol(")");
                asm.emitSymbol(")");
                asm.eol();
                asm.beginScope();
                asm.indent();
                asm.emitSymbol("break");
                asm.delimiter();
                asm.eol();
                asm.endScope();
            }
        }
    }

    public static class LoopPostOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<LoopPostOp> TYPE = LIRInstructionClass.create(LoopPostOp.class);

        public LoopPostOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.delimiter();
            asm.emitSymbol(")");
            asm.indentOn();
            asm.eolOn();
            asm.eol();
            asm.beginScope();
        }
    }

    public static class LoopInitOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<LoopInitOp> TYPE = LIRInstructionClass.create(LoopInitOp.class);

        public LoopInitOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.indent();
            asm.emitSymbol("for");
            asm.emitSymbol("(");
            asm.delimiter();
            asm.indentOff();
            asm.eolOff();
        }
    }

    public static final class BeginScopeOp
    extends OCLLIRStmt.AbstractInstruction {
        public static final LIRInstructionClass<BeginScopeOp> TYPE = LIRInstructionClass.create(BeginScopeOp.class);

        public BeginScopeOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.beginScope();
        }
    }

    public static final class EndScopeOp
    extends AbstractBlockEndOp {
        public static final LIRInstructionClass<EndScopeOp> TYPE = LIRInstructionClass.create(EndScopeOp.class);

        public EndScopeOp() {
            super(TYPE);
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.endScope("End");
        }
    }

    public static final class ReturnOp
    extends AbstractBlockEndOp {
        public static final LIRInstructionClass<ReturnOp> TYPE = LIRInstructionClass.create(ReturnOp.class);
        @LIRInstruction.Use
        private Value x;

        public ReturnOp(Value x) {
            super(TYPE);
            this.x = x;
        }

        @Override
        public void emitCode(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            crb.frameContext.leave((CompilationResultBuilder)crb);
            asm.ret();
        }
    }

    protected static abstract class AbstractBlockEndOp
    extends OCLLIRStmt.AbstractInstruction
    implements StandardOp.BlockEndOp {
        protected AbstractBlockEndOp(LIRInstructionClass<? extends OCLLIRStmt.AbstractInstruction> type) {
            super(type);
        }
    }
}

