/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.Variable;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLTernary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLBuiltinTool {
    public Value genFloatACos(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAcos: acos(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ACOS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatACosh(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAcosh: acosh(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ACOSH, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatACospi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatASin(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAsin: asin(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ASIN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatASinh(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAsinh: asinh(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ASINH, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatASinpi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatATan(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAtan: atan(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ATAN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatATanh(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatATanpi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatCbrt(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatCeil(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genCeil: ceil(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.CEIL, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatCos(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genCos: cos(%s)", (Object[])new Object[]{input});
        if (TornadoOptions.ENABLE_NATIVE_FUNCTION) {
            return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.NATIVE_COS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
        }
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.COS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatCosh(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatCospi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatErfc(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatErf(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatExp(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genExp: exp(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.EXP, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatExp2(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatExp10(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatExpm1(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatFloor(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatFloor: floor(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.FLOAT_FLOOR, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatILogb(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLGamma(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLog(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genLog: log(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.LOG, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatRadians(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatRadians: radians(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.RADIANS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatCosPI(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatCosPI: cospi(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.COSPI, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatSinPI(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatCosPI: sinpi(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.SINPI, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatLog2(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLog10(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLog1p(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLogb(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatNan(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRint(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRound(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRSqrt(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatSign(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genSign: sign(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.SIGN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatSin(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genSin: sin(%s)", (Object[])new Object[]{input});
        if (TornadoOptions.ENABLE_NATIVE_FUNCTION) {
            return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.NATIVE_SIN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
        }
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.SIN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatSinh(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatSinpi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatTan(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genTan: tan(%s)", (Object[])new Object[]{input});
        if (TornadoOptions.ENABLE_NATIVE_FUNCTION) {
            return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.NATIVE_TAN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
        }
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.TAN, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatTanh(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genTanh: tanh(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.TANH, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatTanpi(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatTGamma(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatTrunc(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatTrunc: trunc(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.FLOAT_TRUNC, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatATan2(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatAtan2: atan(%s, %s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.ATAN2, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genFloatATan2pi(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatCopySign(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatDim(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatFma(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatMax(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatMax: max(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.FLOAT_MAX, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genFloatMin(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatMin: min(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.FLOAT_MIN, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genFloatMod(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatFract(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatFrexp(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatHypot(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatLdexp(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatMad(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatMaxmag(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatMinmag(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatModf(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatNextAfter(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatPow(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatPow: pow(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.FLOAT_POW, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genFloatPown(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatPowr(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRemainder(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRootn(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatSincos(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable genBitCount(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable genBitScanForward(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable genBitScanReverse(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genIntAbs(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genIntAbs: abs(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.ABS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatSqrt(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genAbs: sqrt(%s)", (Object[])new Object[]{input});
        if (TornadoOptions.ENABLE_NATIVE_FUNCTION) {
            return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.NATIVE_SQRT, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
        }
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.SQRT, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genIntMax(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genMax: max(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.INT_MAX, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genIntMin(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genMin: min(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.INT_MIN, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genIntClz(Value value) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genIntPopcount(Value value) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genBitCount: bitcount(%s)", (Object[])new Object[]{value});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.POPCOUNT, LIRKind.value((PlatformKind)value.getPlatformKind()), value);
    }

    public Value genIntClamp(Value x, Value y, Value z) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genIntClamp: clamp(%s, %s, %s)", (Object[])new Object[]{x, y, z});
        return new OCLTernary.Intrinsic(OCLAssembler.OCLTernaryIntrinsic.CLAMP, LIRKind.combine((Value[])new Value[]{x, y, z}), x, y, z);
    }

    public Value genIntMad24(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genIntMadHi(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genIntMadSat(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatAbs(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genFloatAbs: abs(%s)", (Object[])new Object[]{input});
        return new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.FLOAT_ABS, LIRKind.value((PlatformKind)input.getPlatformKind()), input);
    }

    public Value genFloatFMA(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatMAD(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genFloatRemquo(Value x, Value y, Value z) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value genGeometricDot(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genDot: dot(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.DOT, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value genGeometricCross(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"genCross: cross(%s,%s)", (Object[])new Object[]{x, y});
        return new OCLBinary.Intrinsic(OCLAssembler.OCLBinaryIntrinsic.CROSS, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }
}

