/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Opcode;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;

public class OCLBinary {

    public static class Selector
    extends Expr {
        public Selector(OCLAssembler.OCLBinaryOp opcode, LIRKind lirKind, Value x, Value y) {
            super(opcode, lirKind, x, y);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emitValue(crb, this.x);
            asm.emit(this.opcode.toString());
            asm.emitValue(crb, this.y);
        }

        @Override
        public String toString() {
            return String.format("%s.%s", this.opcode.toString(), this.x, this.y);
        }
    }

    public static class Intrinsic
    extends BinaryConsumer {
        public Intrinsic(OCLAssembler.OCLBinaryIntrinsic opcode, LIRKind lirKind, Value x, Value y) {
            super(opcode, lirKind, x, y);
        }

        @Override
        public String toString() {
            return String.format("%s(%s, %s)", this.opcode.toString(), this.x, this.y);
        }
    }

    public static class TestNegateZeroExpression
    extends BinaryConsumer {
        public TestNegateZeroExpression(OCLAssembler.OCLBinaryOp opcode, LIRKind lirKind, Value x, Value y) {
            super(opcode, lirKind, x, y);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("!((");
            asm.emitValue(crb, this.x);
            asm.emit(" ");
            asm.emit(this.opcode.toString());
            asm.emit(" ");
            asm.emitValue(crb, this.y);
            asm.emit(")");
            asm.emit(" == 0)");
        }
    }

    public static class TestZeroExpression
    extends BinaryConsumer {
        public TestZeroExpression(OCLAssembler.OCLBinaryOp opcode, LIRKind lirKind, Value x, Value y) {
            super(opcode, lirKind, x, y);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            asm.emit("(");
            asm.emitValue(crb, this.x);
            asm.emit(" ");
            asm.emit(this.opcode.toString());
            asm.emit(" ");
            asm.emitValue(crb, this.y);
            asm.emit(")");
            asm.emit(" == 0");
        }
    }

    public static class Expr
    extends BinaryConsumer {
        public Expr(OCLAssembler.OCLBinaryOp opcode, LIRKind lirKind, Value x, Value y) {
            super(opcode, lirKind, x, y);
        }
    }

    protected static class BinaryConsumer
    extends OCLLIROp {
        @Opcode
        protected final OCLAssembler.OCLBinaryOp opcode;
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use
        protected Value y;

        protected BinaryConsumer(OCLAssembler.OCLBinaryOp opcode, LIRKind lirKind, Value x, Value y) {
            super(lirKind);
            this.opcode = opcode;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, OCLAssembler asm) {
            this.opcode.emit(crb, this.x, this.y);
        }

        public Value getX() {
            return this.x;
        }

        public Value getY() {
            return this.y;
        }

        public String toString() {
            return String.format("%s %s %s", this.opcode.toString(), this.x, this.y);
        }
    }
}

