/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.memory.MemoryExtendKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.common.code.CodeUtil;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLLIRKindTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLTernary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.meta.OCLMemorySpace;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorUtil;

public class OCLArithmeticTool
extends ArithmeticLIRGenerator {
    public OCLLIRGenerator getGen() {
        return (OCLLIRGenerator)this.getLIRGen();
    }

    public OCLLIROp genBinaryExpr(OCLAssembler.OCLBinaryOp op, LIRKind lirKind, Value x, Value y) {
        return new OCLBinary.Expr(op, lirKind, x, y);
    }

    public OCLLIROp genTestBinaryExpr(OCLAssembler.OCLBinaryOp op, LIRKind lirKind, Value x, Value y) {
        return new OCLBinary.TestZeroExpression(op, lirKind, x, y);
    }

    public OCLLIROp genTestNegateBinaryExpr(OCLAssembler.OCLBinaryOp op, LIRKind lirKind, Value x, Value y) {
        return new OCLBinary.TestNegateZeroExpression(op, lirKind, x, y);
    }

    public OCLLIROp genBinaryIntrinsic(OCLAssembler.OCLBinaryIntrinsic op, LIRKind lirKind, Value x, Value y) {
        return new OCLBinary.Intrinsic(op, lirKind, x, y);
    }

    public Variable emitBinaryAssign(OCLAssembler.OCLBinaryOp op, LIRKind lirKind, Value x, Value y) {
        Variable result = this.getGen().newVariable((ValueKind<?>)lirKind);
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, this.genBinaryExpr(op, lirKind, x, y)));
        return result;
    }

    public Variable emitBinaryAssign(OCLAssembler.OCLBinaryIntrinsic op, LIRKind lirKind, Value x, Value y) {
        Variable result = this.getGen().newVariable((ValueKind<?>)lirKind);
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, this.genBinaryIntrinsic(op, lirKind, x, y)));
        return result;
    }

    public OCLLIROp genUnaryExpr(OCLAssembler.OCLUnaryOp op, LIRKind lirKind, Value value) {
        return new OCLUnary.Expr(op, lirKind, value);
    }

    public OCLLIROp genUnaryExpr(OCLAssembler.OCLUnaryIntrinsic op, LIRKind lirKind, Value value) {
        return new OCLUnary.Intrinsic(op, lirKind, value);
    }

    public Variable emitUnaryAssign(OCLAssembler.OCLUnaryOp op, LIRKind lirKind, Value value) {
        Variable result = this.getGen().newVariable((ValueKind<?>)lirKind);
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, this.genUnaryExpr(op, lirKind, value)));
        return result;
    }

    public Variable emitUnaryAssign(OCLAssembler.OCLUnaryIntrinsic op, LIRKind lirKind, Value value) {
        Variable result = this.getGen().newVariable((ValueKind<?>)lirKind);
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, this.genUnaryExpr(op, lirKind, value)));
        return result;
    }

    public Variable emitAdd(LIRKind lirKind, Value x, Value y, boolean setFlags) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitAdd: %s + %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.ADD, lirKind, x, y);
    }

    public Value emitAnd(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitAnd: %s & %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_AND, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitDiv(Value x, Value y, LIRFrameState frameState) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitDiv: %s / %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.DIV, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitFloatConvert(FloatConvert floatConvert, Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitFloatConvert: (%s) %s", (Object[])new Object[]{floatConvert, input});
        switch (floatConvert) {
            case I2D: {
                return this.emitUnaryAssign(OCLAssembler.OCLUnaryOp.CAST_TO_DOUBLE, LIRKind.value((PlatformKind)OCLKind.DOUBLE), input);
            }
        }
        TornadoInternalError.unimplemented((String)"float convert %s", (Object[])new Object[]{floatConvert});
        return null;
    }

    public Value emitMul(Value x, Value y, boolean setFlags) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitMul: %s * %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.MUL, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitMulHigh(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitNegate(Value x, boolean setFlags) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitNegate: - %s", (Object[])new Object[]{x});
        return this.emitUnaryAssign(OCLAssembler.OCLUnaryOp.NEGATE, LIRKind.combine((Value[])new Value[]{x}), x);
    }

    public Value emitNot(Value x) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitNot: ~ %s", (Object[])new Object[]{x});
        return this.emitUnaryAssign(OCLAssembler.OCLUnaryOp.BITWISE_NOT, LIRKind.combine((Value[])new Value[]{x}), x);
    }

    public Value emitOr(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitOr: %s | %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_OR, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitReinterpret(LIRKind lirKind, Value x) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitRem(Value x, Value y, LIRFrameState frameState) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitRem: %s %% %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.MOD, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitShl(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitShl: %s << %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_LEFT_SHIFT, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitShr(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitShr: %s >> %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_RIGHT_SHIFT, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    private OCLAssembler.OCLUnaryOp getSignExtendOp(int toBits) {
        return switch (toBits) {
            case 8 -> OCLAssembler.OCLUnaryOp.CAST_TO_BYTE;
            case 16 -> OCLAssembler.OCLUnaryOp.CAST_TO_SHORT;
            case 32 -> OCLAssembler.OCLUnaryOp.CAST_TO_INT;
            case 64 -> OCLAssembler.OCLUnaryOp.CAST_TO_LONG;
            default -> throw new UnsupportedOperationException("Unimplemented case for toBits: " + toBits);
        };
    }

    public Value emitNarrow(Value x, int toBits) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitNarrow: %s, %d", (Object[])new Object[]{x, toBits});
        LIRKind lirKind = this.getGen().getLIRKindTool().getIntegerKind(toBits);
        return this.emitUnaryAssign(this.getSignExtendOp(toBits), lirKind, x);
    }

    public Value emitSignExtend(Value x, int fromBits, int toBits) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitSignExtend: %s, %d, %d", (Object[])new Object[]{x, fromBits, toBits});
        LIRKind lirKind = this.getGen().getLIRKindTool().getIntegerKind(toBits);
        return this.emitUnaryAssign(this.getSignExtendOp(toBits), lirKind, x);
    }

    public Variable emitSub(LIRKind lirKind, Value x, Value y, boolean setFlags) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitSub: %s - %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.SUB, lirKind, x, y);
    }

    public Value emitUDiv(Value x, Value y, LIRFrameState frameState) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitUMulHigh(Value x, Value y) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitURem(Value x, Value y, LIRFrameState frameState) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitURem: %s %% %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.MOD, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitUShr(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitUShr: %s >>> %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_RIGHT_SHIFT, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitXor(Value x, Value y) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitXor: %s ^ %s", (Object[])new Object[]{x, y});
        return this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_XOR, LIRKind.combine((Value[])new Value[]{x, y}), x, y);
    }

    public Value emitXorFP(Value a, Value b) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitZeroExtend(Value value, int fromBits, int toBits) {
        LIRKind toKind;
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitZeroExtend: %s (from %d to %d)", (Object[])new Object[]{value, fromBits, toBits});
        OCLLIRKindTool kindTool = this.getGen().getLIRKindTool();
        OCLKind kind = (OCLKind)value.getPlatformKind();
        if (kind.isInteger()) {
            toKind = kindTool.getUnsignedIntegerKind(toBits);
        } else if (kind.isFloating()) {
            toKind = kindTool.getFloatingKind(toBits);
        } else {
            throw TornadoInternalError.shouldNotReachHere();
        }
        ConstantValue mask = new ConstantValue((ValueKind)toKind, (Constant)JavaConstant.forIntegerKind((JavaKind)CodeUtil.javaKindFromBitSize((int)toBits, (boolean)kind.isFloating()), (long)((1L << fromBits) - 1L)));
        Variable result = this.emitBinaryAssign(OCLAssembler.OCLBinaryOp.BITWISE_AND, toKind, value, (Value)mask);
        return result;
    }

    protected boolean isNumericInteger(PlatformKind platformKind) {
        TornadoInternalError.guarantee((boolean)(platformKind instanceof OCLKind), (String)"invalid platform kind", (Object[])new Object[0]);
        return ((OCLKind)platformKind).isInteger();
    }

    public void emitLoad(AllocatableValue result, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitLoad: %s = (%s) %s", (Object[])new Object[]{result.toString(), result.getPlatformKind().toString(), address.toString()});
        if (this.shouldEmitIntegerIndexes(cast)) {
            this.getGen().append(new OCLLIRStmt.LoadStmt(result, cast, address, address.getIndex()));
        } else {
            this.getGen().append(new OCLLIRStmt.LoadStmt(result, cast, address));
        }
    }

    private boolean shouldEmitIntegerIndexes(OCLUnary.OCLAddressCast cast) {
        return cast.getMemorySpace().name() == "__local" || cast.getMemorySpace().name() == "__private";
    }

    public void emitVectorLoad(AllocatableValue result, OCLAssembler.OCLBinaryIntrinsic op, Value index, OCLUnary.OCLAddressCast cast, OCLUnary.MemoryAccess address) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitVectorLoad: %s = (%s) %s", (Object[])new Object[]{result.toString(), result.getPlatformKind().toString(), address.toString()});
        this.getGen().append(new OCLLIRStmt.VectorLoadStmt(result, op, index, cast, address));
    }

    public Variable emitBitCount(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable emitBitScanForward(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable emitBitScanReverse(Value input) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, MemoryExtendKind extendKind) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitLoad: %s <- %s\nstate:%s", (Object[])new Object[]{kind, address, state});
        Variable result = this.getGen().newVariable((ValueKind<?>)kind);
        TornadoInternalError.guarantee((boolean)(kind.getPlatformKind() instanceof OCLKind), (String)"invalid LIRKind: %s", (Object[])new Object[]{kind});
        OCLKind oclKind = (OCLKind)kind.getPlatformKind();
        OCLArchitecture.OCLMemoryBase base = ((OCLUnary.MemoryAccess)address).getBase();
        if (oclKind.isVector()) {
            OCLAssembler.OCLBinaryIntrinsic intrinsic = VectorUtil.resolveLoadIntrinsic(oclKind);
            OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(base, LIRKind.value((PlatformKind)oclKind.getElementKind()));
            this.emitVectorLoad((AllocatableValue)result, intrinsic, this.getOffsetValue(oclKind, (OCLUnary.MemoryAccess)address), cast, (OCLUnary.MemoryAccess)address);
        } else {
            OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(base, kind);
            this.emitLoad((AllocatableValue)result, cast, (OCLUnary.MemoryAccess)address);
        }
        return result;
    }

    public void emitStore(ValueKind<?> kind, Value address, Value input, LIRFrameState state, MemoryOrderMode memoryOrder) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitStore: kind=%s, address=%s, input=%s", (Object[])new Object[]{kind, address, input});
        TornadoInternalError.guarantee((boolean)(kind.getPlatformKind() instanceof OCLKind), (String)"invalid LIRKind: %s", (Object[])new Object[]{kind});
        OCLKind oclKind = (OCLKind)kind.getPlatformKind();
        OCLUnary.MemoryAccess memAccess = null;
        Value accumulator = null;
        if (address instanceof OCLUnary.MemoryAccess) {
            memAccess = (OCLUnary.MemoryAccess)address;
        } else {
            accumulator = address;
        }
        if (oclKind.isVector()) {
            OCLAssembler.OCLTernaryIntrinsic intrinsic = VectorUtil.resolveStoreIntrinsic(oclKind);
            assert (memAccess != null);
            OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind.getElementKind()));
            this.getGen().append(new OCLLIRStmt.VectorStoreStmt(intrinsic, this.getOffsetValue(oclKind, memAccess), cast, memAccess, input));
        } else if (oclKind == OCLKind.ATOMIC_ADD_INT || oclKind == OCLKind.ATOMIC_ADD_LONG) {
            if (memAccess != null) {
                OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind));
                this.getGen().append(new OCLLIRStmt.StoreAtomicAddStmt(cast, memAccess, input));
            } else {
                this.getGen().append(new OCLLIRStmt.StoreAtomicAddStmt(accumulator, input));
            }
        } else if (oclKind == OCLKind.ATOMIC_SUB_INT) {
            if (memAccess != null) {
                OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind));
                this.getGen().append(new OCLLIRStmt.StoreAtomicSubStmt(cast, memAccess, input));
            } else {
                this.getGen().append(new OCLLIRStmt.StoreAtomicSubStmt(accumulator, input));
            }
        } else if (oclKind == OCLKind.ATOMIC_MUL_INT) {
            if (memAccess != null) {
                OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind));
                this.getGen().append(new OCLLIRStmt.StoreAtomicMulStmt(cast, memAccess, input));
            } else {
                this.getGen().append(new OCLLIRStmt.StoreAtomicMulStmt(accumulator, input));
            }
        } else if (oclKind == OCLKind.ATOMIC_ADD_FLOAT) {
            if (memAccess != null) {
                OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind));
                this.getGen().append(new OCLLIRStmt.StoreAtomicAddFloatStmt(cast, memAccess, input));
            } else {
                this.getGen().append(new OCLLIRStmt.StoreAtomicAddFloatStmt(accumulator, input));
            }
        } else if (memAccess != null) {
            OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(memAccess.getBase(), LIRKind.value((PlatformKind)oclKind));
            if (memAccess.getIndex() == null) {
                this.getGen().append(new OCLLIRStmt.StoreStmt(cast, memAccess, input));
            } else {
                this.getGen().append(new OCLLIRStmt.StoreStmt(cast, memAccess, input, memAccess.getIndex()));
            }
        } else {
            this.getGen().append(new OCLLIRStmt.StoreAtomicAddStmt(accumulator, input));
        }
    }

    public Value emitMathAbs(Value input) {
        OCLBuiltinTool builtinTool = this.getGen().getOCLBuiltinTool();
        OCLKind oclKind = (OCLKind)input.getPlatformKind();
        Variable result = this.getGen().newVariable(input.getValueKind());
        if (oclKind.isFloating()) {
            this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, builtinTool.genFloatAbs(input)));
        } else {
            TornadoInternalError.shouldNotReachHere();
        }
        return result;
    }

    public Value emitMathSqrt(Value input) {
        OCLBuiltinTool builtinTool = this.getGen().getOCLBuiltinTool();
        OCLKind oclKind = (OCLKind)input.getPlatformKind();
        Variable result = this.getGen().newVariable(input.getValueKind());
        if (oclKind.isFloating()) {
            this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, builtinTool.genFloatSqrt(input)));
        } else {
            TornadoInternalError.shouldNotReachHere();
        }
        return result;
    }

    public Value emitMathSignum(Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitMathSignum: input=%s", (Object[])new Object[]{input});
        OCLBuiltinTool builtinTool = this.getGen().getOCLBuiltinTool();
        Variable result = this.getGen().newVariable(input.getValueKind());
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, builtinTool.genFloatSign(input)));
        return result;
    }

    public Value emitMathCopySign(Value magnitude, Value sign) {
        TornadoInternalError.unimplemented();
        return null;
    }

    private Value getPrivateOffsetValue(OCLKind oclKind, OCLUnary.MemoryAccess memoryAccess) {
        if (memoryAccess == null) {
            return null;
        }
        if (memoryAccess.getIndex() instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)memoryAccess.getIndex();
            int parsedIntegerIndex = Integer.parseInt(constantValue.getConstant().toValueString());
            int index = parsedIntegerIndex / oclKind.getVectorLength();
            return new ConstantValue((ValueKind)LIRKind.value((PlatformKind)OCLKind.INT), (Constant)JavaConstant.forInt((int)index));
        }
        int index = Integer.parseInt(OCLAssembler.getAbsoluteIndexFromValue(memoryAccess.getIndex())) / oclKind.getVectorLength();
        return new ConstantValue((ValueKind)LIRKind.value((PlatformKind)OCLKind.INT), (Constant)JavaConstant.forInt((int)index));
    }

    private Value getOffsetValue(OCLKind oclKind, OCLUnary.MemoryAccess memoryAccess) {
        if (memoryAccess.getBase().getMemorySpace() == OCLMemorySpace.GLOBAL.getBase().getMemorySpace()) {
            return new ConstantValue((ValueKind)LIRKind.value((PlatformKind)OCLKind.INT), (Constant)PrimitiveConstant.INT_0);
        }
        return this.getPrivateOffsetValue(oclKind, memoryAccess);
    }

    public Value emitFMAInstruction(Value op1, Value op2, Value op3) {
        LIRKind resultKind = LIRKind.combine((Value[])new Value[]{op1, op2, op3});
        Variable result = this.getGen().newVariable((ValueKind<?>)resultKind);
        OCLAssembler.OCLTernaryIntrinsic operation = OCLAssembler.OCLTernaryIntrinsic.FMA;
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLTernary.Expr(operation, resultKind, op1, op2, op3)));
        return result;
    }

    public Value emitRSQRT(Value op) {
        LIRKind resultKind = LIRKind.value((PlatformKind)op.getPlatformKind());
        Variable result = this.getGen().newVariable((ValueKind<?>)resultKind);
        this.getGen().append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLUnary.Intrinsic(OCLAssembler.OCLUnaryIntrinsic.RSQRT, LIRKind.value((PlatformKind)op.getPlatformKind()), op)));
        return result;
    }
}

