/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;

@NodeInfo
public class OCLAddressNode
extends AddressNode
implements LIRLowerable {
    public static final NodeClass<OCLAddressNode> TYPE = NodeClass.create(OCLAddressNode.class);
    @Node.OptionalInput
    private ValueNode base;
    @Node.OptionalInput
    private ValueNode index;
    private OCLArchitecture.OCLMemoryBase memoryRegister;

    public OCLAddressNode(ValueNode base, ValueNode index, OCLArchitecture.OCLMemoryBase memoryRegister) {
        super(TYPE);
        this.base = base;
        this.index = index;
        this.memoryRegister = memoryRegister;
    }

    public OCLAddressNode(ValueNode base, ValueNode index) {
        super(TYPE);
        this.base = base;
        this.index = index;
    }

    public void generate(NodeLIRBuilderTool gen) {
        AllocatableValue indexValue;
        OCLStamp stamp;
        OCLKind kind;
        AllocatableValue baseValue;
        OCLLIRGenerator tool = (OCLLIRGenerator)gen.getLIRGeneratorTool();
        Object object = baseValue = this.base == null ? Value.ILLEGAL : gen.operand((Node)this.base);
        if (this.base instanceof ParameterNode && this.base.stamp(NodeView.DEFAULT) instanceof OCLStamp && (kind = (stamp = (OCLStamp)this.base.stamp(NodeView.DEFAULT)).getOCLKind()).isVector()) {
            baseValue = (Value)tool.getOclGenTool().getParameterToVariable().get(this.base);
        }
        Object object2 = indexValue = this.index == null ? Value.ILLEGAL : gen.operand((Node)this.index);
        if (this.index == null) {
            gen.setResult((ValueNode)this, (Value)new OCLUnary.MemoryAccess(this.memoryRegister, (Value)baseValue));
        } else {
            this.setMemoryAccess(gen, (Value)baseValue, (Value)indexValue, tool);
        }
    }

    private boolean isLocalMemoryAccess() {
        return this.memoryRegister.getName().equals("_local_region");
    }

    private boolean isPrivateMemoryAccess() {
        return this.memoryRegister.getName().equals("_private_region");
    }

    public ValueNode getBase() {
        return this.base;
    }

    public ValueNode getIndex() {
        return this.index;
    }

    public long getMaxConstantDisplacement() {
        return 0L;
    }

    private void setMemoryAccess(NodeLIRBuilderTool gen, Value baseValue, Value indexValue, OCLLIRGenerator tool) {
        if (this.isLocalMemoryAccess() || this.isPrivateMemoryAccess()) {
            gen.setResult((ValueNode)this, (Value)new OCLUnary.MemoryAccess(this.memoryRegister, baseValue, indexValue));
        } else {
            Variable addressValue = tool.getArithmetic().emitAdd(baseValue, indexValue, false);
            gen.setResult((ValueNode)this, (Value)new OCLUnary.MemoryAccess(this.memoryRegister, (Value)addressValue));
        }
    }
}

