/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.lir;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLAddressNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FixedArrayCopyNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FixedArrayNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalArrayNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.calc.TornadoAddressArithmeticNode;

public class OCLAddressLowering
extends AddressLoweringByNodePhase.AddressLowering {
    public AddressNode lower(ValueNode base, ValueNode offset) {
        OCLArchitecture.OCLMemoryBase memoryRegister = OCLArchitecture.globalSpace;
        if (base instanceof FixedArrayNode) {
            FixedArrayNode fixedArrayNode = (FixedArrayNode)base;
            memoryRegister = fixedArrayNode.getMemoryRegister();
        } else if (base instanceof FixedArrayCopyNode) {
            FixedArrayCopyNode fixedArrayCopyNode = (FixedArrayCopyNode)base;
            memoryRegister = fixedArrayCopyNode.getMemoryRegister();
        } else if (base instanceof LocalArrayNode) {
            LocalArrayNode localArrayNode = (LocalArrayNode)base;
            memoryRegister = localArrayNode.getMemoryRegister();
        } else if (!(base instanceof TornadoAddressArithmeticNode || base instanceof ParameterNode || base instanceof ReadNode || base instanceof FloatingReadNode || base instanceof PiNode)) {
            TornadoInternalError.unimplemented((String)"address origin unimplemented: %s", (Object[])new Object[]{base.getClass().getName()});
        }
        OCLAddressNode result = new OCLAddressNode(base, offset, memoryRegister);
        return (AddressNode)base.graph().unique((Node)result);
    }
}

