/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins;

import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import uk.ac.manchester.tornado.api.exceptions.TornadoCompilationException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Double16;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.Double3;
import uk.ac.manchester.tornado.api.types.vectors.Double4;
import uk.ac.manchester.tornado.api.types.vectors.Double8;
import uk.ac.manchester.tornado.api.types.vectors.Float16;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;
import uk.ac.manchester.tornado.api.types.vectors.Half16;
import uk.ac.manchester.tornado.api.types.vectors.Half2;
import uk.ac.manchester.tornado.api.types.vectors.Half3;
import uk.ac.manchester.tornado.api.types.vectors.Half4;
import uk.ac.manchester.tornado.api.types.vectors.Half8;
import uk.ac.manchester.tornado.api.types.vectors.Int16;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.vectors.Int4;
import uk.ac.manchester.tornado.api.types.vectors.Int8;
import uk.ac.manchester.tornado.api.types.vectors.Short2;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.GetArrayNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.LoadIndexedVectorNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorAddNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorDivNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorLoadElementNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorMulNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorStoreElementProxyNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorStoreGlobalMemory;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorSubNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.PanamaPrivateMemoryNode;

public final class OCLVectorPlugins {
    public static void registerPlugins(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins) {
        ps.appendNodePlugin(new NodePlugin(){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                OCLKind vectorKind = OCLKind.resolveToVectorKind(method.getDeclaringClass());
                if (vectorKind == OCLKind.ILLEGAL) {
                    return false;
                }
                if (method.getName().equals("<init>")) {
                    VectorValueNode vector = OCLVectorPlugins.resolveReceiver(args[0]);
                    if (args.length > 1) {
                        int offset;
                        for (int i = offset = vector == args[0] ? 1 : 0; i < args.length; ++i) {
                            vector.setElement(i - offset, args[i]);
                        }
                    } else if (vectorKind.getVectorLength() < 8) {
                        vector.initialiseToDefaultValues(vector.graph());
                    }
                    return true;
                }
                return false;
            }
        });
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.FLOAT2, FloatArray.class, Float.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.FLOAT3, FloatArray.class, Float.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.FLOAT4, FloatArray.class, Float.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.FLOAT8, FloatArray.class, Float.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.FLOAT16, FloatArray.class, Float.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.HALF2, HalfFloat.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.HALF3, HalfFloat.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.HALF4, HalfFloat.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.HALF8, HalfFloat.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.HALF16, HalfFloat.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.INT2, IntArray.class, Integer.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.INT3, IntArray.class, Integer.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.INT4, IntArray.class, Integer.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.INT8, IntArray.class, Integer.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.INT16, IntArray.class, Integer.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.SHORT2, ShortArray.class, Short.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.CHAR3, ByteArray.class, Byte.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.CHAR4, ByteArray.class, Byte.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.DOUBLE2, DoubleArray.class, Double.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.DOUBLE3, DoubleArray.class, Double.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.DOUBLE4, DoubleArray.class, Double.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.DOUBLE8, DoubleArray.class, Double.TYPE);
        OCLVectorPlugins.registerVectorPlugins(ps, plugins, OCLKind.DOUBLE16, DoubleArray.class, Double.TYPE);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORFLOAT2, FloatArray.class, Float2.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORFLOAT3, FloatArray.class, Float3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORFLOAT4, FloatArray.class, Float4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORFLOAT8, FloatArray.class, Float8.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORFLOAT16, FloatArray.class, Float16.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORINT2, IntArray.class, Int2.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORINT3, IntArray.class, Int3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORINT4, IntArray.class, Int4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORINT8, IntArray.class, Int8.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORINT16, IntArray.class, Int16.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORDOUBLE2, DoubleArray.class, Double2.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORDOUBLE3, DoubleArray.class, Double3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORDOUBLE4, DoubleArray.class, Double4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORDOUBLE8, DoubleArray.class, Double8.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORDOUBLE16, DoubleArray.class, Double16.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORHALF2, HalfFloatArray.class, Half2.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORHALF3, HalfFloatArray.class, Half3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORHALF4, HalfFloatArray.class, Half4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORHALF8, HalfFloatArray.class, Half8.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VECTORHALF16, HalfFloatArray.class, Half16.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.MATRIX2DFLOAT4, FloatArray.class, Float4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.MATRIX3DFLOAT4, FloatArray.class, Float4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.MATRIX4X4FLOAT, FloatArray.class, Float4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.IMAGEFLOAT3, FloatArray.class, Float3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.IMAGEFLOAT4, FloatArray.class, Float4.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.IMAGEFLOAT8, FloatArray.class, Float8.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.VOLUMESHORT2, ShortArray.class, Short2.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.IMAGEBYTE3, ByteArray.class, Byte3.class);
        OCLVectorPlugins.registerVectorCollectionsPlugins(plugins, OCLKind.IMAGEBYTE4, ByteArray.class, Byte4.class);
        if (TornadoOptions.TORNADO_ENABLE_BIFS) {
            OCLVectorPlugins.registerGeometricBIFS(plugins, OCLKind.FLOAT3);
            OCLVectorPlugins.registerGeometricBIFS(plugins, OCLKind.FLOAT4);
        }
    }

    private static VectorValueNode resolveReceiver(ValueNode thisObject) {
        VectorValueNode vector = null;
        if (thisObject instanceof PiNode) {
            PiNode piNode = (PiNode)thisObject;
            thisObject = piNode.getOriginalNode();
        }
        if (thisObject instanceof VectorValueNode) {
            VectorValueNode vectorValueNode;
            vector = vectorValueNode = (VectorValueNode)thisObject;
        }
        TornadoInternalError.guarantee((vector != null ? 1 : 0) != 0, (String)"[Vector Plugins] unable to resolve vector", (Object[])new Object[0]);
        return vector;
    }

    private static Class<?> resolveJavaClass(String panamaType) throws TornadoCompilationException {
        Class<Number> clazz;
        String string = panamaType;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String s = string2;
                    if (!s.contains("IntArray")) {
                        n = 1;
                        continue block6;
                    }
                    clazz = Integer.TYPE;
                    break block6;
                }
                case 1: {
                    String s = string2;
                    if (!s.contains("DoubleArray")) {
                        n = 2;
                        continue block6;
                    }
                    clazz = Double.TYPE;
                    break block6;
                }
                case 2: {
                    String s = string2;
                    if (!s.contains("FloatArray")) {
                        n = 3;
                        continue block6;
                    }
                    clazz = Float.TYPE;
                    break block6;
                }
                case 3: {
                    String s = string2;
                    if (!s.contains("HalfFloatArray")) {
                        n = 4;
                        continue block6;
                    }
                    clazz = Short.TYPE;
                    break block6;
                }
                default: {
                    throw new TornadoCompilationException("Private vectors that use " + panamaType + " for storage are not currently supported.");
                }
            }
            break;
        }
        return clazz;
    }

    private static void registerVectorCollectionsPlugins(InvocationPlugins plugins, OCLKind vectorKind, Class<?> storageType, final Class<?> vectorClass) {
        Class<?> declaringClass = vectorKind.getJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass);
        r.register(new InvocationPlugin("loadFromArray", new Type[]{InvocationPlugin.Receiver.class, storageType, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode index) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(vectorClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                JavaKind elementKind = kind.getElementKind().asJavaKind();
                LoadIndexedVectorNode indexedLoad = new LoadIndexedVectorNode(kind, array, index, elementKind);
                b.push(JavaKind.Object, (ValueNode)b.append((Node)indexedLoad));
                return true;
            }
        });
        r.register(new InvocationPlugin("storeToArray", new Type[]{InvocationPlugin.Receiver.class, vectorClass, storageType, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode array, ValueNode index) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(vectorClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                JavaKind elementKind = kind.getElementKind().asJavaKind();
                StoreIndexedNode indexedStore = new StoreIndexedNode(array, index, null, null, elementKind, value);
                b.append((Node)((StoreIndexedNode)b.append((Node)indexedStore)));
                return true;
            }
        });
    }

    private static void registerVectorPlugins(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins, final OCLKind vectorKind, Class<?> storageType, Class<?> elementType) {
        final Class<?> declaringClass = vectorKind.getJavaClass();
        final JavaKind javaElementKind = vectorKind.getElementKind().asJavaKind();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass);
        ps.appendNodePlugin(new NodePlugin(){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                if (method.getName().equals("<init>") && (method.toString().contains("FloatArray.<init>(int)") || method.toString().contains("DoubleArray.<init>(int)") || method.toString().contains("IntArray.<init>(int)") || method.toString().contains("HalfFloatArray.<init>(int)"))) {
                    Class<?> javaType = OCLVectorPlugins.resolveJavaClass(method.toString());
                    b.append((Node)new PanamaPrivateMemoryNode(b.getMetaAccess().lookupJavaType(javaType), args[1]));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode laneId) {
                VectorLoadElementNode loadElement = new VectorLoadElementNode(vectorKind.getElementKind(), receiver.get(true), laneId);
                b.push(javaElementKind, (ValueNode)b.append((Node)loadElement));
                return true;
            }
        });
        r.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, vectorKind.getJavaClass()}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if (receiver.get(true) instanceof ParameterNode) {
                    OffsetAddressNode address = new OffsetAddressNode(receiver.get(true), null);
                    VectorStoreGlobalMemory store = new VectorStoreGlobalMemory(vectorKind, (ValueNode)address, value);
                    b.add((Node)((VectorStoreGlobalMemory)b.append((Node)store)));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, elementType}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode laneId, ValueNode value) {
                VectorStoreElementProxyNode store = new VectorStoreElementProxyNode(vectorKind.getElementKind(), receiver.get(true), laneId, value);
                b.add((Node)((VectorStoreElementProxyNode)b.append((Node)store)));
                return true;
            }
        });
        r.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, storageType}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode laneId, ValueNode value) {
                VectorStoreElementProxyNode store = new VectorStoreElementProxyNode(vectorKind.getElementKind(), receiver.get(true), laneId, value);
                b.add((Node)((VectorStoreElementProxyNode)b.append((Node)store)));
                return true;
            }
        });
        r.register(new InvocationPlugin("add", new Type[]{declaringClass, declaringClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input1, ValueNode input2) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(declaringClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                VectorAddNode addNode = new VectorAddNode(kind, input1, input2);
                b.push(JavaKind.Illegal, (ValueNode)b.append((Node)addNode));
                return true;
            }
        });
        r.register(new InvocationPlugin("sub", new Type[]{declaringClass, declaringClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input1, ValueNode input2) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(declaringClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                VectorSubNode subNode = new VectorSubNode(kind, input1, input2);
                b.push(JavaKind.Illegal, (ValueNode)b.append((Node)subNode));
                return true;
            }
        });
        r.register(new InvocationPlugin("mult", new Type[]{declaringClass, declaringClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input1, ValueNode input2) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(declaringClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                VectorMulNode multNode = new VectorMulNode(kind, input1, input2);
                b.push(JavaKind.Illegal, (ValueNode)b.append((Node)multNode));
                return true;
            }
        });
        r.register(new InvocationPlugin("div", new Type[]{declaringClass, declaringClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input1, ValueNode input2) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(declaringClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                VectorDivNode divNode = new VectorDivNode(kind, input1, input2);
                b.push(JavaKind.Illegal, (ValueNode)b.append((Node)divNode));
                return true;
            }
        });
        r.register(new InvocationPlugin("getArray", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ResolvedJavaType resolvedType = b.getMetaAccess().lookupJavaType(declaringClass);
                OCLKind kind = OCLKind.fromResolvedJavaType(resolvedType);
                JavaKind elementKind = kind.getElementKind().asJavaKind();
                ValueNode array = receiver.get(true);
                GetArrayNode getArrayNode = new GetArrayNode(kind, array, elementKind);
                b.push(JavaKind.Object, (ValueNode)b.append((Node)getArrayNode));
                return true;
            }
        });
    }

    private static void registerGeometricBIFS(InvocationPlugins plugins, OCLKind vectorKind) {
        Class<?> declaringClass = vectorKind.getJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass);
        r.register(new InvocationPlugin("dot", new Type[]{declaringClass, declaringClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input1, ValueNode input2) {
                TornadoInternalError.unimplemented();
                return true;
            }
        });
    }

    static void registerParameterPlugins(GraphBuilderConfiguration.Plugins plugins) {
        plugins.appendParameterPlugin((tool, index, stampPair) -> {
            ObjectStamp objStamp;
            ResolvedJavaType objStampType;
            if (stampPair.getTrustedStamp() instanceof ObjectStamp && (objStampType = (objStamp = (ObjectStamp)stampPair.getTrustedStamp()).type()) != null && objStampType.getAnnotation(Vector.class) != null) {
                OCLKind kind = OCLKind.fromResolvedJavaType(objStampType);
                return new ParameterNode(index, StampPair.createSingle((Stamp)OCLStampFactory.getStampFor(kind)));
            }
            return null;
        });
    }
}

