/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins;

import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;

public class OCLVectorNodePlugin
implements NodePlugin {
    public boolean handleNewInstance(GraphBuilderContext b, ResolvedJavaType type) {
        if (type.getAnnotation(Vector.class) != null) {
            return this.createVectorInstance(b, type);
        }
        return false;
    }

    private boolean createVectorInstance(GraphBuilderContext b, ResolvedJavaType type) {
        OCLKind vectorKind = this.resolveOCLKind(type);
        if (vectorKind != OCLKind.ILLEGAL && vectorKind.isVector()) {
            b.push(JavaKind.Object, (ValueNode)b.append((Node)new VectorValueNode(vectorKind)));
            return true;
        }
        return false;
    }

    private OCLKind resolveOCLKind(ResolvedJavaType type) {
        if (type instanceof HotSpotResolvedJavaType) {
            return OCLKind.fromResolvedJavaType(type);
        }
        return OCLKind.ILLEGAL;
    }
}

