/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins;

import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPUnaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntTernaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntUnaryIntrinsicNode;

public class OCLMathPlugins {
    public static void registerTornadoMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration registration = new InvocationPlugins.Registration(plugins, TornadoMath.class);
        OCLMathPlugins.registerFloatMath1Plugins(registration, Float.TYPE, JavaKind.Float);
        OCLMathPlugins.registerFloatMath2Plugins(registration, Float.TYPE, JavaKind.Float);
        OCLMathPlugins.registerTrigonometric1Plugins(registration, Float.TYPE, JavaKind.Float);
        OCLMathPlugins.registerFloatMath1Plugins(registration, Double.TYPE, JavaKind.Double);
        OCLMathPlugins.registerFloatMath2Plugins(registration, Double.TYPE, JavaKind.Double);
        OCLMathPlugins.registerTrigonometric1Plugins(registration, Double.TYPE, JavaKind.Double);
        OCLMathPlugins.registerIntMath1Plugins(registration, Integer.TYPE, JavaKind.Int);
        OCLMathPlugins.registerIntMath2Plugins(registration, Integer.TYPE, JavaKind.Int);
        OCLMathPlugins.registerIntMath3Plugins(registration, Integer.TYPE, JavaKind.Int);
        OCLMathPlugins.registerIntMath1Plugins(registration, Long.TYPE, JavaKind.Long);
        OCLMathPlugins.registerIntMath2Plugins(registration, Long.TYPE, JavaKind.Long);
        OCLMathPlugins.registerIntMath3Plugins(registration, Long.TYPE, JavaKind.Long);
        OCLMathPlugins.registerIntMath1Plugins(registration, Short.TYPE, JavaKind.Short);
        OCLMathPlugins.registerIntMath2Plugins(registration, Short.TYPE, JavaKind.Short);
        OCLMathPlugins.registerIntMath3Plugins(registration, Short.TYPE, JavaKind.Short);
        OCLMathPlugins.registerIntMath1Plugins(registration, Byte.TYPE, JavaKind.Byte);
        OCLMathPlugins.registerIntMath2Plugins(registration, Byte.TYPE, JavaKind.Byte);
        OCLMathPlugins.registerIntMath3Plugins(registration, Byte.TYPE, JavaKind.Byte);
        OCLMathPlugins.registerHalfFloatMathPlugins(registration);
    }

    private static void registerHalfFloatMathPlugins(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("min", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Object, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMIN, JavaKind.Short)));
                return true;
            }
        });
        r.register(new InvocationPlugin("max", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Object, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMAX, JavaKind.Short)));
                return true;
            }
        });
    }

    private static void registerFloatMath1Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("sqrt", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.SQRT, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("exp", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.EXP, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.FABS, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("floor", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.FLOOR, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("log", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.LOG, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("ceil", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.CEIL, kind)));
                return true;
            }
        });
    }

    private static void registerTrigonometric1Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("acosh", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ACOSH, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("asinh", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ASINH, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("atan2", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.ATAN2, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("atan", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ATAN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("sin", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.SIN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("cos", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.COS, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("acos", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ACOS, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("tan", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.TAN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("asin", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ASIN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("tanh", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.TANH, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("toRadians", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.RADIANS, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("sinpi", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.SINPI, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("cospi", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.COSPI, kind)));
                return true;
            }
        });
    }

    private static void registerFloatMath2Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("min", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMIN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("max", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMAX, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("pow", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.POW, kind)));
                return true;
            }
        });
    }

    private static void registerIntMath1Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("abs", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, (ValueNode)b.append((Node)OCLIntUnaryIntrinsicNode.create(value, OCLIntUnaryIntrinsicNode.Operation.ABS, kind)));
                return true;
            }
        });
    }

    private static void registerIntMath2Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("min", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLIntBinaryIntrinsicNode.create(x, y, OCLIntBinaryIntrinsicNode.Operation.MIN, kind)));
                return true;
            }
        });
        r.register(new InvocationPlugin("max", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(kind, (ValueNode)b.append((Node)OCLIntBinaryIntrinsicNode.create(x, y, OCLIntBinaryIntrinsicNode.Operation.MAX, kind)));
                return true;
            }
        });
    }

    private static void registerIntMath3Plugins(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("clamp", new Type[]{type, type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y, ValueNode z) {
                b.push(kind, (ValueNode)b.append((Node)OCLIntTernaryIntrinsicNode.create(x, y, z, OCLIntTernaryIntrinsicNode.Operation.CLAMP, kind)));
                return true;
            }
        });
    }
}

