/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins;

import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.runtime.graal.nodes.AddHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.DivHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.HalfFloatPlaceholder;
import uk.ac.manchester.tornado.runtime.graal.nodes.MultHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.NewHalfFloatInstance;
import uk.ac.manchester.tornado.runtime.graal.nodes.SubHalfFloatNode;

public class OCLHalfFloatPlugins {
    public static void registerPlugins(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins) {
        OCLHalfFloatPlugins.registerHalfFloatInit(ps, plugins);
    }

    private static void registerHalfFloatInit(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, HalfFloat.class);
        ps.appendNodePlugin(new NodePlugin(){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                if (method.getName().equals("<init>") && method.toString().contains("HalfFloat.<init>")) {
                    NewHalfFloatInstance newHalfFloatInstance = (NewHalfFloatInstance)b.append((Node)new NewHalfFloatInstance(args[1]));
                    b.add((Node)newHalfFloatInstance);
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin("add", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode halfFloat1, ValueNode halfFloat2) {
                AddHalfFloatNode addNode = (AddHalfFloatNode)b.append((Node)new AddHalfFloatNode(halfFloat1, halfFloat2));
                b.push(JavaKind.Object, (ValueNode)addNode);
                return true;
            }
        });
        r.register(new InvocationPlugin("sub", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode halfFloat1, ValueNode halfFloat2) {
                SubHalfFloatNode subNode = (SubHalfFloatNode)b.append((Node)new SubHalfFloatNode(halfFloat1, halfFloat2));
                b.push(JavaKind.Object, (ValueNode)subNode);
                return true;
            }
        });
        r.register(new InvocationPlugin("mult", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode halfFloat1, ValueNode halfFloat2) {
                MultHalfFloatNode multNode = (MultHalfFloatNode)b.append((Node)new MultHalfFloatNode(halfFloat1, halfFloat2));
                b.push(JavaKind.Object, (ValueNode)multNode);
                return true;
            }
        });
        r.register(new InvocationPlugin("div", new Type[]{HalfFloat.class, HalfFloat.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode halfFloat1, ValueNode halfFloat2) {
                DivHalfFloatNode divNode = (DivHalfFloatNode)b.append((Node)new DivHalfFloatNode(halfFloat1, halfFloat2));
                b.push(JavaKind.Object, (ValueNode)divNode);
                return true;
            }
        });
        r.register(new InvocationPlugin("getHalfFloatValue", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Short, (ValueNode)b.append((Node)new HalfFloatPlaceholder(receiver.get(true))));
                return true;
            }
        });
    }
}

