/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.RawConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.word.LocationIdentity;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.exceptions.Debug;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.Int8Array;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.utils.QuantizationUtils;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLAtomicIntegerPlugin;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLHalfFloatPlugins;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLMathPlugins;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLVectorNodePlugin;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLVectorPlugins;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.AtomAddNodeTemplate;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.DecAtomicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GetAtomicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GlobalThreadIdNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.IncAtomicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalArrayNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLBarrierNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLConvertHalfToFloat;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPUnaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntUnaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.PrintfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.TornadoVMConfigAccess;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLGraphBuilderPlugins {
    public static void registerInvocationPlugins(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins, HotSpotMetaAccessProvider metaAccessProvider) {
        if (TornadoOptions.INLINE_DURING_BYTECODE_PARSING) {
            ps.appendInlineInvokePlugin((InlineInvokePlugin)new InlineDuringParsingPlugin());
        }
        OCLGraphBuilderPlugins.registerFP16ConversionPlugins(plugins);
        OCLGraphBuilderPlugins.registerTornadoVMIntrinsicsPlugins(plugins);
        OCLGraphBuilderPlugins.registerKernelContextPlugins(plugins);
        OCLMathPlugins.registerTornadoMathPlugins(plugins);
        OCLGraphBuilderPlugins.registerOpenCLBuiltinPlugins(plugins);
        OCLVectorPlugins.registerPlugins(ps, plugins);
        OCLGraphBuilderPlugins.registerTornadoAtomicInteger(ps, plugins);
        OCLHalfFloatPlugins.registerPlugins(ps, plugins);
        OCLGraphBuilderPlugins.registerMemoryAccessPlugins(plugins, metaAccessProvider);
        OCLGraphBuilderPlugins.registerQuantizationUtilsPlugins(plugins);
    }

    private static boolean isMethodFromAtomicClass(ResolvedJavaMethod method) {
        return method.getDeclaringClass().toJavaName().equals("uk.ac.manchester.tornado.api.atomics.TornadoAtomicInteger") || method.getDeclaringClass().toJavaName().equals("java.util.concurrent.atomic.AtomicInteger");
    }

    private static void registerAtomicCall(InvocationPlugins.Registration r, final JavaKind returnedJavaKind) {
        r.register(new InvocationPlugin("incrementAndGet", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.addPush(returnedJavaKind, (ValueNode)((IncAtomicNode)b.append((Node)new IncAtomicNode(receiver.get(), OCLUnary.AtomicOperator.INCREMENT_AND_GET))));
                return true;
            }
        });
        r.register(new InvocationPlugin("getAndIncrement", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.addPush(returnedJavaKind, (ValueNode)((IncAtomicNode)b.append((Node)new IncAtomicNode(receiver.get(), OCLUnary.AtomicOperator.GET_AND_INCREMENT))));
                return true;
            }
        });
        r.register(new InvocationPlugin("decrementAndGet", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.addPush(returnedJavaKind, (ValueNode)((DecAtomicNode)b.append((Node)new DecAtomicNode(receiver.get(true), OCLUnary.AtomicOperator.DECREMENT_AND_GET))));
                return true;
            }
        });
        r.register(new InvocationPlugin("getAndDecrement", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.addPush(returnedJavaKind, (ValueNode)((DecAtomicNode)b.append((Node)new DecAtomicNode(receiver.get(true), OCLUnary.AtomicOperator.GET_AND_DECREMENT))));
                return true;
            }
        });
        r.register(new InvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.addPush(returnedJavaKind, (ValueNode)((GetAtomicNode)b.append((Node)new GetAtomicNode(receiver.get(true)))));
                return true;
            }
        });
    }

    private static void registerTornadoAtomicInteger(GraphBuilderConfiguration.Plugins ps, InvocationPlugins plugins) {
        ps.appendNodePlugin(new NodePlugin(){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                TornadoAtomicIntegerNode atomic;
                if (OCLGraphBuilderPlugins.isMethodFromAtomicClass(method) && method.getName().equals("<init>") && (atomic = OCLGraphBuilderPlugins.resolveReceiverAtomic(args[0])) != null && args.length > 1) {
                    ValueNode initialValue = args[1];
                    if (initialValue instanceof ConstantNode) {
                        ConstantNode constantNode = (ConstantNode)initialValue;
                        int value = Integer.parseInt(constantNode.getValue().toValueString());
                        if (value == 0) {
                            atomic.setInitialValue((ValueNode)constantNode);
                        } else {
                            atomic.setInitialValueAtUsages((ValueNode)constantNode);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        Class<AtomicInteger> declaringClass = AtomicInteger.class;
        JavaKind returnedJavaKind = OCLKind.INT.asJavaKind();
        InvocationPlugins.Registration r1 = new InvocationPlugins.Registration(plugins, declaringClass);
        OCLGraphBuilderPlugins.registerAtomicCall(r1, returnedJavaKind);
    }

    private static TornadoAtomicIntegerNode resolveReceiverAtomic(ValueNode thisObject) {
        TornadoAtomicIntegerNode atomicNode = null;
        if (thisObject instanceof PiNode) {
            PiNode piNode = (PiNode)thisObject;
            thisObject = piNode.getOriginalNode();
        }
        if (thisObject instanceof TornadoAtomicIntegerNode) {
            TornadoAtomicIntegerNode tornadoAtomicIntegerNode;
            atomicNode = tornadoAtomicIntegerNode = (TornadoAtomicIntegerNode)thisObject;
        }
        return atomicNode;
    }

    private static void registerLocalBarrier(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("localBarrier", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                OCLBarrierNode localBarrierNode = new OCLBarrierNode(OCLBarrierNode.OCLMemFenceFlags.LOCAL);
                b.add((Node)localBarrierNode);
                return true;
            }
        });
    }

    private static void registerGlobalBarrier(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("globalBarrier", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                OCLBarrierNode localBarrierNode = new OCLBarrierNode(OCLBarrierNode.OCLMemFenceFlags.GLOBAL);
                b.add((Node)localBarrierNode);
                return true;
            }
        });
    }

    private static void registerAtomicAddOperation(InvocationPlugins.Registration r) {
        Supplier<Integer> intHeaderSupplier = () -> {
            TornadoVMConfigAccess vmConfig = TornadoCoreRuntime.getVMConfig();
            int headerSize = vmConfig.getArrayBaseOffset(JavaKind.Int);
            return headerSize / JavaKind.Int.getByteCount();
        };
        Supplier<Integer> longHeaderSupplier = () -> {
            TornadoVMConfigAccess vmConfig = TornadoCoreRuntime.getVMConfig();
            int headerSize = vmConfig.getArrayBaseOffset(JavaKind.Long);
            return headerSize / JavaKind.Long.getByteCount();
        };
        OCLGraphBuilderPlugins.registerAtomicAddPlugin(r, "atomicAdd", IntArray.class, OCLKind.UINT, intHeaderSupplier);
        OCLGraphBuilderPlugins.registerAtomicAddPlugin(r, "atomicAdd", int[].class, OCLKind.UINT, intHeaderSupplier);
        OCLGraphBuilderPlugins.registerAtomicAddPlugin(r, "atomicAdd", LongArray.class, OCLKind.ULONG, longHeaderSupplier);
        OCLGraphBuilderPlugins.registerUnsupportedAtomicAddPlugin(r);
        OCLGraphBuilderPlugins.registerUnsupportedAtomicAddPlugin(r);
    }

    private static void registerAtomicAddPlugin(InvocationPlugins.Registration r, String methodName, Class<?> arrayType, final OCLKind kind, final Supplier<Integer> headerSupplier) {
        r.register(new InvocationPlugin(methodName, new Type[]{InvocationPlugin.Receiver.class, arrayType, Integer.TYPE, kind.asJavaKind().toJavaClass()}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode segment, ValueNode index, ValueNode inc) {
                JavaKind javaKind = kind.asJavaKind();
                int header = (Integer)headerSupplier.get();
                AddressNode address = OCLGraphBuilderPlugins.computeAddress(b, segment, index, header, javaKind);
                AtomAddNodeTemplate atomicAddNode = new AtomAddNodeTemplate(address, inc, javaKind);
                b.add((Node)((AtomAddNodeTemplate)b.append((Node)atomicAddNode)));
                return true;
            }
        });
    }

    private static void registerUnsupportedAtomicAddPlugin(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("atomicAdd", new Type[]{InvocationPlugin.Receiver.class, FloatArray.class, Integer.TYPE, Float.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode segment, ValueNode index, ValueNode inc) {
                TornadoInternalError.unimplemented((String)"In OpenCL, the atom_add function does not support floating point operations.");
                return false;
            }
        });
        r.register(new InvocationPlugin("atomicAdd", new Type[]{InvocationPlugin.Receiver.class, DoubleArray.class, Integer.TYPE, Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode segment, ValueNode index, ValueNode inc) {
                TornadoInternalError.unimplemented((String)"In OpenCL, the atom_add function does not support floating point operations.");
                return false;
            }
        });
    }

    private static AddressNode computeAddress(GraphBuilderContext b, ValueNode segment, ValueNode index, int panamaOffset, JavaKind kind) {
        ConstantNode constantNode = (ConstantNode)b.append((Node)new ConstantNode((Constant)new RawConstant((long)panamaOffset), StampFactory.forKind((JavaKind)JavaKind.Int)));
        AddNode newIndex = (AddNode)b.append((Node)new AddNode(index, (ValueNode)constantNode));
        SignExtendNode signExtendNode = (SignExtendNode)b.append((Node)new SignExtendNode((ValueNode)newIndex, OCLKind.LONG.asJavaKind().getBitCount()));
        MulNode mulNode = (MulNode)b.append((Node)new MulNode((ValueNode)signExtendNode, (ValueNode)ConstantNode.forInt((int)kind.getByteCount())));
        return (AddressNode)b.append((Node)new OffsetAddressNode(segment, (ValueNode)mulNode));
    }

    private static void registerIntLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind, final JavaKind elementType) {
        r.register(new InvocationPlugin("allocateIntLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, elementType, size);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void registerLongLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind, final JavaKind elementType) {
        r.register(new InvocationPlugin("allocateLongLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, elementType, size);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void registerFloatLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind, final JavaKind elementType) {
        r.register(new InvocationPlugin("allocateFloatLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, elementType, size);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void registerDoubleLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind, final JavaKind elementType) {
        r.register(new InvocationPlugin("allocateDoubleLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, elementType, size);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void registerByteLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind) {
        r.register(new InvocationPlugin("allocateByteLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                MetaAccessProvider metaAccess = b.getMetaAccess();
                ResolvedJavaType resolvedElementType = metaAccess.lookupJavaType(Byte.TYPE);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, resolvedElementType, size);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void registerHalfFloatLocalArray(InvocationPlugins.Registration r, final JavaKind returnedJavaKind) {
        r.register(new InvocationPlugin("allocateHalfFloatLocalArray", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode size) {
                receiver.get(true);
                MetaAccessProvider metaAccess = b.getMetaAccess();
                ResolvedJavaType resolvedElementType = metaAccess.lookupJavaType(Short.TYPE);
                LocalArrayNode localArrayNode = new LocalArrayNode(OCLArchitecture.localSpace, resolvedElementType, size, OCLKind.HALF);
                b.push(returnedJavaKind, (ValueNode)localArrayNode);
                return true;
            }
        });
    }

    private static void localArraysPlugins(InvocationPlugins.Registration r) {
        JavaKind returnedJavaKind = JavaKind.Object;
        JavaKind elementType = OCLKind.INT.asJavaKind();
        OCLGraphBuilderPlugins.registerIntLocalArray(r, returnedJavaKind, elementType);
        elementType = OCLKind.LONG.asJavaKind();
        OCLGraphBuilderPlugins.registerLongLocalArray(r, returnedJavaKind, elementType);
        elementType = OCLKind.FLOAT.asJavaKind();
        OCLGraphBuilderPlugins.registerFloatLocalArray(r, returnedJavaKind, elementType);
        elementType = OCLKind.DOUBLE.asJavaKind();
        OCLGraphBuilderPlugins.registerDoubleLocalArray(r, returnedJavaKind, elementType);
        OCLGraphBuilderPlugins.registerByteLocalArray(r, returnedJavaKind);
        returnedJavaKind = JavaKind.fromJavaClass(Short.TYPE);
        OCLGraphBuilderPlugins.registerHalfFloatLocalArray(r, returnedJavaKind);
    }

    private static void registerKernelContextPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, KernelContext.class);
        OCLGraphBuilderPlugins.registerLocalBarrier(r);
        OCLGraphBuilderPlugins.registerGlobalBarrier(r);
        OCLGraphBuilderPlugins.localArraysPlugins(r);
        OCLGraphBuilderPlugins.registerAtomicAddOperation(r);
    }

    private static void registerMemoryAccessPlugins(InvocationPlugins plugins, HotSpotMetaAccessProvider metaAccessProvider) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, TornadoMemorySegment.class);
        for (final JavaKind kind : JavaKind.values()) {
            if (kind == JavaKind.Object || kind == JavaKind.Void || kind == JavaKind.Illegal) continue;
            r.register(new InvocationPlugin("get" + kind.name() + "AtIndex", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode index, ValueNode baseIndex) {
                    AddNode absoluteIndexNode = (AddNode)b.append((Node)new AddNode(index, baseIndex));
                    MulNode mulNode = (MulNode)b.append((Node)new MulNode((ValueNode)absoluteIndexNode, (ValueNode)ConstantNode.forInt((int)kind.getByteCount())));
                    AddressNode addressNode = (AddressNode)b.append((Node)new OffsetAddressNode(receiver.get(true), (ValueNode)mulNode));
                    JavaReadNode readNode = new JavaReadNode(kind, addressNode, LocationIdentity.any(), BarrierType.NONE, MemoryOrderMode.PLAIN, false);
                    b.addPush(kind, (ValueNode)readNode);
                    return true;
                }
            });
            r.register(new InvocationPlugin("setAtIndex", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, kind.toJavaClass(), Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode index, ValueNode value, ValueNode baseIndex) {
                    AddNode absoluteIndexNode = (AddNode)b.append((Node)new AddNode(index, baseIndex));
                    MulNode mulNode = (MulNode)b.append((Node)new MulNode((ValueNode)absoluteIndexNode, (ValueNode)ConstantNode.forInt((int)kind.getByteCount())));
                    AddressNode addressNode = (AddressNode)b.append((Node)new OffsetAddressNode(receiver.get(true), (ValueNode)mulNode));
                    JavaWriteNode writeNode = new JavaWriteNode(kind, addressNode, LocationIdentity.any(), value, BarrierType.NONE, false);
                    b.add((Node)writeNode);
                    return true;
                }
            });
        }
    }

    private static void registerFP16ConversionPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Float.class);
        r.register(new InvocationPlugin("float16ToFloat", new Type[]{Short.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode halfValue) {
                OCLConvertHalfToFloat convertHalfToFloat = new OCLConvertHalfToFloat(halfValue);
                b.addPush(JavaKind.Float, (ValueNode)convertHalfToFloat);
                return true;
            }
        });
    }

    private static void registerQuantizationUtilsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, QuantizationUtils.class);
        r.register(new InvocationPlugin("dp4a", new Type[]{Int8Array.class, Long.TYPE, Int8Array.class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graphBuilderContext, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode offset_a, ValueNode b, ValueNode offset_b, ValueNode accumulator) {
                TornadoInternalError.unimplemented((String)"DP4A is a PTX instruction. It is not supported in OpenCL.");
                return false;
            }
        });
        r.register(new InvocationPlugin("dp4a", new Type[]{Int8Array.class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graphBuilderContext, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode offset_a, ValueNode b, ValueNode offset_b, ValueNode accumulator) {
                TornadoInternalError.unimplemented((String)"DP4A is a PTX instruction. It is not supported in OpenCL.");
                return false;
            }
        });
        r.register(new InvocationPlugin("dp4a_packed", new Type[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graphBuilderContext, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode b, ValueNode accumulator) {
                TornadoInternalError.unimplemented((String)"DP4A is a PTX instruction. It is not supported in OpenCL.");
                return false;
            }
        });
    }

    private static void registerTornadoVMIntrinsicsPlugins(InvocationPlugins plugins) {
        InvocationPlugin printfPlugin = new InvocationPlugin("printf", new Type[]{String.class, Object[].class}){

            public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ... args) {
                NewArrayNode newArrayNode = (NewArrayNode)args[1];
                ConstantNode lengthNode = (ConstantNode)newArrayNode.dimension(0);
                int length = ((JavaConstant)lengthNode.getValue()).asInt();
                ValueNode[] actualArgs = new ValueNode[length + 4];
                actualArgs[0] = args[0];
                actualArgs[1] = (ValueNode)b.append((Node)new GlobalThreadIdNode(ConstantNode.forInt((int)0)));
                actualArgs[2] = (ValueNode)b.append((Node)new GlobalThreadIdNode(ConstantNode.forInt((int)1)));
                actualArgs[3] = (ValueNode)b.append((Node)new GlobalThreadIdNode(ConstantNode.forInt((int)2)));
                int argIndex = 0;
                for (Node n : newArrayNode.usages()) {
                    if (!(n instanceof StoreIndexedNode)) continue;
                    StoreIndexedNode storeNode = (StoreIndexedNode)n;
                    ValueNode value = storeNode.value();
                    if (value instanceof BoxNode) {
                        BoxNode box = (BoxNode)value;
                        value = box.getValue();
                        GraphUtil.unlinkFixedNode((FixedWithNextNode)box);
                        box.safeDelete();
                    }
                    actualArgs[argIndex + 4] = value;
                    ++argIndex;
                }
                PrintfNode printfNode = new PrintfNode(actualArgs);
                b.append((Node)printfNode);
                while (newArrayNode.hasUsages()) {
                    Node n;
                    n = newArrayNode.usages().first();
                    if (n instanceof FixedWithNextNode) {
                        GraphUtil.unlinkFixedNode((FixedWithNextNode)((FixedWithNextNode)n));
                    }
                    n.clearInputs();
                    n.safeDelete();
                }
                GraphUtil.unlinkFixedNode((FixedWithNextNode)newArrayNode);
                newArrayNode.clearInputs();
                newArrayNode.safeDelete();
                return true;
            }
        };
        plugins.register(Debug.class, printfPlugin);
    }

    private static void registerOpenCLBuiltinPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Math.class);
        r.setAllowOverwrite(true);
        OCLGraphBuilderPlugins.registerOpenCLOverridesForType(r, Float.TYPE, JavaKind.Float);
        OCLGraphBuilderPlugins.registerOpenCLOverridesForType(r, Double.TYPE, JavaKind.Double);
        OCLGraphBuilderPlugins.registerOpenCLOverridesForType(r, Integer.TYPE, JavaKind.Int);
        OCLGraphBuilderPlugins.registerOpenCLOverridesForType(r, Long.TYPE, JavaKind.Long);
        OCLGraphBuilderPlugins.registerFPIntrinsics(r);
        InvocationPlugins.Registration longReg = new InvocationPlugins.Registration(plugins, Long.class);
        longReg.register(new InvocationPlugin("bitCount", new Type[]{Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, (ValueNode)b.append((Node)OCLIntUnaryIntrinsicNode.create(value, OCLIntUnaryIntrinsicNode.Operation.POPCOUNT, JavaKind.Int)));
                return true;
            }
        });
        InvocationPlugins.Registration intReg = new InvocationPlugins.Registration(plugins, Integer.class);
        intReg.register(new InvocationPlugin("bitCount", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, (ValueNode)b.append((Node)OCLIntUnaryIntrinsicNode.create(value, OCLIntUnaryIntrinsicNode.Operation.POPCOUNT, JavaKind.Int)));
                return true;
            }
        });
    }

    private static void registerFPIntrinsics(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("pow", new Type[]{Double.TYPE, Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.POW, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("sin", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.SIN, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("cos", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.COS, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("tan", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.TAN, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("tanh", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.TANH, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("atan", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.ATAN, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("atan2", new Type[]{Double.TYPE, Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.ATAN2, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("asin", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(x, OCLFPUnaryIntrinsicNode.Operation.ASIN, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("acos", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(x, OCLFPUnaryIntrinsicNode.Operation.ACOS, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("log", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.LOG, JavaKind.Double)));
                return true;
            }
        });
        r.register(new InvocationPlugin("exp", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.EXP, JavaKind.Double)));
                return true;
            }
        });
    }

    private static void registerOpenCLOverridesForType(InvocationPlugins.Registration r, Class<?> type, final JavaKind kind) {
        r.register(new InvocationPlugin("min", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                if (kind.isNumericFloat()) {
                    b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMIN, kind)));
                } else {
                    b.push(kind, (ValueNode)b.append((Node)OCLIntBinaryIntrinsicNode.create(x, y, OCLIntBinaryIntrinsicNode.Operation.MIN, kind)));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("max", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                if (kind.isNumericFloat()) {
                    b.push(kind, (ValueNode)b.append((Node)OCLFPBinaryIntrinsicNode.create(x, y, OCLFPBinaryIntrinsicNode.Operation.FMAX, kind)));
                } else {
                    b.push(kind, (ValueNode)b.append((Node)OCLIntBinaryIntrinsicNode.create(x, y, OCLIntBinaryIntrinsicNode.Operation.MAX, kind)));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if (kind.isNumericFloat()) {
                    b.push(kind, (ValueNode)b.append((Node)OCLFPUnaryIntrinsicNode.create(value, OCLFPUnaryIntrinsicNode.Operation.FABS, kind)));
                }
                return true;
            }
        });
    }

    public static void registerNewInstancePlugins(GraphBuilderConfiguration.Plugins plugins) {
        plugins.appendNodePlugin((NodePlugin)new OCLVectorNodePlugin());
        plugins.appendNodePlugin((NodePlugin)new OCLAtomicIntegerPlugin());
    }

    public static void registerParameterPlugins(GraphBuilderConfiguration.Plugins plugins) {
        OCLVectorPlugins.registerParameterPlugins(plugins);
    }
}

