/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchValue;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.ShortCircuitOrNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.FloatLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.options.OptionValues;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceFP64NotSupported;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLControlFlow;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLDirectCall;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLNullary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLReturnSlot;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FPGAWorkGroupSizeNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.IntelUnrollPragmaNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.XilinxPipeliningPragmaNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.logic.LogicalAndNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.logic.LogicalEqualsNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.logic.LogicalNotNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.logic.LogicalOrNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;

public class OCLNodeLIRBuilder
extends NodeLIRBuilder {
    private boolean elseClause;

    public OCLNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
    }

    public static boolean isIllegal(Value value) {
        assert (value != null);
        return Value.ILLEGAL.equals((Object)value);
    }

    public static boolean isLegal(Value value) {
        return !OCLNodeLIRBuilder.isIllegal(value);
    }

    private LIRKind resolveStamp(Stamp stamp) {
        LIRKind lirKind = LIRKind.Illegal;
        if (!stamp.isEmpty()) {
            ObjectStamp os;
            ResolvedJavaType type;
            OCLKind oclKind;
            lirKind = stamp instanceof ObjectStamp ? ((oclKind = OCLKind.fromResolvedJavaType(type = (os = (ObjectStamp)stamp).javaType(this.gen.getMetaAccess()))) != OCLKind.ILLEGAL ? LIRKind.value((PlatformKind)oclKind) : this.gen.getLIRKind(stamp)) : this.gen.getLIRKind(stamp);
        }
        return lirKind;
    }

    public void emitInvoke(Invoke x) {
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)x.callTarget();
        Stamp stamp = x.asNode().stamp(NodeView.DEFAULT);
        LIRKind lirKind = this.resolveStamp(stamp);
        AllocatableValue result = Value.ILLEGAL;
        if (lirKind != LIRKind.Illegal) {
            result = this.gen.newVariable((ValueKind)lirKind);
        }
        CallingConvention invokeCc = new CallingConvention(0, result, new AllocatableValue[0]);
        this.gen.getResult().getFrameMapBuilder().callsMethod(invokeCc);
        Value[] parameters = this.visitInvokeArguments(invokeCc, (Collection<ValueNode>)callTarget.arguments());
        LIRFrameState callState = null;
        if (callTarget instanceof DirectCallTargetNode) {
            this.emitDirectCall((DirectCallTargetNode)callTarget, (Value)result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else if (callTarget instanceof IndirectCallTargetNode) {
            this.emitIndirectCall((IndirectCallTargetNode)callTarget, (Value)result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else {
            TornadoInternalError.shouldNotReachHere();
        }
        if (OCLNodeLIRBuilder.isLegal((Value)result)) {
            this.setResult(x.asNode(), (Value)result);
        }
    }

    public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
        Value[] values = new Value[arguments.size()];
        int j = 0;
        for (ValueNode arg : arguments) {
            if (arg != null) {
                Value operand;
                values[j] = operand = this.operand((Node)arg);
                ++j;
                continue;
            }
            throw TornadoInternalError.shouldNotReachHere((String)"I thought we no longer have null entries for two-slot types...");
        }
        return values;
    }

    public void doBlock(HIRBlock block, StructuredGraph graph, BlockMap<List<Node>> blockMap, boolean isKernel) {
        OptionValues options = graph.getOptions();
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"%s - block %s", (Object[])new Object[]{graph.method().getName(), block});
        try (LIRGeneratorTool.BlockScope blockScope = this.gen.getBlockScope((BasicBlock)block);){
            if (block == this.gen.getResult().getLIR().getControlFlowGraph().getStartBlock()) {
                assert (block.getPredecessorCount() == 0);
                this.emitPrologue(graph, isKernel);
            }
            List nodes = (List)blockMap.get((BasicBlock)block);
            this.matchComplexExpressions(block, graph.getLastSchedule());
            for (int i = 0; i < nodes.size(); ++i) {
                VectorValueNode vectorValueNode;
                Node node = (Node)nodes.get(i);
                if (!(node instanceof ValueNode)) continue;
                ValueNode valueNode = (ValueNode)node;
                if ((Integer)LIRGenerator.Options.TraceLIRGeneratorLevel.getValue(options) >= 3) {
                    TTY.println((String)("LIRGen for " + String.valueOf(valueNode)));
                }
                if (!this.hasOperand((Node)valueNode)) {
                    if (this.peephole(valueNode)) continue;
                    try {
                        this.doRoot(valueNode);
                        this.platformPatch(isKernel);
                        continue;
                    }
                    catch (Throwable e) {
                        if (e instanceof TornadoDeviceFP64NotSupported) {
                            TornadoDeviceFP64NotSupported tornadoDeviceFP64NotSupportedException = (TornadoDeviceFP64NotSupported)e;
                            throw tornadoDeviceFP64NotSupportedException;
                        }
                        throw new TornadoInternalError(e).addContext(valueNode.toString());
                    }
                }
                Value operand = this.operand((Node)valueNode);
                if (ComplexMatchValue.INTERIOR_MATCH.equals((Object)operand)) {
                    TornadoCoreRuntime.getDebugContext().log("interior match for %s", (Object)valueNode);
                    continue;
                }
                if (operand instanceof ComplexMatchValue) {
                    TornadoCoreRuntime.getDebugContext().log("complex match for %s", (Object)valueNode);
                    ComplexMatchValue match = (ComplexMatchValue)operand;
                    operand = match.evaluate((NodeLIRBuilder)this);
                    if (operand == null) continue;
                    this.setResult(valueNode, operand);
                    continue;
                }
                if (!(valueNode instanceof VectorValueNode)) continue;
                VectorValueNode vectorNode = vectorValueNode = (VectorValueNode)valueNode;
                vectorNode.generate((NodeLIRBuilderTool)this);
            }
            assert (LIR.verifyBlock((LIR)this.gen.getResult().getLIR(), (BasicBlock)block));
        }
    }

    private void doRoot(ValueNode instr) {
        TornadoCoreRuntime.getDebugContext().log("Visiting %s", (Object)instr);
        this.emitNode(instr);
        if (this.hasOperand((Node)instr)) {
            TornadoCoreRuntime.getDebugContext().log("Operand for %s = %s", (Object)instr, (Object)this.operand((Node)instr));
        }
    }

    private void platformPatch(boolean isKernel) {
        OCLLIRStmt.ExprStmt exprStmtOp;
        OCLLIRStmt.ExprStmt expr;
        ArrayList insns = this.getLIRGeneratorTool().getResult().getLIR().getLIRforBlock(this.gen.getCurrentBlock());
        int index = insns.size() - 1;
        LIRInstruction op = (LIRInstruction)insns.get(index);
        if (!isKernel) {
            return;
        }
        if (op instanceof OCLLIRStmt.ExprStmt && (expr = (exprStmtOp = (OCLLIRStmt.ExprStmt)op)).getExpr() instanceof OCLUnary.Expr && ((OCLUnary.Expr)expr.getExpr()).getOpcode().equals(OCLAssembler.OCLUnaryOp.RETURN)) {
            OCLUnary.Expr returnExpr = (OCLUnary.Expr)expr.getExpr();
            this.append(new OCLLIRStmt.ExprStmt(new OCLNullary.Expr(OCLAssembler.OCLNullaryOp.RETURN, LIRKind.value((PlatformKind)OCLKind.ILLEGAL))));
            insns.remove(index);
            LIRKind lirKind = LIRKind.value((PlatformKind)returnExpr.getPlatformKind());
            OCLReturnSlot slotAddress = new OCLReturnSlot(lirKind);
            insns.set(index, new OCLLIRStmt.AssignStmt(slotAddress, returnExpr.getValue()));
        }
    }

    private Value emitNegatedLogicNode(LogicNode node) {
        OCLLIROp result;
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitNegatedLogicNode: %s", (Object[])new Object[]{node});
        LIRKind intLirKind = LIRKind.value((PlatformKind)OCLKind.INT);
        LIRKind boolLirKind = LIRKind.value((PlatformKind)OCLKind.BOOL);
        if (node instanceof LogicalEqualsNode) {
            LogicalEqualsNode logicalEqualsNode = (LogicalEqualsNode)node;
            Value x = this.operandOrConjunction((ValueNode)logicalEqualsNode.getX());
            Value y = this.operandOrConjunction((ValueNode)logicalEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_NE, boolLirKind, x, y);
        } else if (node instanceof FloatEqualsNode) {
            FloatEqualsNode floatEqualsNode = (FloatEqualsNode)node;
            Value x = this.operand((Node)floatEqualsNode.getX());
            Value y = this.operand((Node)floatEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryIntrinsicCmp.FLOAT_IS_NOT_EQUAL, intLirKind, x, y);
        } else if (node instanceof FloatLessThanNode) {
            FloatLessThanNode floatLessThanNode = (FloatLessThanNode)node;
            Value x = this.operand((Node)floatLessThanNode.getX());
            Value y = this.operand((Node)floatLessThanNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryIntrinsicCmp.FLOAT_IS_GREATEREQUAL, intLirKind, x, y);
        } else if (node instanceof IntegerBelowNode) {
            IntegerBelowNode integerBelowNode = (IntegerBelowNode)node;
            Value x = this.operand((Node)integerBelowNode.getX());
            Value y = this.operand((Node)integerBelowNode.getY());
            OCLLIROp cond1 = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_LT, boolLirKind, x, this.gen.emitConstant(intLirKind, (Constant)JavaConstant.forInt((int)0)));
            OCLLIROp cond2 = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_GTE, boolLirKind, x, y);
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_OR, boolLirKind, cond1, cond2);
        } else if (node instanceof IntegerEqualsNode) {
            IntegerEqualsNode integerEqualsNode = (IntegerEqualsNode)node;
            Value x = this.operand((Node)integerEqualsNode.getX());
            Value y = this.operand((Node)integerEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_NE, boolLirKind, x, y);
        } else if (node instanceof IntegerLessThanNode) {
            IntegerLessThanNode integerLessThanNode = (IntegerLessThanNode)node;
            Value x = this.operand((Node)integerLessThanNode.getX());
            Value y = this.operand((Node)integerLessThanNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_GTE, boolLirKind, x, y);
        } else if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            Value value = this.operand((Node)isNullNode.getValue());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_NE, boolLirKind, value, (Value)new ConstantValue((ValueKind)intLirKind, (Constant)PrimitiveConstant.NULL_POINTER));
        } else if (node instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOrNode = (ShortCircuitOrNode)node;
            Value x = this.operandOrConjunction((ValueNode)shortCircuitOrNode.getX());
            Value y = this.operandOrConjunction((ValueNode)shortCircuitOrNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_AND, boolLirKind, x, y);
        } else if (node instanceof IntegerTestNode) {
            IntegerTestNode testNode = (IntegerTestNode)node;
            Value x = this.operand((Node)testNode.getX());
            Value y = this.operand((Node)testNode.getY());
            result = this.getGen().getArithmetic().genTestNegateBinaryExpr(OCLAssembler.OCLBinaryOp.BITWISE_AND, boolLirKind, x, y);
        } else {
            throw new TornadoRuntimeException(String.format("logic node (class=%s)", node.getClass().getName()));
        }
        this.setResult((ValueNode)node, result);
        return result;
    }

    private OCLLIROp emitLogicNode(LogicNode node) {
        OCLLIROp result;
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitLogicNode: %s", (Object[])new Object[]{node});
        LIRKind intLirKind = LIRKind.value((PlatformKind)OCLKind.INT);
        LIRKind boolLirKind = LIRKind.value((PlatformKind)OCLKind.BOOL);
        if (node instanceof LogicalEqualsNode) {
            LogicalEqualsNode logicalEqualsNode = (LogicalEqualsNode)node;
            Value x = this.operandOrConjunction((ValueNode)logicalEqualsNode.getX());
            Value y = this.operandOrConjunction((ValueNode)logicalEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_EQ, boolLirKind, x, y);
        } else if (node instanceof LogicalOrNode) {
            LogicalOrNode logicalOrNode = (LogicalOrNode)node;
            Value x = this.operandOrConjunction((ValueNode)logicalOrNode.getX());
            Value y = this.operandOrConjunction((ValueNode)logicalOrNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_OR, boolLirKind, x, y);
        } else if (node instanceof LogicalAndNode) {
            LogicalAndNode logicalAndNode = (LogicalAndNode)node;
            Value x = this.operandOrConjunction((ValueNode)logicalAndNode.getX());
            Value y = this.operandOrConjunction((ValueNode)logicalAndNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_AND, boolLirKind, x, y);
        } else if (node instanceof LogicalNotNode) {
            LogicalNotNode logicalNotNode = (LogicalNotNode)node;
            Value value = this.operandOrConjunction((ValueNode)logicalNotNode.getValue());
            result = this.getGen().getArithmetic().genUnaryExpr(OCLAssembler.OCLUnaryOp.LOGICAL_NOT, boolLirKind, value);
        } else if (node instanceof FloatEqualsNode) {
            FloatEqualsNode floatEqualsNode = (FloatEqualsNode)node;
            Value x = this.operand((Node)floatEqualsNode.getX());
            Value y = this.operand((Node)floatEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryIntrinsicCmp.FLOAT_IS_EQUAL, intLirKind, x, y);
        } else if (node instanceof FloatLessThanNode) {
            FloatLessThanNode floatLessThanNode = (FloatLessThanNode)node;
            Value x = this.operand((Node)floatLessThanNode.getX());
            Value y = this.operand((Node)floatLessThanNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryIntrinsicCmp.FLOAT_IS_LESS, intLirKind, x, y);
        } else if (node instanceof IntegerBelowNode) {
            IntegerBelowNode integerBelowNode = (IntegerBelowNode)node;
            Value x = this.operand((Node)integerBelowNode.getX());
            Value y = this.operand((Node)integerBelowNode.getY());
            OCLLIROp cond1 = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_GTE, boolLirKind, x, this.gen.emitConstant(intLirKind, (Constant)JavaConstant.forInt((int)0)));
            OCLLIROp cond2 = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_LT, boolLirKind, x, y);
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_AND, boolLirKind, cond1, cond2);
        } else if (node instanceof IntegerEqualsNode) {
            IntegerEqualsNode integerEqualsNode = (IntegerEqualsNode)node;
            Value x = this.operand((Node)integerEqualsNode.getX());
            Value y = this.operand((Node)integerEqualsNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_EQ, boolLirKind, x, y);
        } else if (node instanceof IntegerLessThanNode) {
            IntegerLessThanNode integerLessThanNode = (IntegerLessThanNode)node;
            Value x = this.operand((Node)integerLessThanNode.getX());
            Value y = this.operand((Node)integerLessThanNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_LT, boolLirKind, x, y);
        } else if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            Value value = this.operand((Node)isNullNode.getValue());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.RELATIONAL_EQ, boolLirKind, value, (Value)new ConstantValue((ValueKind)intLirKind, (Constant)PrimitiveConstant.NULL_POINTER));
        } else if (node instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOrNode = (ShortCircuitOrNode)node;
            Value x = this.operandOrConjunction((ValueNode)shortCircuitOrNode.getX());
            Value y = this.operandOrConjunction((ValueNode)shortCircuitOrNode.getY());
            result = this.getGen().getArithmetic().genBinaryExpr(OCLAssembler.OCLBinaryOp.LOGICAL_OR, boolLirKind, x, y);
        } else if (node instanceof IntegerTestNode) {
            IntegerTestNode integerTestNode = (IntegerTestNode)node;
            Value x = this.operand((Node)integerTestNode.getX());
            Value y = this.operand((Node)integerTestNode.getY());
            result = this.getGen().getArithmetic().genTestBinaryExpr(OCLAssembler.OCLBinaryOp.BITWISE_AND, boolLirKind, x, y);
        } else {
            throw new TornadoRuntimeException(String.format("logic node (class=%s)", node.getClass().getName()));
        }
        this.setResult((ValueNode)node, result);
        return result;
    }

    private Value operandOrConjunction(ValueNode value) {
        if (this.operand((Node)value) != null) {
            return this.operand((Node)value);
        }
        if (value instanceof LogicNode) {
            return this.emitLogicNode((LogicNode)value);
        }
        TornadoInternalError.shouldNotReachHere();
        return null;
    }

    protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        OCLDirectCall call = new OCLDirectCall(callTarget, result, parameters, callState);
        if (OCLNodeLIRBuilder.isLegal(result)) {
            this.append(new OCLLIRStmt.AssignStmt(this.gen.asAllocatable(result), call));
        } else {
            this.append(new OCLLIRStmt.ExprStmt(call));
        }
    }

    protected void emitIndirectCall(IndirectCallTargetNode arg0, Value arg1, Value[] arg2, Value[] arg3, LIRFrameState arg4) {
        TornadoInternalError.unimplemented();
    }

    public void emitIf(IfNode x) {
        boolean isLoop;
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitIf: %s, condition=%s\n", (Object[])new Object[]{x, x.condition().getClass().getName()});
        LabelRef falseBranch = this.getLIRBlock((FixedNode)x.falseSuccessor());
        if (falseBranch.getTargetBlock().isExceptionEntry()) {
            Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitExceptionEntry", (Object[])new Object[0]);
            TornadoInternalError.shouldNotReachHere((String)"exceptions are unimplemented");
        }
        boolean invertedLoop = (isLoop = this.gen.getCurrentBlock().isLoopHeader()) && x.trueSuccessor() instanceof LoopExitNode;
        Value condition = invertedLoop ? this.emitNegatedLogicNode(x.condition()) : this.emitLogicNode(x.condition());
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"condition: %s -> %s", (Object[])new Object[]{x.condition(), condition});
        if (isLoop) {
            this.append(new OCLControlFlow.LoopConditionOp(condition));
        } else if (this.elseClause) {
            this.append(new OCLControlFlow.LinkedConditionalBranchOp(condition));
        } else {
            Value operand = this.operand((Node)x.condition());
            Variable newVariable = this.getGen().newVariable(operand.getValueKind());
            this.append(new OCLLIRStmt.AssignStmt((AllocatableValue)newVariable, operand));
            this.append(new OCLControlFlow.ConditionalBranchOp((Value)newVariable));
        }
    }

    private void emitLoopBegin(LoopBeginNode loopBeginNode) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"visiting emitLoopBegin %s", (Object[])new Object[]{loopBeginNode});
        HIRBlock block = (HIRBlock)this.gen.getCurrentBlock();
        HIRBlock currentBlockDominator = (HIRBlock)block.getDominator();
        LIR lir = this.getGen().getResult().getLIR();
        StandardOp.LabelOp label = (StandardOp.LabelOp)lir.getLIRforBlock((BasicBlock)block).get(0);
        List valuePhis = loopBeginNode.valuePhis().snapshot();
        for (ValuePhiNode phi : valuePhis) {
            Value value = this.operand((Node)phi.firstValue());
            if (phi.singleBackValueOrThis() == phi && value instanceof Variable) {
                this.setResult((ValueNode)phi, value);
                continue;
            }
            AllocatableValue result = this.gen.asAllocatable(this.operandForPhi(phi));
            this.append(new OCLLIRStmt.AssignStmt(result, value));
        }
        this.emitOCLFPGAPragmas(currentBlockDominator);
        this.append(new OCLControlFlow.LoopInitOp());
        this.append(new OCLControlFlow.LoopPostOp());
        label.clearIncomingValues();
    }

    public void visitLoopEnd(LoopEndNode loopEnd) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"visiting LoopEndNode: %s", (Object[])new Object[]{loopEnd});
        LoopBeginNode loopBegin = loopEnd.loopBegin();
        List phis = loopBegin.valuePhis().snapshot();
        for (ValuePhiNode phi : phis) {
            Value src;
            AllocatableValue dest = this.gen.asAllocatable(this.operandForPhi(phi));
            if (dest.equals((Object)(src = this.operand((Node)phi.valueAt((AbstractEndNode)loopEnd))))) continue;
            this.append(new OCLLIRStmt.AssignStmt(dest, src));
        }
    }

    public void visitMerge(AbstractMergeNode mergeNode) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"visitMerge: ", (Object[])new Object[]{mergeNode});
        boolean loopExitMerge = true;
        for (EndNode end : mergeNode.forwardEnds()) {
            loopExitMerge &= end.predecessor() instanceof LoopExitNode;
        }
        for (ValuePhiNode phi : mergeNode.valuePhis()) {
            Value src;
            AllocatableValue dest;
            ValueNode value = phi.singleValueOrThis();
            if (value != phi) {
                dest = this.gen.asAllocatable(this.operandForPhi(phi));
                if (dest.equals((Object)(src = this.operand((Node)value)))) continue;
                this.append(new OCLLIRStmt.AssignStmt(dest, src));
                continue;
            }
            if (!loopExitMerge) continue;
            dest = this.gen.asAllocatable(this.operandForPhi(phi));
            src = this.operand((Node)phi.valueAt(1));
            this.append(new OCLLIRStmt.AssignStmt(dest, src));
        }
    }

    protected void emitNode(ValueNode node) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitNode: %s", (Object[])new Object[]{node});
        if (node instanceof LoopBeginNode) {
            LoopBeginNode loopBeginNode = (LoopBeginNode)node;
            this.emitLoopBegin(loopBeginNode);
        } else if (node instanceof LoopExitNode) {
            LoopExitNode loopExitNode = (LoopExitNode)node;
            this.emitLoopExit(loopExitNode);
        } else if (node instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOrNode = (ShortCircuitOrNode)node;
            this.emitShortCircuitOrNode(shortCircuitOrNode);
        } else if (node instanceof ConditionalNode) {
            ConditionalNode conditionalNode = (ConditionalNode)node;
            this.emitConditionalNode(conditionalNode);
        } else if (!(node instanceof IntelUnrollPragmaNode || node instanceof XilinxPipeliningPragmaNode || node instanceof FPGAWorkGroupSizeNode)) {
            super.emitNode(node);
        }
    }

    public void emitSwitch(SwitchNode x) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"SWITCH NODE OCL:", (Object[])new Object[0]);
        assert (x.defaultSuccessor() != null);
        LabelRef defaultTarget = this.getLIRBlock((FixedNode)x.defaultSuccessor());
        int keyCount = x.keyCount();
        if (keyCount == 0) {
            this.gen.emitJump(defaultTarget);
        } else {
            Variable value = this.gen.emitMove(this.operand((Node)x.value()));
            if (keyCount == 1) {
                assert (defaultTarget != null);
                TornadoInternalError.unimplemented();
            } else {
                LabelRef[] keyTargets = new LabelRef[keyCount];
                JavaConstant[] keyConstants = new JavaConstant[keyCount];
                double[] keyProbabilities = new double[keyCount];
                for (int i = 0; i < keyCount; ++i) {
                    keyTargets[i] = this.getLIRBlock((FixedNode)x.keySuccessor(i));
                    keyConstants[i] = (JavaConstant)x.keyAt(i);
                    keyProbabilities[i] = x.keyProbability(i);
                }
                this.gen.emitStrategySwitch(keyConstants, keyProbabilities, keyTargets, defaultTarget, (AllocatableValue)value);
            }
        }
    }

    private void emitShortCircuitOrNode(ShortCircuitOrNode node) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitShortCircuitOrNode: %s, (X: %s - isNegated: %s) || (Y: %s - isNegated: %s)", (Object[])new Object[]{node, node.getX(), node.isXNegated(), node.getY(), node.isYNegated()});
        LIRKind lirKind = LIRKind.value((PlatformKind)OCLKind.BOOL);
        Variable result = this.gen.newVariable((ValueKind)lirKind);
        Value x = this.getProcessedOperand(node.getX(), node.isXNegated());
        Value y = this.getProcessedOperand(node.getY(), node.isYNegated());
        OCLBinary.Expr orExpr = new OCLBinary.Expr(OCLAssembler.OCLBinaryOp.LOGICAL_OR, lirKind, x, y);
        this.append(new OCLLIRStmt.AssignStmt((AllocatableValue)result, orExpr));
        this.setResult((ValueNode)node, (Value)result);
    }

    private Value getProcessedOperand(LogicNode operand, boolean isNegated) {
        return isNegated ? this.emitNegatedLogicNode(operand) : this.operandOrConjunction((ValueNode)operand);
    }

    public void emitConditionalNode(ConditionalNode conditional) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitConditionalNode: %s", (Object[])new Object[]{conditional});
        Value tVal = this.operand((Node)conditional.trueValue());
        Value fVal = this.operand((Node)conditional.falseValue());
        this.setResult((ValueNode)conditional, (Value)this.emitConditional(conditional.condition(), tVal, fVal));
    }

    public Variable emitConditional(LogicNode node, Value trueValue, Value falseValue) {
        if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            LIRKind kind = this.gen.getLIRKind(isNullNode.getValue().stamp(NodeView.DEFAULT));
            Value nullValue = this.gen.emitConstant(kind, (Constant)isNullNode.nullConstant());
            return this.gen.emitConditionalMove(kind.getPlatformKind(), this.operand((Node)isNullNode.getValue()), nullValue, Condition.EQ, false, trueValue, falseValue);
        }
        if (node instanceof CompareNode) {
            CompareNode compare = (CompareNode)node;
            PlatformKind kind = this.gen.getLIRKind(compare.getX().stamp(NodeView.DEFAULT)).getPlatformKind();
            return this.gen.emitConditionalMove(kind, this.operand((Node)compare.getX()), this.operand((Node)compare.getY()), compare.condition().asCondition(), compare.unorderedIsTrue(), trueValue, falseValue);
        }
        if (node instanceof LogicConstantNode) {
            LogicConstantNode logicConstant = (LogicConstantNode)node;
            return this.gen.emitMove(logicConstant.getValue() ? trueValue : falseValue);
        }
        if (node instanceof IntegerTestNode) {
            IntegerTestNode test = (IntegerTestNode)node;
            return this.gen.emitIntegerTestMove(this.operand((Node)test.getX()), this.operand((Node)test.getY()), trueValue, falseValue);
        }
        if (node instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode orNode = (ShortCircuitOrNode)node;
            Value orValue = this.operand((Node)orNode);
            if (!(orValue.getValueKind() instanceof LIRKind)) {
                throw new GraalError("Expected LIRKind, but got: " + String.valueOf(orValue.getValueKind()));
            }
            LIRKind lirKind = (LIRKind)this.operand((Node)orNode).getValueKind();
            return this.gen.emitConditionalMove(lirKind.getPlatformKind(), orValue, this.gen.emitConstant(lirKind, (Constant)JavaConstant.forBoolean((boolean)true)), Condition.EQ, false, trueValue, falseValue);
        }
        throw TornadoInternalError.unimplemented((String)node.toString());
    }

    private void emitLoopExit(LoopExitNode node) {
        if (!node.loopBegin().getBlockNodes().contains((Node)((FixedNode)node.predecessor()))) {
            this.append(new OCLControlFlow.LoopBreakOp());
        }
    }

    protected void emitPrologue(StructuredGraph graph, boolean isKernel) {
        Local[] locals = graph.method().getLocalVariableTable().getLocalsAt(0);
        if (isKernel) {
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                this.setResult((ValueNode)param, this.getGen().getOCLGenTool().emitParameterLoad(locals[param.index()], param));
            }
        } else {
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                LIRKind lirKind = this.getGen().getLIRKind(param.stamp(NodeView.DEFAULT));
                this.setResult((ValueNode)param, new OCLNullary.Parameter(locals[param.index()].getName(), lirKind));
            }
        }
    }

    private void emitOCLFPGAPragmas(HIRBlock block) {
        for (ValueNode tempDomBlockNode : block.getNodes()) {
            if (!(tempDomBlockNode instanceof IntelUnrollPragmaNode) && !(tempDomBlockNode instanceof XilinxPipeliningPragmaNode)) continue;
            super.emitNode(tempDomBlockNode);
        }
    }

    private OCLLIRGenerator getGen() {
        return (OCLLIRGenerator)this.gen;
    }

    protected boolean peephole(ValueNode value) {
        return false;
    }

    public void visitBreakpointNode(BreakpointNode arg0) {
        TornadoInternalError.unimplemented();
    }

    public void visitEndNode(AbstractEndNode end) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"visitEnd: %s", (Object[])new Object[]{end});
        if (end instanceof LoopEndNode) {
            return;
        }
        HIRBlock curBlock = (HIRBlock)this.gen.getCurrentBlock();
        boolean shouldRelocateInstructions = false;
        AbstractBeginNode abstractBeginNode = curBlock.getBeginNode();
        if (abstractBeginNode instanceof LoopExitNode) {
            LoopExitNode loopExit;
            LoopExitNode loopExitNode = loopExit = (LoopExitNode)abstractBeginNode;
            LoopBeginNode loopBeginNode = loopExitNode.loopBegin();
            HIRBlock loopBeginBlock = (HIRBlock)loopBeginNode.graph().getLastSchedule().getNodeToBlockMap().get((Node)loopBeginNode);
            for (int i = 0; i < curBlock.getPredecessorCount(); ++i) {
                if (curBlock.getPredecessorAt(i) != loopBeginBlock) continue;
                shouldRelocateInstructions = true;
                break;
            }
        }
        if (shouldRelocateInstructions) {
            this.append(new OCLLIRStmt.MarkRelocateInstruction());
        }
        this.handleMergeAtEnd(end, curBlock);
    }

    private void handleMergeAtEnd(AbstractEndNode end, HIRBlock curBlock) {
        AbstractMergeNode merge = end.merge();
        if (merge == null) {
            return;
        }
        if (merge instanceof MergeNode && merge.next() instanceof ReturnNode) {
            HIRBlock pdom2 = curBlock.getDominator(2);
            HIRBlock predecessorBlock = curBlock.getFirstPredecessor();
            if (pdom2 != null && predecessorBlock != null && this.blockContainsIfNode(predecessorBlock) && this.blockContainsIfNode(pdom2)) {
                IfNode outerIf = OCLNodeLIRBuilder.getFirstNode(pdom2, IfNode.class);
                BeginNode predBegin = OCLNodeLIRBuilder.getFirstNode(predecessorBlock, BeginNode.class);
                if (outerIf.trueSuccessor() == predBegin) {
                    this.gen.emitReturn(null, null);
                    return;
                }
            }
            this.emitNonLoopPhiMoves(merge, end);
            return;
        }
        this.emitNonLoopPhiMoves(merge, end);
    }

    private void emitNonLoopPhiMoves(AbstractMergeNode merge, AbstractEndNode end) {
        for (ValuePhiNode phi : merge.valuePhis()) {
            ValueNode value = phi.valueAt(end);
            if ((phi.isLoopPhi() || phi.singleValueOrThis() != phi) && (!(value instanceof PhiNode) || ((PhiNode)value).isLoopPhi()) || (phi.isLoopPhi() || phi.singleValueOrThis() != phi) && (!(value instanceof PhiNode) || ((PhiNode)value).isLoopPhi())) continue;
            AllocatableValue result = this.gen.asAllocatable(this.operandForPhi(phi));
            this.append(new OCLLIRStmt.AssignStmt(result, this.operand((Node)value)));
        }
    }

    private boolean blockContainsIfNode(HIRBlock block) {
        boolean hasIfNode = false;
        if (block != null) {
            for (FixedNode n : block.getNodes()) {
                if (!(n instanceof IfNode)) continue;
                hasIfNode = true;
                break;
            }
        }
        return hasIfNode;
    }

    private static <T extends FixedNode> T getFirstNode(HIRBlock block, Class<T> type) {
        for (FixedNode n : block.getNodes()) {
            if (!type.isInstance(n)) continue;
            return (T)((FixedNode)type.cast(n));
        }
        return null;
    }

    public Value operandForPhi(ValuePhiNode phi) {
        Value result = this.operand((Node)phi);
        if (result == null) {
            Variable newOperand = this.gen.newVariable((ValueKind)this.getPhiKind((PhiNode)phi));
            this.setResult((ValueNode)phi, (Value)newOperand);
            return newOperand;
        }
        return result;
    }

    protected LIRKind getPhiKind(PhiNode phi) {
        ObjectStamp objectStamp;
        ObjectStamp oStamp;
        OCLKind oclKind;
        Object stamp = phi.stamp(NodeView.DEFAULT);
        if (stamp.isEmpty()) {
            for (ValueNode n : phi.values()) {
                if (stamp.isEmpty()) {
                    stamp = n.stamp(NodeView.DEFAULT);
                    continue;
                }
                stamp = stamp.meet(n.stamp(NodeView.DEFAULT));
            }
            phi.setStamp(stamp);
        } else if (stamp instanceof ObjectStamp && (oclKind = OCLKind.fromResolvedJavaType((oStamp = (objectStamp = (ObjectStamp)stamp)).javaType(this.gen.getMetaAccess()))) != OCLKind.ILLEGAL && oclKind.isVector()) {
            stamp = OCLStampFactory.getStampFor(oclKind);
            phi.setStamp(stamp);
        }
        return this.gen.getLIRKind(stamp);
    }

    public void visitSafepointNode(SafepointNode arg0) {
        TornadoInternalError.unimplemented();
    }
}

