/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.MidTierLoweringPhase;
import org.graalvm.compiler.phases.common.ReassociationPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.guards.BoundCheckEliminationPhase;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.guards.ExceptionCheckingElimination;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.loops.TornadoPartialLoopUnrollPhase;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc.TornadoPanamaSegmentsHeaderPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoFloatingReadReplacement;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoMidTier;

public class OCLMidTier
extends TornadoMidTier {
    public OCLMidTier(OptionValues options) {
        this.appendPhase((BasePhase)new TornadoPanamaSegmentsHeaderPhase());
        this.appendPhase((BasePhase)new ExceptionCheckingElimination());
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.appendPhase((BasePhase)canonicalizer);
        this.appendPhase((BasePhase)new BoundCheckEliminationPhase());
        this.appendPhase((BasePhase)new ExceptionCheckingElimination());
        if (((Boolean)GraalOptions.OptFloatingReads.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new TornadoFloatingReadReplacement(canonicalizer));
        }
        this.appendPhase((BasePhase)canonicalizer);
        if (((Boolean)GraalOptions.ConditionalElimination.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new IterativeConditionalEliminationPhase(canonicalizer, true));
        }
        this.appendPhase((BasePhase)new RemoveValueProxyPhase(canonicalizer));
        this.appendPhase((BasePhase)new GuardLoweringPhase());
        this.appendPhase((BasePhase)canonicalizer);
        if (TornadoOptions.isPartialUnrollEnabled()) {
            this.appendPhase((BasePhase)new TornadoPartialLoopUnrollPhase());
        }
        this.appendPhase((BasePhase)new MidTierLoweringPhase(canonicalizer));
        this.appendPhase((BasePhase)new FrameStateAssignmentPhase());
        if (((Boolean)GraalOptions.ReassociateExpressions.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new ReassociationPhase(canonicalizer));
        }
        this.appendPhase((BasePhase)canonicalizer);
    }
}

