/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.LowTierLoweringPhase;
import org.graalvm.compiler.phases.common.UseTrappingNullChecksPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.analysis.TornadoFeatureExtraction;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.loops.TornadoLoopCanonicalization;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.utils.DumpLowTierGraph;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.InfinityReplacementPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.InverseSquareRootPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFMAPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFP16SupportPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFP64SupportPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFPGAPragmaPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFPGAThreadScheduler;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.OCLFieldCoopsAccessPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoAtomicsParametersPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoAtomicsScheduling;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoFixedArrayCopyPhase;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoHalfFloatVectorOffset;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoLowTier;

public class OCLLowTier
extends TornadoLowTier {
    TornadoDeviceContext tornadoDeviceContext;

    public OCLLowTier(OptionValues options, TornadoDeviceContext tornadoDeviceContext, AddressLoweringByNodePhase.AddressLowering addressLowering) {
        this.tornadoDeviceContext = tornadoDeviceContext;
        CanonicalizerPhase canonicalizer = this.getCannonicalizer(options);
        this.appendPhase((BasePhase)new OCLFP64SupportPhase(tornadoDeviceContext));
        this.appendPhase((BasePhase)new OCLFP16SupportPhase(tornadoDeviceContext));
        this.appendPhase((BasePhase)new LowTierLoweringPhase(canonicalizer));
        if (((Boolean)GraalOptions.ConditionalElimination.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new IterativeConditionalEliminationPhase(canonicalizer, true));
        }
        if (TornadoOptions.ENABLE_FIX_READS) {
            this.appendPhase((BasePhase)new FixReadsPhase(true, (BasePhase)new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS)));
        }
        this.appendPhase((BasePhase)new UseTrappingNullChecksPhase());
        this.appendPhase((BasePhase)new TornadoFixedArrayCopyPhase());
        this.appendPhase((BasePhase)new AddressLoweringByNodePhase(addressLowering));
        this.appendPhase((BasePhase)new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required));
        if (tornadoDeviceContext.isPlatformFPGA()) {
            this.appendPhase((BasePhase)new OCLFPGAPragmaPhase(tornadoDeviceContext));
            this.appendPhase(new OCLFPGAThreadScheduler());
        }
        this.appendPhase((BasePhase)new TornadoHalfFloatVectorOffset());
        this.appendPhase((BasePhase)new TornadoLoopCanonicalization());
        if (TornadoOptions.ENABLE_FMA) {
            this.appendPhase((BasePhase)new OCLFMAPhase());
        }
        if (TornadoOptions.MATH_OPTIMIZATIONS) {
            this.appendPhase((BasePhase)new InverseSquareRootPhase());
        }
        this.appendPhase((BasePhase)new InfinityReplacementPhase());
        this.appendPhase((BasePhase)new TornadoAtomicsParametersPhase());
        this.appendPhase((BasePhase)new TornadoAtomicsScheduling());
        this.appendPhase((BasePhase)new OCLFieldCoopsAccessPhase());
        this.appendPhase((BasePhase)new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS));
        if (TornadoOptions.FEATURE_EXTRACTION) {
            this.appendPhase((BasePhase)new TornadoFeatureExtraction(tornadoDeviceContext));
        }
        if (TornadoOptions.DUMP_LOW_TIER_WITH_IGV) {
            this.appendPhase((BasePhase)new DumpLowTierGraph());
        }
    }

    private CanonicalizerPhase getCannonicalizer(OptionValues options) {
        return CanonicalizerPhase.create();
    }
}

