/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;
import org.graalvm.compiler.lir.gen.BarrierSetLIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.MoveFactory;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLLIRKindTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLBarrierSetLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLMoveFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLControlFlow;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLGenTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLNullary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLTernary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLLIRGenerator
extends LIRGenerator {
    private final OCLBuiltinTool oclBuiltinTool = new OCLBuiltinTool();
    private final OCLGenTool oclGenTool = new OCLGenTool(this);

    public OCLLIRGenerator(CodeGenProviders providers, LIRGenerationResult res) {
        super((LIRKindTool)new OCLLIRKindTool((OCLTargetDescription)providers.getCodeCache().getTarget()), (ArithmeticLIRGenerator)new OCLArithmeticTool(), (BarrierSetLIRGenerator)new OCLBarrierSetLIRGenerator(){}, (MoveFactory)new OCLMoveFactory(), providers, res);
    }

    public static OCLAssembler.OCLBinaryOp getConditionalOp(Condition condition) {
        return switch (condition) {
            case Condition.AE, Condition.GE -> OCLAssembler.OCLBinaryOp.RELATIONAL_GTE;
            case Condition.AT, Condition.GT -> OCLAssembler.OCLBinaryOp.RELATIONAL_GT;
            case Condition.EQ -> OCLAssembler.OCLBinaryOp.RELATIONAL_EQ;
            case Condition.BE, Condition.LE -> OCLAssembler.OCLBinaryOp.RELATIONAL_LTE;
            case Condition.BT, Condition.LT -> OCLAssembler.OCLBinaryOp.RELATIONAL_LT;
            case Condition.NE -> OCLAssembler.OCLBinaryOp.RELATIONAL_NE;
            default -> throw new IllegalStateException("Unexpected condition: " + String.valueOf(condition));
        };
    }

    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public void emitConvertNullToZero(AllocatableValue result, Value input) {
        TornadoInternalError.unimplemented();
    }

    public void emitConvertZeroToNull(AllocatableValue result, Value input) {
        TornadoInternalError.unimplemented();
    }

    public Value emitReadCallerStackPointer(Stamp wordStamp) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Value emitReadReturnAddress(Stamp wordStamp, int returnAddressSize) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        TornadoInternalError.unimplemented();
    }

    public void emitCacheWriteback(Value address) {
        TornadoInternalError.unimplemented();
    }

    public void emitCacheWritebackSync(boolean isPreSync) {
    }

    public void emitSpeculationFence() {
        TornadoInternalError.unimplemented();
    }

    public LIRKind getLIRKind(Stamp stamp) {
        return stamp instanceof OCLStamp ? LIRKind.value((PlatformKind)((OCLStamp)stamp).getOCLKind()) : super.getLIRKind(stamp);
    }

    public Variable newVariable(ValueKind<?> valueKind) {
        PlatformKind pk = valueKind.getPlatformKind();
        if (!(pk instanceof OCLKind)) {
            TornadoInternalError.shouldNotReachHere();
        }
        Variable variable = super.newVariable(valueKind);
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"newVariable: %s <- %s (%s)", (Object[])new Object[]{variable.toString(), valueKind.toString(), valueKind.getClass().getName()});
        OCLLIRGenerationResult res = (OCLLIRGenerationResult)this.getResult();
        res.insertVariable(variable);
        return variable;
    }

    public OCLLIRKindTool getLIRKindTool() {
        return (OCLLIRKindTool)super.getLIRKindTool();
    }

    public LIRInstruction createZapArgumentSpace(StackSlot[] sss, JavaConstant[] jcs) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public int getArrayLengthOffset() {
        return 0;
    }

    public Register getHeapBaseRegister() {
        return null;
    }

    public OCLGenTool getOCLGenTool() {
        return this.oclGenTool;
    }

    public LIRInstruction createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public Variable emitAddress(AllocatableValue allocatableValue) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public void emitCompareBranch(PlatformKind pk, Value value, Value value1, Condition cndtn, boolean bln, LabelRef lr, LabelRef lr1, double d) {
        TornadoInternalError.unimplemented();
    }

    public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitConditionalMove: (%s %s %s) ? %s : %s, unorderedIsTrue:%s", (Object[])new Object[]{left, cond, right, trueValue, falseValue, unorderedIsTrue});
        OCLAssembler.OCLBinaryOp condOp = OCLLIRGenerator.getConditionalOp(cond);
        OCLBinary.Expr condExpr = new OCLBinary.Expr(condOp, LIRKind.value((PlatformKind)cmpKind), left, right);
        OCLTernary.Select selectExpr = new OCLTernary.Select(LIRKind.combine((Value[])new Value[]{trueValue, falseValue}), condExpr, trueValue, falseValue);
        Variable variable = this.newVariable((ValueKind<?>)LIRKind.combine((Value[])new Value[]{trueValue, falseValue}));
        OCLLIRStmt.AssignStmt assignStmt = new OCLLIRStmt.AssignStmt((AllocatableValue)variable, selectExpr);
        this.append(assignStmt);
        return variable;
    }

    public void emitDeoptimize(Value actionAndReason, Value speculation, LIRFrameState state) {
        JavaConstant constant = ((ConstantValue)actionAndReason).getJavaConstant();
        DeoptimizationReason reason = this.getMetaAccess().decodeDeoptReason(constant);
        DeoptimizationAction action = this.getMetaAccess().decodeDeoptAction(constant);
        int debugId = this.getMetaAccess().decodeDebugId(constant);
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitDeoptimize: id=%d, reason=%s, action=%s", (Object[])new Object[]{debugId, reason, action});
        this.append(new OCLControlFlow.DeoptOp(actionAndReason));
    }

    public void emitIntegerTestBranch(Value value, Value value1, LabelRef lr, LabelRef lr1, double d) {
        TornadoInternalError.unimplemented();
    }

    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)("emitIntegerTestMove: " + String.valueOf(left) + " &" + String.valueOf(right) + " ? " + String.valueOf(trueValue) + " : " + String.valueOf(falseValue)), (Object[])new Object[0]);
        assert (left.getPlatformKind() == right.getPlatformKind() && ((OCLKind)left.getPlatformKind()).isInteger());
        assert (trueValue.getPlatformKind() == falseValue.getPlatformKind());
        OCLBinary.Expr condExpr = new OCLBinary.Expr(OCLAssembler.OCLBinaryOp.BITWISE_AND, null, left, right);
        OCLTernary.Select selectExpr = new OCLTernary.Select(LIRKind.combine((Value[])new Value[]{trueValue, falseValue}), condExpr, falseValue, trueValue);
        Variable variable = this.newVariable((ValueKind<?>)LIRKind.combine((Value[])new Value[]{trueValue, falseValue}));
        OCLLIRStmt.AssignStmt assignStmt = new OCLLIRStmt.AssignStmt((AllocatableValue)variable, selectExpr);
        this.append(assignStmt);
        return variable;
    }

    public Variable emitReverseBytes(Value operand) {
        return null;
    }

    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
    }

    public void emitStrategySwitch(SwitchStrategy strategy, AllocatableValue key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitStrategySwitch: key=%s", (Object[])new Object[]{key});
        this.append(new OCLControlFlow.SwitchOp(key, strategy.getKeyConstants(), keyTargets, defaultTarget));
    }

    protected void emitRangeTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue key) {
    }

    protected void emitHashTableSwitch(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value, Value hash) {
    }

    public void emitJump(LabelRef lr) {
        TornadoInternalError.unimplemented();
    }

    public void emitMembar(int i) {
        TornadoInternalError.unimplemented();
    }

    public void emitNullCheck(Value value, LIRFrameState lirfs) {
        if (!TornadoOptions.IGNORE_NULL_CHECKS) {
            TornadoInternalError.unimplemented();
        }
    }

    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        return null;
    }

    public Value emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        return null;
    }

    public Value emitAtomicReadAndAdd(LIRKind accessKind, Value address, Value delta) {
        return null;
    }

    public Value emitAtomicReadAndWrite(LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        return null;
    }

    public void emitOverflowCheckBranch(LabelRef lr, LabelRef lr1, LIRKind lirk, double d) {
        TornadoInternalError.unimplemented();
    }

    public void emitPause() {
        TornadoInternalError.unimplemented();
    }

    public void emitPrefetchAllocate(Value value) {
        TornadoInternalError.unimplemented();
    }

    public void emitReturn(JavaKind javaKind, Value input) {
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitReturn: input=%s", (Object[])new Object[]{input});
        if (input != null) {
            LIRKind lirKind = LIRKind.value((PlatformKind)input.getPlatformKind());
            OCLLIRStmt.ExprStmt stmt = new OCLLIRStmt.ExprStmt(new OCLUnary.Expr(OCLAssembler.OCLUnaryOp.RETURN, lirKind, input));
            this.append(stmt);
        } else {
            this.append(new OCLLIRStmt.ExprStmt(new OCLNullary.Expr(OCLAssembler.OCLNullaryOp.RETURN, LIRKind.Illegal)));
        }
    }

    public void emitUnwind(Value value) {
        TornadoInternalError.unimplemented();
    }

    public OCLBuiltinTool getOCLBuiltinTool() {
        return this.oclBuiltinTool;
    }

    public OCLTargetDescription target() {
        return (OCLTargetDescription)super.target();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return super.getValueKind(javaKind);
    }

    public OCLArithmeticTool getArithmetic() {
        return (OCLArithmeticTool)super.getArithmetic();
    }

    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        return kind;
    }

    protected JavaConstant zapValueForKind(PlatformKind pk) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public OCLGenTool getOclGenTool() {
        return this.oclGenTool;
    }
}

