/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.code.CallingConvention;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

public class OCLLIRGenerationResult
extends LIRGenerationResult {
    private final Map<OCLKind, Set<Variable>> variableTable = new HashMap<OCLKind, Set<Variable>>();

    public OCLLIRGenerationResult(CompilationIdentifier identifier, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig, CallingConvention callingConvention) {
        super(identifier, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
    }

    public void insertVariable(Variable variable) {
        TornadoInternalError.guarantee((boolean)(variable.getPlatformKind() instanceof OCLKind), (String)"invalid variable kind: %s", (Object[])new Object[]{variable.getValueKind()});
        OCLKind kind = (OCLKind)variable.getPlatformKind();
        this.variableTable.computeIfAbsent(kind, k -> new HashSet()).add(variable);
    }

    public Map<OCLKind, Set<Variable>> getVariableTable() {
        return this.variableTable;
    }
}

