/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.util.List;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.ssa.SSAUtil;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLNodeLIRBuilder;

public class OCLLIRGenerationPhase
extends LIRPhase<LIRGenerationContext> {
    private static void emitBlock(OCLNodeLIRBuilder nodeLirGen, LIRGenerationResult lirGenRes, HIRBlock b, StructuredGraph graph, BlockMap<List<Node>> blockMap, boolean isKernel) {
        if (lirGenRes.getLIR().getLIRforBlock((BasicBlock)b) == null) {
            for (int i = 0; i < b.getPredecessorCount(); ++i) {
                if (b.isLoopHeader() && ((HIRBlock)b.getPredecessorAt(i)).isLoopEnd()) continue;
                OCLLIRGenerationPhase.emitBlock(nodeLirGen, lirGenRes, (HIRBlock)b.getPredecessorAt(i), graph, blockMap, isKernel);
            }
            nodeLirGen.doBlock(b, graph, blockMap, isKernel);
        }
    }

    protected final void run(TargetDescription target, LIRGenerationResult lirGenRes, LIRGenerationContext context) {
        BasicBlock[] blocks;
        NodeLIRBuilderTool nodeLirBuilder = context.nodeLirBuilder;
        StructuredGraph graph = context.graph;
        StructuredGraph.ScheduleResult schedule = context.schedule;
        BlockMap blockMap = schedule.getBlockToNodesMap();
        for (BasicBlock b : blocks = lirGenRes.getLIR().getControlFlowGraph().getBlocks()) {
            OCLLIRGenerationPhase.emitBlock((OCLNodeLIRBuilder)nodeLirBuilder, lirGenRes, (HIRBlock)b, graph, (BlockMap<List<Node>>)blockMap, context.isKernel);
        }
        ((LIRGenerator)context.lirGen).beforeRegisterAllocation();
        assert (SSAUtil.verifySSAForm((LIR)lirGenRes.getLIR()));
    }

    public static final class LIRGenerationContext {
        private final StructuredGraph graph;
        private final LIRGeneratorTool lirGen;
        private final NodeLIRBuilderTool nodeLirBuilder;
        private final StructuredGraph.ScheduleResult schedule;
        private final boolean isKernel;

        public LIRGenerationContext(LIRGeneratorTool lirGen, NodeLIRBuilderTool nodeLirBuilder, StructuredGraph graph, StructuredGraph.ScheduleResult schedule, boolean isKernel) {
            this.nodeLirBuilder = nodeLirBuilder;
            this.lirGen = lirGen;
            this.graph = graph;
            this.schedule = schedule;
            this.isKernel = isKernel;
        }
    }
}

