/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.loop.phases.LoopFullUnrollPhase;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.HighTierLoweringPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.analysis.TornadoShapeAnalysis;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.guards.ExceptionSuppression;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.guards.TornadoValueTypeCleanup;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc.TornadoFieldAccessFixup;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc.TornadoLocalMemoryAllocation;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc.TornadoNewArrayDevirtualizationReplacement;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc.TornadoPrivateArrayPiRemoval;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoBatchGlobalIndexOffset;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoHalfFloatReplacement;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoOpenCLIntrinsicsReplacements;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoParallelScheduler;
import uk.ac.manchester.tornado.drivers.opencl.graal.phases.TornadoTaskSpecialisation;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoHighTier;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoFullInliningPolicy;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoPartialInliningPolicy;

public class OCLHighTier
extends TornadoHighTier {
    public OCLHighTier(OptionValues options, TornadoDeviceContext deviceContext, CanonicalizerPhase.CustomSimplification customCanonicalizer, MetaAccessProvider metaAccessProvider) {
        super(customCanonicalizer);
        CanonicalizerPhase canonicalizer = this.createCanonicalizerPhase(options, customCanonicalizer);
        this.appendPhase((BasePhase)canonicalizer);
        if (((Boolean)HighTier.Options.Inline.getValue(options)).booleanValue()) {
            TornadoFullInliningPolicy inliningPolicy = TornadoOptions.FULL_INLINING ? new TornadoFullInliningPolicy() : new TornadoPartialInliningPolicy();
            this.appendPhase((BasePhase)new InliningPhase((InliningPolicy)inliningPolicy, canonicalizer));
            this.appendPhase((BasePhase)new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
            if (((Boolean)GraalOptions.ConditionalElimination.getValue(options)).booleanValue()) {
                this.appendPhase((BasePhase)canonicalizer);
                this.appendPhase((BasePhase)new IterativeConditionalEliminationPhase(canonicalizer, false));
            }
        }
        this.appendPhase(new TornadoTaskSpecialisation(canonicalizer));
        this.appendPhase(new TornadoBatchGlobalIndexOffset());
        this.appendPhase((BasePhase)new TornadoFieldAccessFixup());
        this.appendPhase((BasePhase)canonicalizer);
        this.appendPhase((BasePhase)new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
        this.appendPhase((BasePhase)canonicalizer);
        this.appendPhase((BasePhase)new TornadoNewArrayDevirtualizationReplacement());
        this.appendPhase(new TornadoHalfFloatReplacement());
        if (((Boolean)GraalOptions.PartialEscapeAnalysis.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new PartialEscapePhase(true, canonicalizer, options));
        }
        this.appendPhase((BasePhase)new TornadoPrivateArrayPiRemoval());
        this.appendPhase((BasePhase)new TornadoValueTypeCleanup());
        if (((Boolean)GraalOptions.OptConvertDeoptsToGuards.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new ConvertDeoptimizeToGuardPhase(canonicalizer));
        }
        this.appendPhase((BasePhase)new TornadoShapeAnalysis());
        this.appendPhase((BasePhase)canonicalizer);
        this.appendPhase(new TornadoParallelScheduler());
        this.appendPhase((BasePhase)new SchedulePhase(SchedulePhase.SchedulingStrategy.EARLIEST));
        if (!deviceContext.isPlatformFPGA()) {
            DefaultLoopPolicies loopPolicies = new DefaultLoopPolicies();
            this.appendPhase((BasePhase)new LoopFullUnrollPhase(canonicalizer, (LoopPolicies)loopPolicies));
        }
        this.appendPhase((BasePhase)canonicalizer);
        this.appendPhase((BasePhase)new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
        this.appendPhase((BasePhase)new SchedulePhase(SchedulePhase.SchedulingStrategy.EARLIEST));
        this.appendPhase((BasePhase)new HighTierLoweringPhase(canonicalizer));
        this.appendPhase(new TornadoOpenCLIntrinsicsReplacements(metaAccessProvider));
        this.appendPhase((BasePhase)new TornadoLocalMemoryAllocation());
        this.appendPhase((BasePhase)new ExceptionSuppression());
    }

    private CanonicalizerPhase createCanonicalizerPhase(OptionValues options, CanonicalizerPhase.CustomSimplification customCanonicalizer) {
        CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
        return canonicalizerPhase.copyWithCustomSimplification(customCanonicalizer);
    }
}

