/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.PreAllocationOptimizationPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.TargetProvider;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLSuitesProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCanonicalizer;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerationPhase;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.BatchCompilationConfig;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.TornadoLIRSuites;
import uk.ac.manchester.tornado.runtime.graal.TornadoSuites;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoCompilerIdentifier;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoLowTierContext;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoMidTierContext;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.TornadoSketcher;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLCompiler {
    private static final AtomicInteger compilationId = new AtomicInteger();
    private static final TimerKey CompilerTimer = DebugContext.timer((CharSequence)"OpenCLGraalCompiler");
    private static final TimerKey FrontEnd = DebugContext.timer((CharSequence)"OpenCLFrontend");
    private static final TimerKey BackEnd = DebugContext.timer((CharSequence)"OpenCLBackend");
    private static final TimerKey EmitLIR = DebugContext.timer((CharSequence)"OpenCLEmitLIR");
    private static final TimerKey EmitCode = DebugContext.timer((CharSequence)"OpenCLEmitCode");
    private static final OCLLIRGenerationPhase LIR_GENERATION_PHASE = new OCLLIRGenerationPhase();

    public static <T extends OCLCompilationResult> T compile(Request<T> r) {
        assert (!r.graph.isFrozen());
        try (DebugContext.Scope s0 = TornadoCoreRuntime.getDebugContext().scope((Object)"GraalCompiler", (Object)r.graph, (Object)r.providers.getCodeCache());
             DebugCloseable a = CompilerTimer.start(TornadoCoreRuntime.getDebugContext());){
            OCLCompiler.emitFrontEnd(r.providers, r.backend, r.installedCodeOwner, r.args, r.meta, r.graph, r.graphBuilderSuite, r.optimisticOpts, r.profilingInfo, r.suites, r.isKernel, r.buildGraph, r.batchCompilationConfig);
            boolean isParallel = r.meta != null && (r.meta.isParallel() || r.meta.isGridSchedulerEnabled() && !r.meta.isGridSequential());
            OCLCompiler.emitBackEnd(r.graph, null, r.installedCodeOwner, r.backend, r.compilationResult, null, r.lirSuites, r.isKernel, isParallel, r.profiler);
        }
        catch (Throwable e) {
            throw TornadoCoreRuntime.getDebugContext().handle(e);
        }
        return r.compilationResult;
    }

    public static ProfilingInfo getProfilingInfo(StructuredGraph graph) {
        if (graph.method() != null) {
            return graph.method().getProfilingInfo();
        }
        return DefaultProfilingInfo.get((TriState)TriState.UNKNOWN);
    }

    private static boolean isGraphEmpty(StructuredGraph graph) {
        return graph.start().next() == null;
    }

    private static void emitFrontEnd(Providers providers, OCLBackend backend, ResolvedJavaMethod method, Object[] args, TaskDataContext meta, StructuredGraph graph, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, TornadoSuites suites, boolean isKernel, boolean buildGraph, BatchCompilationConfig batchCompilationConfig) {
        try (DebugContext.Scope s = TornadoCoreRuntime.getDebugContext().scope((Object)"OpenCLFrontend", (Object)new DebugDumpScope("OpenCLFrontend"));
             DebugCloseable a = FrontEnd.start(TornadoCoreRuntime.getDebugContext());){
            ((OCLCanonicalizer)suites.getHighTier().getCustomCanonicalizer()).setContext(providers.getMetaAccess(), method, args, meta);
            TornadoHighTierContext highTierContext = new TornadoHighTierContext(providers, graphBuilderSuite, optimisticOpts, method, args, meta, isKernel, batchCompilationConfig);
            if (buildGraph) {
                if (OCLCompiler.isGraphEmpty(graph)) {
                    graphBuilderSuite.apply(graph, (Object)highTierContext);
                    new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
                } else {
                    TornadoCoreRuntime.getDebugContext().dump(2, (Object)graph, "initial state");
                }
            }
            suites.getHighTier().apply(graph, (Object)highTierContext);
            graph.maybeCompress();
            TornadoMidTierContext midTierContext = new TornadoMidTierContext(providers, (TargetProvider)backend, optimisticOpts, profilingInfo, method, args, meta);
            suites.getMidTier().apply(graph, (Object)midTierContext);
            graph.maybeCompress();
            TornadoLowTierContext lowTierContext = new TornadoLowTierContext(providers, (TargetProvider)backend, meta);
            suites.getLowTier().apply(graph, (Object)lowTierContext);
            TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph.getLastSchedule(), "Final HIR schedule");
        }
        catch (Throwable e) {
            throw TornadoCoreRuntime.getDebugContext().handle(e);
        }
    }

    private static <T extends OCLCompilationResult> void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, OCLBackend backend, T compilationResult, RegisterConfig registerConfig, TornadoLIRSuites lirSuites, boolean isKernel, boolean isParallel, TornadoProfiler profiler) {
        try (DebugContext.Scope s = TornadoCoreRuntime.getDebugContext().scope((Object)"OpenCLBackend", (Object)graph.getLastSchedule());
             DebugCloseable a = BackEnd.start(TornadoCoreRuntime.getDebugContext());){
            LIRGenerationResult lirGen = null;
            lirGen = OCLCompiler.emitLIR(backend, graph, stub, registerConfig, lirSuites, compilationResult, isKernel);
            try (DebugContext.Scope s2 = TornadoCoreRuntime.getDebugContext().scope((Object)"OpenCLCodeGen", (Object)lirGen, (Object)lirGen.getLIR());){
                compilationResult.setHasUnsafeAccess(graph.hasUnsafeAccess());
                OCLCompiler.emitCode(backend, graph.getAssumptions(), graph.method(), graph.getMethods(), lirGen, compilationResult, installedCodeOwner, isKernel, isParallel, profiler);
            }
            catch (Throwable e) {
                throw TornadoCoreRuntime.getDebugContext().handle(e);
            }
        }
        catch (Throwable e) {
            throw TornadoCoreRuntime.getDebugContext().handle(e);
        }
    }

    public static <T extends CompilationResult> LIRGenerationResult emitLIR(OCLBackend backend, StructuredGraph graph, Object stub, RegisterConfig registerConfig, TornadoLIRSuites lirSuites, T compilationResult, boolean isKernel) {
        return OCLCompiler.emitLIR0(backend, graph, stub, registerConfig, lirSuites, compilationResult, isKernel);
    }

    protected static <T extends CompilationResult> String getCompilationUnitName(StructuredGraph graph, T compilationResult) {
        if (compilationResult != null && compilationResult.getName() != null) {
            return compilationResult.getName();
        }
        ResolvedJavaMethod method = graph.method();
        if (method == null) {
            return "<unknown>";
        }
        return method.format("%H.%n(%p)");
    }

    /*
     * Exception decompiling
     */
    private static <T extends CompilationResult> LIRGenerationResult emitLIR0(OCLBackend backend, StructuredGraph graph, Object stub, RegisterConfig registerConfig, TornadoLIRSuites lirSuites, T compilationResult, boolean isKernel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static LIRGenerationResult emitLowLevel(OCLTargetDescription target, LIRGenerationResult lirGenRes, LIRGeneratorTool lirGen, TornadoLIRSuites lirSuites, RegisterAllocationConfig registerAllocationConfig) {
        PreAllocationOptimizationPhase.PreAllocationOptimizationContext preAllocOptContext = new PreAllocationOptimizationPhase.PreAllocationOptimizationContext(lirGen);
        lirSuites.getPreAllocationStage().apply((TargetDescription)target, lirGenRes, (Object)preAllocOptContext);
        AllocationPhase.AllocationContext allocContext = new AllocationPhase.AllocationContext(lirGen.getSpillMoveFactory(), registerAllocationConfig);
        lirSuites.getAllocationStage().apply((TargetDescription)target, lirGenRes, (Object)allocContext);
        return lirGenRes;
    }

    public static void emitCode(OCLBackend backend, Assumptions assumptions, ResolvedJavaMethod rootMethod, List<ResolvedJavaMethod> inlinedMethods, LIRGenerationResult lirGenRes, OCLCompilationResult compilationResult, ResolvedJavaMethod installedCodeOwner, boolean isKernel, boolean isParallel, TornadoProfiler profiler) {
        try (DebugCloseable a = EmitCode.start(TornadoCoreRuntime.getDebugContext());){
            FrameMap frameMap = lirGenRes.getFrameMap();
            OCLCompilationResultBuilder crb = backend.newCompilationResultBuilder(frameMap, compilationResult, isKernel, isParallel, lirGenRes.getLIR());
            backend.emitCode(crb, lirGenRes.getLIR(), installedCodeOwner, profiler);
            if (assumptions != null && !assumptions.isEmpty()) {
                compilationResult.setAssumptions(assumptions.toArray());
            }
            if (inlinedMethods != null) {
                compilationResult.setMethods(rootMethod, inlinedMethods);
            }
            compilationResult.setNonInlinedMethods(crb.getNonInlinedMethods());
            crb.finish();
            if (TornadoCoreRuntime.getDebugContext().isCountEnabled()) {
                DebugContext.counter((CharSequence)"CompilationResults").increment(TornadoCoreRuntime.getDebugContext());
                DebugContext.counter((CharSequence)"CodeBytesEmitted").add(TornadoCoreRuntime.getDebugContext(), (long)compilationResult.getTargetCodeSize());
            }
            TornadoCoreRuntime.getDebugContext().dump(1, (Object)compilationResult, "After code generation");
        }
    }

    public static OCLCompilationResult compileCodeForDevice(ResolvedJavaMethod resolvedMethod, Object[] args, TaskDataContext meta, OCLProviders providers, OCLBackend backend, TornadoProfiler profiler) {
        return OCLCompiler.compileCodeForDevice(resolvedMethod, args, meta, providers, backend, new BatchCompilationConfig(0L, 0, 0L), profiler);
    }

    public static OCLCompilationResult compileCodeForDevice(ResolvedJavaMethod resolvedMethod, Object[] args, TaskDataContext meta, OCLProviders providers, OCLBackend backend, BatchCompilationConfig batchCompilationConfig, TornadoProfiler profiler) {
        new TornadoLogger().info("Compiling %s on %s", new Object[]{resolvedMethod.getName(), backend.getDeviceContext().getDevice().getDeviceName()});
        TornadoCompilerIdentifier id = new TornadoCompilerIdentifier("compile-kernel" + resolvedMethod.getName(), compilationId.getAndIncrement());
        StructuredGraph.Builder builder = new StructuredGraph.Builder(TornadoCoreRuntime.getOptions(), TornadoCoreRuntime.getDebugContext(), StructuredGraph.AllowAssumptions.YES);
        builder.method(resolvedMethod);
        builder.compilationId((CompilationIdentifier)id);
        builder.name("compile-kernel" + resolvedMethod.getName());
        StructuredGraph kernelGraph = builder.build();
        OptimisticOptimizations optimisticOpts = OptimisticOptimizations.ALL;
        ProfilingInfo profilingInfo = resolvedMethod.getProfilingInfo();
        OCLCompilationResult kernelCompResult = new OCLCompilationResult("internal", resolvedMethod.getName(), meta, backend);
        CompilationResultBuilderFactory factory = CompilationResultBuilderFactory.Default;
        OCLSuitesProvider suitesProvider = providers.getSuitesProvider();
        Request<OCLCompilationResult> kernelCompilationRequest = new Request<OCLCompilationResult>(kernelGraph, resolvedMethod, args, meta, providers, backend, suitesProvider.getGraphBuilderSuite(), optimisticOpts, profilingInfo, suitesProvider.getSuites(), suitesProvider.getLIRSuites(), kernelCompResult, factory, true, true, batchCompilationConfig, profiler);
        kernelCompilationRequest.execute();
        ArrayDeque<ResolvedJavaMethod> workList = new ArrayDeque<ResolvedJavaMethod>(kernelCompResult.getNonInlinedMethods());
        while (!workList.isEmpty()) {
            StructuredGraph.Builder builder1 = new StructuredGraph.Builder(TornadoCoreRuntime.getOptions(), TornadoCoreRuntime.getDebugContext(), StructuredGraph.AllowAssumptions.YES);
            builder1.method(resolvedMethod);
            builder1.compilationId((CompilationIdentifier)id);
            ResolvedJavaMethod currentMethod = (ResolvedJavaMethod)workList.pop();
            builder1.name("internal" + currentMethod.getName());
            StructuredGraph graph = builder.build();
            OCLCompilationResult compResult = new OCLCompilationResult("internal", currentMethod.getName(), meta, backend);
            Request<OCLCompilationResult> methodCompilationRequest = new Request<OCLCompilationResult>(graph, currentMethod, null, null, providers, backend, suitesProvider.getGraphBuilderSuite(), optimisticOpts, profilingInfo, suitesProvider.getSuites(), suitesProvider.getLIRSuites(), compResult, factory, false, true, new BatchCompilationConfig(0L, 0, 0L), profiler);
            methodCompilationRequest.execute();
            workList.addAll(compResult.getNonInlinedMethods());
            kernelCompResult.addCompiledMethodCode(compResult.getTargetCode());
        }
        return kernelCompResult;
    }

    public static synchronized OCLCompilationResult compileSketchForDevice(Sketch sketch, CompilableTask task, OCLProviders providers, OCLBackend backend, TornadoProfiler profiler) {
        StructuredGraph kernelGraph = (StructuredGraph)sketch.getGraph().copy(TornadoCoreRuntime.getDebugContext());
        ResolvedJavaMethod resolvedMethod = kernelGraph.method();
        new TornadoLogger().info("Compiling sketch %s on %s", new Object[]{resolvedMethod.getName(), backend.getDeviceContext().getDevice().getDeviceName()});
        TaskDataContext taskMeta = task.meta();
        Object[] args = task.getArguments();
        long batchThreads = taskMeta.getNumThreads() > 0L ? taskMeta.getNumThreads() : task.getBatchThreads();
        int batchNumber = task.getBatchNumber();
        long batchSize = task.getBatchSize();
        BatchCompilationConfig batchCompilationConfig = new BatchCompilationConfig(batchThreads, batchNumber, batchSize);
        taskMeta.setCompiledGraph((Object)resolvedMethod);
        OptimisticOptimizations optimisticOpts = OptimisticOptimizations.ALL;
        ProfilingInfo profilingInfo = resolvedMethod.getProfilingInfo();
        String kernelName = OCLDeviceContext.checkKernelName(resolvedMethod.getName());
        OCLCompilationResult kernelCompResult = new OCLCompilationResult(task.getId(), kernelName, taskMeta, backend);
        CompilationResultBuilderFactory factory = CompilationResultBuilderFactory.Default;
        HashSet<ResolvedJavaMethod> methods = new HashSet<ResolvedJavaMethod>();
        OCLSuitesProvider suitesProvider = providers.getSuitesProvider();
        Request<OCLCompilationResult> kernelCompilationRequest = new Request<OCLCompilationResult>(kernelGraph, resolvedMethod, args, taskMeta, providers, backend, suitesProvider.getGraphBuilderSuite(), optimisticOpts, profilingInfo, suitesProvider.getSuites(), suitesProvider.getLIRSuites(), kernelCompResult, factory, true, false, batchCompilationConfig, profiler);
        kernelCompilationRequest.execute();
        if (TornadoOptions.DUMP_COMPILED_METHODS) {
            methods.add(kernelGraph.method());
            methods.addAll(kernelGraph.getMethods());
            Collections.addAll(methods, kernelCompResult.getMethods());
        }
        HashSet<ResolvedJavaMethod> nonInlinedCompiledMethods = new HashSet<ResolvedJavaMethod>();
        ArrayDeque<ResolvedJavaMethod> workList = new ArrayDeque<ResolvedJavaMethod>(kernelCompResult.getNonInlinedMethods());
        while (!workList.isEmpty()) {
            ResolvedJavaMethod currentMethod = (ResolvedJavaMethod)workList.pop();
            if (nonInlinedCompiledMethods.contains(currentMethod)) continue;
            nonInlinedCompiledMethods.add(currentMethod);
            Sketch currentSketch = TornadoSketcher.lookup((ResolvedJavaMethod)currentMethod, (int)task.meta().getBackendIndex(), (int)task.meta().getDeviceIndex());
            StructuredGraph graph = (StructuredGraph)currentSketch.getGraph().copy(TornadoCoreRuntime.getDebugContext());
            String subKernelName = OCLDeviceContext.checkKernelName(currentMethod.getName());
            OCLCompilationResult compResult = new OCLCompilationResult(task.getId(), subKernelName, taskMeta, backend);
            Request<OCLCompilationResult> methodCompilationRequest = new Request<OCLCompilationResult>(graph, currentMethod, null, null, providers, backend, suitesProvider.getGraphBuilderSuite(), optimisticOpts, profilingInfo, suitesProvider.getSuites(), suitesProvider.getLIRSuites(), compResult, factory, false, false, new BatchCompilationConfig(0L, 0, 0L), profiler);
            methodCompilationRequest.execute();
            workList.addAll(compResult.getNonInlinedMethods());
            if (TornadoOptions.DUMP_COMPILED_METHODS) {
                methods.add(graph.method());
                methods.addAll(graph.getMethods());
            }
            kernelCompResult.addCompiledMethodCode(compResult.getTargetCode());
        }
        if (TornadoOptions.DUMP_COMPILED_METHODS) {
            Path outDir = Paths.get("./opencl-compiled-methods", new String[0]);
            if (!Files.exists(outDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    TornadoLogger logger = new TornadoLogger();
                    logger.error("unable to create cache dir: %s", new Object[]{outDir.toString()});
                    logger.error(e.getMessage());
                }
            }
            TornadoInternalError.guarantee((boolean)Files.isDirectory(outDir, new LinkOption[0]), (String)"cache directory is not a directory: %s", (Object[])new Object[]{outDir.toAbsolutePath().toString()});
            File file = new File(String.valueOf(outDir) + "/" + task.getId() + "-" + resolvedMethod.getName());
            try (PrintWriter pw = new PrintWriter(file);){
                for (ResolvedJavaMethod m : methods) {
                    pw.printf("%s,%s\n", m.getDeclaringClass().getName(), m.getName());
                }
            }
            catch (IOException e) {
                new TornadoLogger().error("unable to dump source: ", new Object[]{e.getMessage()});
            }
        }
        return kernelCompResult;
    }

    public static class Request<T extends OCLCompilationResult> {
        public final StructuredGraph graph;
        public final ResolvedJavaMethod installedCodeOwner;
        public final Object[] args;
        public final TaskDataContext meta;
        public final Providers providers;
        public final OCLBackend backend;
        public final PhaseSuite<HighTierContext> graphBuilderSuite;
        public final OptimisticOptimizations optimisticOpts;
        public final ProfilingInfo profilingInfo;
        public final TornadoSuites suites;
        public final TornadoLIRSuites lirSuites;
        public final T compilationResult;
        public final CompilationResultBuilderFactory factory;
        public final boolean isKernel;
        public final boolean buildGraph;
        public final BatchCompilationConfig batchCompilationConfig;
        public TornadoProfiler profiler;

        public Request(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Object[] args, TaskDataContext meta, Providers providers, OCLBackend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, TornadoSuites suites, TornadoLIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, boolean isKernel, boolean buildGraph, BatchCompilationConfig batchCompilationConfig, TornadoProfiler profiler) {
            this.graph = graph;
            this.installedCodeOwner = installedCodeOwner;
            this.args = args;
            this.meta = meta;
            this.providers = providers;
            this.backend = backend;
            this.graphBuilderSuite = graphBuilderSuite;
            this.optimisticOpts = optimisticOpts;
            this.profilingInfo = profilingInfo;
            this.suites = suites;
            this.lirSuites = lirSuites;
            this.compilationResult = compilationResult;
            this.factory = factory;
            this.isKernel = isKernel;
            this.buildGraph = buildGraph;
            this.batchCompilationConfig = batchCompilationConfig;
            this.profiler = profiler;
        }

        public T execute() {
            return OCLCompiler.compile(this);
        }
    }
}

