/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.IntStream;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.options.OptionValues;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLBlockVisitor;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLControlFlow;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.TornadoLIRGenerator;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLCompilationResultBuilder
extends CompilationResultBuilder {
    private final Set<ResolvedJavaMethod> nonInlinedMethods = new HashSet<ResolvedJavaMethod>();
    protected LIR lir;
    HashSet<HIRBlock> rescheduledBasicBlocks;
    private int currentBlockIndex;
    private boolean isKernel;
    private int loops = 0;
    private boolean isParallel;
    private TaskDataContext metaData;
    private long[] localGrid;
    private OCLDeviceContextInterface deviceContext;

    public OCLCompilationResultBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, LIR lir) {
        super(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, Register.None, EconomicMap.create((Equivalence)Equivalence.DEFAULT), NO_VERIFIERS, lir);
    }

    private static boolean isMergeHIRBlock(HIRBlock block) {
        return block.getBeginNode() instanceof AbstractMergeNode;
    }

    private static boolean isLoopConditionRightAfterHeader(int loopCondIndex, int loopPostOpIndex, int loopInitOpIndex) {
        return loopCondIndex - 1 == loopPostOpIndex && loopCondIndex - 2 == loopInitOpIndex;
    }

    private static boolean shouldFormatLoopHeader(List<LIRInstruction> instructions) {
        int loopInitOpIndex = -1;
        int loopPostOpIndex = -1;
        int loopConditionOpIndex = -1;
        int instructionsSize = instructions.size();
        for (int index = 0; index < instructionsSize; ++index) {
            LIRInstruction instruction = instructions.get(index);
            if (instruction instanceof OCLControlFlow.LoopInitOp) {
                loopInitOpIndex = index;
            }
            if (instruction instanceof OCLControlFlow.LoopPostOp) {
                loopPostOpIndex = index;
            }
            if (!(instruction instanceof OCLControlFlow.LoopConditionOp)) continue;
            loopConditionOpIndex = index;
        }
        return OCLCompilationResultBuilder.isLoopConditionRightAfterHeader(loopConditionOpIndex, loopPostOpIndex, loopInitOpIndex);
    }

    private static void formatLoopHeader(List<LIRInstruction> instructions) {
        int index = instructions.size() - 1;
        LIRInstruction condition = instructions.get(index);
        while (!(condition instanceof OCLControlFlow.LoopConditionOp)) {
            condition = instructions.get(--index);
        }
        ((OCLControlFlow.LoopConditionOp)condition).setGenerateIfBreakStatement(false);
        instructions.remove(index);
        HashSet<Value> dependencies = new HashSet<Value>();
        DepFinder df = new DepFinder(dependencies);
        condition.forEachInput((InstructionValueProcedure)df);
        ArrayList<LIRInstruction> moved = new ArrayList<LIRInstruction>();
        LIRInstruction insn = instructions.get(--index);
        while (!(insn instanceof OCLControlFlow.LoopPostOp)) {
            Variable var;
            OCLLIRStmt.AssignStmt assign;
            if (insn instanceof OCLLIRStmt.AssignStmt && (assign = (OCLLIRStmt.AssignStmt)insn).getResult() instanceof Variable && dependencies.contains(var = (Variable)assign.getResult())) {
                moved.add(instructions.remove(index));
            }
            insn = instructions.get(--index);
        }
        LIRInstruction loopInit = instructions.get(instructions.size() - 1);
        while (!(loopInit instanceof OCLControlFlow.LoopInitOp)) {
            loopInit = instructions.get(--index);
        }
        instructions.add(index + 1, condition);
        instructions.addAll(index - 1, moved);
    }

    private static boolean isLoopDependencyNode(LIRInstruction op) {
        return op instanceof OCLControlFlow.LoopInitOp || op instanceof OCLControlFlow.LoopConditionOp || op instanceof OCLControlFlow.LoopPostOp;
    }

    private static void emitOp(CompilationResultBuilder crb, LIRInstruction op) {
        try {
            TornadoLIRGenerator.trace((String)("op: " + String.valueOf(op)));
            op.emitCode(crb);
        }
        catch (AssertionError | RuntimeException t) {
            throw new TornadoInternalError((Throwable)t);
        }
    }

    private static boolean isLoopBlock(HIRBlock block, HIRBlock loopHeader) {
        HashSet<HIRBlock> visited = new HashSet<HIRBlock>();
        Stack<HIRBlock> stack = new Stack<HIRBlock>();
        stack.push(block);
        while (!stack.isEmpty()) {
            HIRBlock[] successors;
            HIRBlock b = (HIRBlock)stack.pop();
            visited.add(b);
            if (b.getId() < loopHeader.getId()) {
                return false;
            }
            if (b == loopHeader) {
                return true;
            }
            for (HIRBlock successor : successors = (HIRBlock[])IntStream.range(0, b.getSuccessorCount()).mapToObj(arg_0 -> ((HIRBlock)b).getSuccessorAt(arg_0)).toArray(HIRBlock[]::new)) {
                if (visited.contains(successor)) continue;
                stack.push(successor);
            }
        }
        return false;
    }

    public boolean isParallel() {
        return this.isParallel;
    }

    public void setParallel(boolean parallel) {
        this.isParallel = parallel;
    }

    public OCLCompilationResult getResult() {
        return (OCLCompilationResult)this.compilationResult;
    }

    public boolean shouldRemoveLoop() {
        return this.isParallel() && this.deviceContext.isPlatformFPGA();
    }

    public boolean isKernel() {
        return this.isKernel;
    }

    public void setKernel(boolean value) {
        this.isKernel = value;
    }

    public OCLAssembler getAssembler() {
        return (OCLAssembler)this.asm;
    }

    public void addNonInlinedMethod(ResolvedJavaMethod method) {
        this.nonInlinedMethods.add(method);
    }

    Set<ResolvedJavaMethod> getNonInlinedMethods() {
        return this.nonInlinedMethods;
    }

    public void emit(LIR lir) {
        assert (this.lir == null);
        assert (this.currentBlockIndex == 0);
        this.lir = lir;
        this.currentBlockIndex = 0;
        this.frameContext.enter((CompilationResultBuilder)this);
        ControlFlowGraph cfg = (ControlFlowGraph)lir.getControlFlowGraph();
        TornadoLIRGenerator.trace((String)"Traversing CFG: ", (Object[])new Object[]{cfg.graph.name});
        cfg.computePostdominators();
        this.traverseControlFlowGraph(cfg, new OCLBlockVisitor(this));
        TornadoLIRGenerator.trace((String)"Finished traversing CFG");
        this.lir = null;
        this.currentBlockIndex = 0;
    }

    public void finish() {
        int position = this.asm.position();
        this.compilationResult.setTargetCode(this.asm.close(true), position);
    }

    void emitLoopBlock(HIRBlock block) {
        ArrayList headerInstructions = this.lir.getLIRforBlock((BasicBlock)block);
        if (OCLCompilationResultBuilder.shouldFormatLoopHeader(headerInstructions)) {
            OCLCompilationResultBuilder.formatLoopHeader(headerInstructions);
        }
        this.emitBlock(block);
    }

    void emitRelocatedInstructions(HIRBlock block) {
        if (block == null) {
            return;
        }
        TornadoLIRGenerator.trace((String)"block on exit %d", (Object[])new Object[]{block.getId()});
        boolean relocatableInstruction = false;
        for (LIRInstruction op : this.lir.getLIRforBlock((BasicBlock)block)) {
            if (op instanceof OCLLIRStmt.MarkRelocateInstruction) {
                relocatableInstruction = true;
            }
            if (op == null || !relocatableInstruction) continue;
            try {
                OCLCompilationResultBuilder.emitOp(this, op);
            }
            catch (TornadoInternalError e) {
                throw e.addContext("lir instruction", (Object)(String.valueOf(block) + "@" + op.id() + " " + String.valueOf(op) + "\n"));
            }
        }
    }

    void emitBlock(HIRBlock block) {
        if (block == null) {
            return;
        }
        TornadoLIRGenerator.trace((String)"block: %d", (Object[])new Object[]{block.getId()});
        this.printBasicHIRBlockTrace(block);
        LIRInstruction breakInst = null;
        boolean relocatableInstruction = false;
        for (LIRInstruction op : this.lir.getLIRforBlock((BasicBlock)block)) {
            if (op instanceof OCLLIRStmt.MarkRelocateInstruction) {
                relocatableInstruction = true;
            }
            if (op == null || relocatableInstruction) continue;
            if (op instanceof OCLControlFlow.LoopBreakOp) {
                breakInst = op;
                continue;
            }
            if (this.shouldRemoveLoop() && this.loops == 0 && OCLCompilationResultBuilder.isLoopDependencyNode(op)) {
                if (!(op instanceof OCLControlFlow.LoopPostOp)) continue;
                ++this.loops;
                continue;
            }
            if (((Boolean)CompilationResultBuilder.Options.PrintLIRWithAssembly.getValue(this.getOptions())).booleanValue()) {
                this.blockComment(String.format("%d %s", op.id(), op));
            }
            try {
                OCLCompilationResultBuilder.emitOp(this, op);
            }
            catch (TornadoInternalError e) {
                throw e.addContext("lir instruction", (Object)(String.valueOf(block) + "@" + op.id() + " " + String.valueOf(op) + "\n"));
            }
        }
        if (breakInst != null) {
            try {
                OCLCompilationResultBuilder.emitOp(this, breakInst);
            }
            catch (TornadoInternalError e) {
                throw e.addContext("lir instruction", (Object)(String.valueOf(block) + "@" + breakInst.id() + " " + String.valueOf(breakInst) + "\n"));
            }
        }
    }

    void printBasicHIRBlockTrace(HIRBlock block) {
        if (OCLCompilationResultBuilder.isMergeHIRBlock(block)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < block.getPredecessorCount(); ++i) {
                sb.append(((HIRBlock)block.getPredecessorAt(i)).getId()).append(" ");
            }
            sb.append("]");
            ((OCLAssembler)this.asm).emitLine("// BLOCK %d MERGES %s", block.getId(), sb.toString());
        } else {
            ((OCLAssembler)this.asm).emitLine("// BLOCK %d", block.getId());
        }
        if (((Boolean)CompilationResultBuilder.Options.PrintLIRWithAssembly.getValue(this.getOptions())).booleanValue()) {
            this.blockComment(String.format("block B%d %s", block.getId(), block.getLoop()));
        }
    }

    private void traverseControlFlowGraph(ControlFlowGraph cfg, OCLBlockVisitor visitor) {
        this.traverseControlFlowGraph(cfg.getStartBlock(), visitor, new HashSet<HIRBlock>(), new HashMap<HIRBlock, HIRBlock>());
        if (this.rescheduledBasicBlocks != null) {
            this.rescheduledBasicBlocks.clear();
        }
    }

    private void rescheduleBasicBlock(HIRBlock basicHIRBlock, OCLBlockVisitor visitor, HashSet<HIRBlock> visited, HashMap<HIRBlock, HIRBlock> pending) {
        HIRBlock block = pending.get(basicHIRBlock);
        visitor.enter(block);
        visitor.exit(block, null);
        visited.add(block);
        pending.remove(block);
        if (this.rescheduledBasicBlocks == null) {
            this.rescheduledBasicBlocks = new HashSet();
        }
        this.rescheduledBasicBlocks.add(block);
    }

    private boolean isFalseSuccessorWithLoopEnd(IfNode ifNode, HIRBlock basicHIRBlock) {
        return this.isCurrentHIRBlockAFalseBranch(ifNode, basicHIRBlock) && basicHIRBlock.getEndNode() instanceof LoopEndNode;
    }

    private boolean isCurrentHIRBlockAFalseBranch(IfNode ifNode, HIRBlock basicHIRBlock) {
        return ifNode.falseSuccessor() == basicHIRBlock.getBeginNode();
    }

    private boolean isTrueBranchALoopExitNode(IfNode ifNode) {
        return ifNode.trueSuccessor() instanceof AbstractBeginNode;
    }

    private boolean isTrueBranchWithEndNodeOrNotControlSplit(HIRBlock blockTrueBranch) {
        return blockTrueBranch.getEndNode() instanceof AbstractEndNode || !(blockTrueBranch.getEndNode() instanceof ControlSplitNode);
    }

    private void rescheduleTrueBranchConditionsIfNeeded(HIRBlock basicBlock, OCLBlockVisitor visitor, HashSet<HIRBlock> visited, HashMap<HIRBlock, HIRBlock> pending) {
        if (!basicBlock.isLoopHeader() && basicBlock.getDominator() != null && ((HIRBlock)basicBlock.getDominator()).getEndNode() instanceof IfNode) {
            IfNode ifNode = (IfNode)((HIRBlock)basicBlock.getDominator()).getEndNode();
            HIRBlock blockTrueBranch = this.getBlockTrueBranch(basicBlock);
            if (this.isNotLoopBeginIf(ifNode)) {
                boolean shouldReschedule;
                boolean bl = shouldReschedule = this.isFalseSuccessorWithLoopEnd(ifNode, basicBlock) || this.isCurrentHIRBlockAFalseBranch(ifNode, basicBlock) && this.isTrueBranchALoopExitNode(ifNode) && this.isTrueBranchWithEndNodeOrNotControlSplit(blockTrueBranch);
                if (shouldReschedule) {
                    for (int i = 0; i < ((HIRBlock)basicBlock.getDominator()).getSuccessorCount(); ++i) {
                        HIRBlock successor = (HIRBlock)((HIRBlock)basicBlock.getDominator()).getSuccessorAt(i);
                        if (successor.getBeginNode() != ifNode.trueSuccessor() || visited.contains(successor)) continue;
                        pending.put(basicBlock, successor);
                        this.rescheduleBasicBlock(basicBlock, visitor, visited, pending);
                    }
                }
            }
        }
    }

    private boolean isNotLoopBeginIf(IfNode ifNode) {
        return !(ifNode.predecessor() instanceof LoopBeginNode);
    }

    private void traverseControlFlowGraph(HIRBlock basicBlock, OCLBlockVisitor visitor, HashSet<HIRBlock> visited, HashMap<HIRBlock, HIRBlock> pending) {
        if (pending.containsKey(basicBlock) && !visited.contains(pending.get(basicBlock))) {
            this.rescheduleBasicBlock(basicBlock, visitor, visited, pending);
        }
        this.rescheduleTrueBranchConditionsIfNeeded(basicBlock, visitor, visited, pending);
        visitor.enter(basicBlock);
        visited.add(basicBlock);
        HIRBlock firstDominated = (HIRBlock)basicBlock.getFirstDominated();
        LinkedList<HIRBlock> queue = new LinkedList<HIRBlock>();
        queue.add(firstDominated);
        if (basicBlock.isLoopHeader()) {
            HIRBlock[] successors = (HIRBlock[])IntStream.range(0, basicBlock.getSuccessorCount()).mapToObj(arg_0 -> ((HIRBlock)basicBlock).getSuccessorAt(arg_0)).toArray(HIRBlock[]::new);
            LinkedList<HIRBlock> last = new LinkedList<HIRBlock>();
            LinkedList<HIRBlock> pendingList = new LinkedList<HIRBlock>();
            FixedNode endNode = basicBlock.getEndNode();
            IfNode ifNode = null;
            if (endNode instanceof IfNode) {
                ifNode = (IfNode)endNode;
            }
            for (HIRBlock block : successors) {
                boolean isInnerLoop = OCLCompilationResultBuilder.isLoopBlock(block, basicBlock);
                if (!isInnerLoop) {
                    assert (ifNode != null);
                    if (ifNode.trueSuccessor() == block.getBeginNode() && block.getBeginNode() instanceof LoopExitNode && block.getEndNode() instanceof EndNode) {
                        pendingList.addFirst(block);
                        if (!(block.getPostdominator().getBeginNode() instanceof MergeNode)) continue;
                        pending.put(block.getPostdominator(), block);
                        continue;
                    }
                    last.addLast(block);
                    continue;
                }
                queue.addLast(block);
            }
            for (HIRBlock l : pendingList) {
                last.addLast(l);
            }
            for (HIRBlock l : last) {
                queue.addLast(l);
            }
            queue.removeFirst();
        }
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            HIRBlock block;
            for (firstDominated = block = (HIRBlock)iterator.next(); firstDominated != null; firstDominated = (HIRBlock)firstDominated.getDominatedSibling()) {
                if (visited.contains(firstDominated)) continue;
                this.traverseControlFlowGraph(firstDominated, visitor, visited, pending);
            }
        }
        if (this.rescheduledBasicBlocks == null || !this.rescheduledBasicBlocks.contains(basicBlock)) {
            visitor.exit(basicBlock, null);
        }
    }

    private HIRBlock getBlockTrueBranch(HIRBlock basicHIRBlock) {
        IfNode ifNode = (IfNode)((HIRBlock)basicHIRBlock.getDominator()).getEndNode();
        for (int i = 0; i < ((HIRBlock)basicHIRBlock.getDominator()).getSuccessorCount(); ++i) {
            if (ifNode.trueSuccessor() != ((HIRBlock)((HIRBlock)basicHIRBlock.getDominator()).getSuccessorAt(i)).getBeginNode()) continue;
            return (HIRBlock)((HIRBlock)basicHIRBlock.getDominator()).getSuccessorAt(i);
        }
        return null;
    }

    public TaskDataContext getTaskMetaData() {
        return ((OCLCompilationResult)this.compilationResult).getMeta();
    }

    public OCLDeviceContextInterface getDeviceContext() {
        return this.deviceContext;
    }

    public void setDeviceContext(OCLDeviceContextInterface deviceContext) {
        this.deviceContext = deviceContext;
    }

    @Deprecated
    private static class DepFinder
    implements InstructionValueProcedure {
        private final Set<Value> dependencies;

        DepFinder(Set<Value> dependencies) {
            this.dependencies = dependencies;
        }

        public Value doValue(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (value instanceof Variable) {
                this.dependencies.add(value);
            }
            return value;
        }

        public Set<Value> getDependencies() {
            return this.dependencies;
        }
    }
}

