/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLCompilationResult
extends CompilationResult {
    private Set<ResolvedJavaMethod> nonInlinedMethods;
    private TaskDataContext meta;
    private OCLBackend backend;
    private String id;

    public OCLCompilationResult(String id, String name, TaskDataContext meta, OCLBackend backend) {
        super(name);
        this.id = id;
        this.meta = meta;
        this.backend = backend;
    }

    public Set<ResolvedJavaMethod> getNonInlinedMethods() {
        return this.nonInlinedMethods;
    }

    public void setNonInlinedMethods(Set<ResolvedJavaMethod> value) {
        this.nonInlinedMethods = value;
    }

    public void addCompiledMethodCode(byte[] code) {
        byte[] oldCode = this.getTargetCode();
        int size = oldCode.length + code.length + 1;
        byte[] newCode = new byte[size];
        Arrays.fill(newCode, (byte)0);
        ByteBuffer buffer = ByteBuffer.wrap(newCode);
        buffer.put(code);
        buffer.put((byte)10);
        buffer.put(oldCode);
        this.setTargetCode(newCode, size);
    }

    public TaskDataContext getMeta() {
        return this.meta;
    }

    public OCLBackend getBackend() {
        return this.backend;
    }

    public String getId() {
        return this.id;
    }
}

