/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;

public class OCLBlockVisitor
implements ControlFlowGraph.RecursiveVisitor<HIRBlock> {
    OCLCompilationResultBuilder openclBuilder;
    OCLAssembler asm;
    Set<HIRBlock> merges;
    Map<HIRBlock, Integer> closedLoops;
    Map<HIRBlock, Boolean> openBlocks;
    Map<HIRBlock, Boolean> closedBlocks;
    Set<HIRBlock> switches;
    Set<Node> switchClosed;
    HashMap<HIRBlock, Integer> pending;
    Set<HIRBlock> rmvEndBracket;
    private int loopCount;
    private int loopEnds;

    public OCLBlockVisitor(OCLCompilationResultBuilder resBuilder) {
        this.openclBuilder = resBuilder;
        this.asm = resBuilder.getAssembler();
        this.merges = new HashSet<HIRBlock>();
        this.switches = new HashSet<HIRBlock>();
        this.switchClosed = new HashSet<Node>();
        this.closedLoops = new HashMap<HIRBlock, Integer>();
        this.openBlocks = new HashMap<HIRBlock, Boolean>();
        this.closedBlocks = new HashMap<HIRBlock, Boolean>();
        this.pending = new HashMap();
        this.rmvEndBracket = new HashSet<HIRBlock>();
    }

    private static boolean isMergeBlock(HIRBlock block) {
        return block.getBeginNode() instanceof MergeNode;
    }

    private static boolean isIfBlock(HIRBlock block) {
        return block.getEndNode() instanceof IfNode;
    }

    private static boolean isSwitchBlock(HIRBlock block) {
        return block.getEndNode() instanceof IntegerSwitchNode;
    }

    private void emitBeginBlockForElseStatement(HIRBlock dom, HIRBlock block) {
        IfNode ifNode = (IfNode)dom.getEndNode();
        if (ifNode.falseSuccessor() == block.getBeginNode()) {
            this.asm.indent();
            this.asm.elseStmt();
            this.asm.eol();
        }
        this.asm.beginScope();
        this.asm.eolOn();
    }

    private void updateListEndBracketsForLoopExitNodes(HIRBlock block) {
        HIRBlock dom = (HIRBlock)block.getDominator();
        if (dom != null) {
            if (dom.getPredecessorCount() == 2) {
                boolean mergeA = false;
                boolean mergeB = false;
                HIRBlock[] predecessors = new HIRBlock[dom.getPredecessorCount()];
                for (int i = 0; i < dom.getPredecessorCount(); ++i) {
                    predecessors[i] = (HIRBlock)dom.getPredecessorAt(i);
                }
                for (HIRBlock p : predecessors) {
                    if (p.getBeginNode() instanceof LoopExitNode && p.getEndNode() instanceof LoopEndNode && block.getBeginNode() instanceof LoopExitNode) {
                        mergeA = true;
                    }
                    if (p.getBeginNode() instanceof BeginNode && p.getEndNode() instanceof EndNode && block.getEndNode() instanceof EndNode) {
                        mergeB = true;
                    }
                    if (!mergeA || !mergeB || !((IfNode)dom.getEndNode()).falseSuccessor().equals(block.getBeginNode()) || !((IfNode)dom.getEndNode()).falseSuccessor().next().equals(block.getEndNode()) || !(block.getBeginNode() instanceof LoopExitNode)) continue;
                    this.rmvEndBracket.add(block);
                }
            } else if (this.merges.contains(block) && !this.wasBlockAlreadyClosed(dom)) {
                this.rmvEndBracket.add(block);
            }
        }
    }

    private void emitBeginBlockForSwitchStatements(HIRBlock dom, HIRBlock beginBlockNode) {
        IntegerSwitchNode switchNode = (IntegerSwitchNode)dom.getEndNode();
        this.asm.indent();
        AbstractBeginNode beginNode = beginBlockNode.getBeginNode();
        this.switches.add(beginBlockNode);
        NodeIterable successors = switchNode.successors();
        int defaultSuccessorIndex = switchNode.defaultSuccessorIndex();
        Iterator iterator = successors.iterator();
        int caseIndex = -1;
        while (iterator.hasNext()) {
            Node n = (Node)iterator.next();
            ++caseIndex;
            if (!n.equals(beginNode)) continue;
            break;
        }
        ArrayList<Integer> commonCases = new ArrayList<Integer>();
        for (int i = 0; i <= defaultSuccessorIndex; ++i) {
            if (caseIndex != switchNode.keySuccessorIndex(i)) continue;
            commonCases.add(i);
        }
        if (defaultSuccessorIndex == caseIndex) {
            this.asm.emit("default:");
        } else {
            for (Integer idx : commonCases) {
                this.asm.emit("case ");
                JavaConstant keyAt = switchNode.keyAt(idx.intValue());
                this.asm.emit(keyAt.toValueString());
                this.asm.emit(":");
                this.asm.emitLine("");
                this.asm.indent();
            }
        }
    }

    public HIRBlock enter(HIRBlock block) {
        this.markBlockOpen(block);
        boolean isMerge = block.getBeginNode() instanceof MergeNode;
        if (isMerge) {
            this.asm.eolOn();
            this.merges.add(block);
        }
        if (block.isLoopHeader()) {
            ++this.loopCount;
            this.openclBuilder.emitLoopBlock(block);
        } else {
            HIRBlock dom = (HIRBlock)block.getDominator();
            if (dom != null && !isMerge && !dom.isLoopHeader() && OCLBlockVisitor.isIfBlock(dom)) {
                this.emitBeginBlockForElseStatement(dom, block);
            } else if (dom != null && !isMerge && !dom.isLoopHeader() && OCLBlockVisitor.isSwitchBlock(dom)) {
                this.emitBeginBlockForSwitchStatements(dom, block);
            }
            this.openclBuilder.emitBlock(block);
        }
        return null;
    }

    private boolean isLoopExitNode(HIRBlock block) {
        return block.getBeginNode() instanceof LoopExitNode && block.getEndNode() instanceof EndNode;
    }

    private void closeBlock(HIRBlock block) {
        if (this.openBlocks.getOrDefault(block, false).booleanValue() && !this.wasBlockAlreadyClosed(block)) {
            this.asm.endScope(block.toString());
            this.markBlockClosed(block);
        }
    }

    private void checkClosingBlockInsideIf(HIRBlock block, HIRBlock pdom) {
        if (pdom.isLoopHeader() && block.getDominator() != null && OCLBlockVisitor.isIfBlock((HIRBlock)block.getDominator())) {
            if (((HIRBlock)block.getDominator()).getDominator() != null && OCLBlockVisitor.isIfBlock((HIRBlock)((HIRBlock)block.getDominator()).getDominator()) || !(((HIRBlock)block.getDominator()).getBeginNode() instanceof LoopBeginNode)) {
                int index;
                HIRBlock[] successors = (HIRBlock[])IntStream.range(0, ((HIRBlock)block.getDominator()).getSuccessorCount()).mapToObj(i -> (HIRBlock)((HIRBlock)block.getDominator()).getSuccessorAt(i)).toArray(HIRBlock[]::new);
                if (successors[index = 0] == block) {
                    index = 1;
                }
                if (successors[index] != block && block.getBeginNode() instanceof MergeNode) {
                    return;
                }
                if (!(successors[index].getBeginNode() instanceof LoopExitNode)) {
                    this.closeBlock(block);
                }
            }
        } else if (pdom.getBeginNode() instanceof MergeNode && block.getDominator() != null && OCLBlockVisitor.isIfBlock((HIRBlock)block.getDominator())) {
            IfNode ifNode;
            HIRBlock dom2 = block.getDominator(2);
            if (dom2 != null && OCLBlockVisitor.isIfBlock(dom2)) {
                HIRBlock[] successors = (HIRBlock[])IntStream.range(0, ((HIRBlock)block.getDominator()).getSuccessorCount()).mapToObj(i -> (HIRBlock)((HIRBlock)block.getDominator()).getSuccessorAt(i)).toArray(HIRBlock[]::new);
                for (int index = 0; index < successors.length; ++index) {
                    this.closeBlock(successors[index]);
                }
            } else if (OCLBlockVisitor.isIfBlock((HIRBlock)block.getDominator()) && (ifNode = (IfNode)((HIRBlock)block.getDominator()).getEndNode()).trueSuccessor().equals(block.getBeginNode()) && this.isLoopExitNode(block)) {
                this.closeBlock(block);
            }
        }
    }

    private void closeSwitchStatement(HIRBlock block) {
        this.asm.emitLine("break;");
        IntegerSwitchNode switchNode = (IntegerSwitchNode)((HIRBlock)block.getDominator()).getEndNode();
        int blockNumber = this.getBlockIndexForSwitchStatement(block, switchNode);
        int numCases = this.getNumberOfCasesForSwitch(switchNode);
        if (numCases - 1 == blockNumber) {
            this.closeBlock(block);
            this.switchClosed.add((Node)switchNode);
        }
    }

    private boolean wasLoopBlockAlreadyClosed(HIRBlock block) {
        HIRBlock dominator = (HIRBlock)block.getDominator();
        if (dominator.getLoop() != null) {
            int closeCount = this.closedLoops.getOrDefault(dominator.getLoop().getHeader(), 0);
            return closeCount == dominator.getLoop().getLoopExits().size();
        }
        return false;
    }

    private boolean wasBlockAlreadyClosed(HIRBlock block) {
        if (block != null) {
            return this.closedBlocks.getOrDefault(block, false);
        }
        return false;
    }

    private void markBlockOpen(HIRBlock block) {
        this.openBlocks.put(block, true);
    }

    private void markBlockClosed(HIRBlock block) {
        this.closedBlocks.put(block, true);
    }

    private void incrementClosedLoops(HIRBlock loopBeginBlock) {
        int closedLoopCount = this.closedLoops.getOrDefault(loopBeginBlock, 0);
        this.closedLoops.put(loopBeginBlock, closedLoopCount + 1);
    }

    private void closeScope(HIRBlock block, HIRBlock loopBeginBlock) {
        if (block.getBeginNode() instanceof LoopExitNode) {
            if (((HIRBlock)block.getDominator()).getDominator() == null || !(((HIRBlock)((HIRBlock)block.getDominator()).getDominator()).getBeginNode() instanceof MergeNode)) {
                this.closeBlock(block);
                this.incrementClosedLoops(loopBeginBlock);
            } else {
                LoopExitNode loopExitNode;
                LoopBeginNode loopBeginNode = (LoopBeginNode)loopBeginBlock.getBeginNode();
                if (loopBeginNode.loopExits().count() == 1 && (loopExitNode = (LoopExitNode)loopBeginNode.loopExits().first()).next() instanceof IfNode) {
                    this.closeBlock(block);
                    this.incrementClosedLoops(loopBeginBlock);
                }
            }
        } else {
            this.closeBlock(block);
            this.incrementClosedLoops(loopBeginBlock);
        }
    }

    private boolean isComplexLoopCondition(HIRBlock block) {
        LoopExitNode exitNode;
        Loop loop = block.getLoop();
        LoopExitNode loopExitNode = exitNode = block.getBeginNode() instanceof LoopExitNode ? (LoopExitNode)block.getBeginNode() : null;
        if (loop != null || exitNode != null) {
            StructuredGraph graph = block.getBeginNode().graph();
            HIRBlock loopHeaderBlock = exitNode != null ? (HIRBlock)graph.getLastSchedule().getNodeToBlockMap().get((Node)exitNode.loopBegin()) : (HIRBlock)loop.getHeader();
            for (int i = 0; i < loopHeaderBlock.getSuccessorCount(); ++i) {
                if (!(((HIRBlock)loopHeaderBlock.getSuccessorAt(i)).getEndNode() instanceof IfNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBlockInABreak(HIRBlock block) {
        if (block.getBeginNode() instanceof LoopExitNode) {
            LoopExitNode loopExitNode = (LoopExitNode)block.getBeginNode();
            LoopBeginNode loopBeginNode = loopExitNode.loopBegin();
            HIRBlock loopBeginBlock = (HIRBlock)loopBeginNode.graph().getLastSchedule().getNodeToBlockMap().get((Node)loopBeginNode);
            for (int i = 0; i < block.getPredecessorCount(); ++i) {
                if (block.getPredecessorAt(i) != loopBeginBlock) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void exit(HIRBlock block, HIRBlock value) {
        if (block.isLoopEnd()) {
            LoopEndNode loopEndNode = (LoopEndNode)block.getEndNode();
            LoopBeginNode loopBeginNode = loopEndNode.loopBegin();
            HIRBlock loopBeginBlock = (HIRBlock)loopBeginNode.graph().getLastSchedule().getNodeToBlockMap().get((Node)loopBeginNode);
            if (this.openclBuilder.shouldRemoveLoop()) {
                ++this.loopEnds;
                this.incrementClosedLoops(loopBeginBlock);
                if (this.loopCount - this.loopEnds > 0) {
                    this.closeBlock(block);
                }
            } else {
                this.closeScope(block, loopBeginBlock);
            }
        }
        if (block.getPostdominator() != null) {
            HIRBlock pdom = block.getPostdominator();
            this.updateListEndBracketsForLoopExitNodes(block);
            if (!this.merges.contains(pdom) && OCLBlockVisitor.isMergeBlock(pdom) && !this.switches.contains(block)) {
                if (!(pdom.getBeginNode() instanceof MergeNode && this.merges.contains(block) && block.getPredecessorCount() > 2 || this.wasLoopBlockAlreadyClosed(block) || !this.isComplexLoopCondition(block) && this.isBlockInABreak(block) || this.rmvEndBracket.contains(block))) {
                    this.closeBlock(block);
                }
            } else if (!this.merges.contains(pdom) && OCLBlockVisitor.isMergeBlock(pdom) && this.switches.contains(block) && OCLBlockVisitor.isSwitchBlock((HIRBlock)block.getDominator())) {
                this.closeSwitchStatement(block);
            } else {
                this.checkClosingBlockInsideIf(block, pdom);
            }
        } else if (block.getBeginNode() instanceof LoopExitNode && block.getBeginNode().successors().filter(ReturnNode.class).isNotEmpty() && !this.wasLoopBlockAlreadyClosed(block)) {
            this.closeBlock(block);
        } else {
            this.closeBranchBlock(block);
        }
        this.openclBuilder.emitRelocatedInstructions(block);
    }

    private void closeIfBlock(HIRBlock block, HIRBlock dom) {
        IfNode ifNode = (IfNode)dom.getEndNode();
        if (ifNode.falseSuccessor() == block.getBeginNode() || ifNode.trueSuccessor() == block.getBeginNode()) {
            boolean isTrueBranch;
            boolean isLoopEnd = block.getEndNode() instanceof LoopEndNode;
            boolean bl = isTrueBranch = ifNode.trueSuccessor() == block.getBeginNode();
            if (!isTrueBranch || !isLoopEnd) {
                this.closeBlock(block);
                if (block.getLoop() != null) {
                    this.incrementClosedLoops((HIRBlock)block.getLoop().getHeader());
                }
            }
        }
    }

    private int getBlockIndexForSwitchStatement(HIRBlock block, IntegerSwitchNode switchNode) {
        Node n;
        AbstractBeginNode beginNode = block.getBeginNode();
        NodeIterable successors = switchNode.successors();
        Iterator iterator = successors.iterator();
        int blockIndex = 0;
        while (iterator.hasNext() && !(n = (Node)iterator.next()).equals(beginNode)) {
            ++blockIndex;
        }
        return blockIndex;
    }

    private int getNumberOfCasesForSwitch(IntegerSwitchNode switchNode) {
        return switchNode.successors().count();
    }

    private void closeSwitchBlock(HIRBlock block, HIRBlock dom) {
        IntegerSwitchNode switchNode = (IntegerSwitchNode)dom.getEndNode();
        int blockNumber = this.getBlockIndexForSwitchStatement(block, switchNode);
        int numCases = this.getNumberOfCasesForSwitch(switchNode);
        if (numCases - 1 == blockNumber && !this.switchClosed.contains(switchNode)) {
            this.closeBlock(block);
            this.switchClosed.add((Node)switchNode);
        }
    }

    private boolean isNestedIfNode(HIRBlock block) {
        boolean isMerge;
        HIRBlock dominator = (HIRBlock)block.getDominator();
        boolean sameDominator = isMerge = block.getBeginNode() instanceof MergeNode;
        if (isMerge) {
            MergeNode mergeNode = (MergeNode)block.getBeginNode();
            NodeMap nodeToBlockMap = mergeNode.graph().getLastSchedule().getNodeToBlockMap();
            for (EndNode predecessor : mergeNode.cfgPredecessors()) {
                if (((HIRBlock)nodeToBlockMap.get((Node)predecessor)).getDominator() == dominator) continue;
                sameDominator = false;
                break;
            }
        }
        boolean isReturn = block.getEndNode() instanceof ReturnNode;
        boolean pendingBlocks = !this.getEarliestPostDominated(block).equals(block.getDominator());
        return dominator != null && isMerge && pendingBlocks && sameDominator && isReturn && !dominator.isLoopHeader() && OCLBlockVisitor.isIfBlock(dominator);
    }

    public HIRBlock getEarliestPostDominated(HIRBlock block) {
        HIRBlock dom;
        while ((dom = (HIRBlock)block.getDominator()) != null && dom.getPostdominator() == block) {
            block = dom;
        }
        return block;
    }

    private boolean isIfBlockNode(HIRBlock block) {
        HIRBlock dom = (HIRBlock)block.getDominator();
        boolean isMerge = block.getBeginNode() instanceof MergeNode;
        return dom != null && !isMerge && !dom.isLoopHeader() && OCLBlockVisitor.isIfBlock(dom);
    }

    private boolean isSwitchBlockNode(HIRBlock block) {
        HIRBlock dom = (HIRBlock)block.getDominator();
        boolean isMerge = block.getBeginNode() instanceof MergeNode;
        return dom != null && !isMerge && !dom.isLoopHeader() && OCLBlockVisitor.isSwitchBlock(dom);
    }

    private boolean isStartNode(HIRBlock block) {
        return ((HIRBlock)block.getDominator()).getBeginNode() instanceof StartNode;
    }

    private boolean isReturnBranchWithMerge(HIRBlock dom, HIRBlock block) {
        return dom != null && dom.getDominator() != null && ((HIRBlock)dom.getDominator()).getBeginNode() instanceof MergeNode && dom.getBeginNode() instanceof LoopBeginNode && dom.getEndNode() instanceof IfNode && block.getBeginNode() instanceof LoopExitNode && block.getEndNode() instanceof ReturnNode && (!(dom.getFirstSuccessor().getEndNode() instanceof LoopEndNode) || !(dom.getFirstSuccessor().getBeginNode() instanceof BeginNode));
    }

    private void closeBranchBlock(HIRBlock block) {
        HIRBlock dom = (HIRBlock)block.getDominator();
        if (dom != null && this.wasLoopBlockAlreadyClosed(block) || block.isLoopEnd() && !(block.getBeginNode() instanceof LoopExitNode)) {
            return;
        }
        if (this.isIfBlockNode(block)) {
            this.closeIfBlock(block, dom);
        } else if (this.isSwitchBlockNode(block)) {
            this.closeSwitchBlock(block, dom);
        } else if (this.isNestedIfNode(block) && !this.isStartNode(block) && !OCLBlockVisitor.isMergeBlock(block)) {
            this.closeBlock(block);
        } else if (this.isReturnBranchWithMerge(dom, block)) {
            this.closeBlock(block);
        }
    }
}

