/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.backend;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.common.code.CodeUtil;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.common.utils.BackendDeopt;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLCodeProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLFrameContext;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLFrameMap;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLFrameMapBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLSuitesProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLUtils;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLDataBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLNodeLIRBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLNodeMatchRules;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLReferenceMapBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FPGAWorkGroupSizeNode;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.OCLTokens;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.graal.backend.XPUBackend;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLBackend
extends XPUBackend<OCLProviders>
implements FrameMap.ReferenceMapBuilderFactory {
    final OptionValues options;
    final OCLTargetDescription target;
    final OCLArchitecture architecture;
    final OCLDeviceContextInterface deviceContext;
    final OCLCodeProvider codeCache;
    private boolean backEndInitialized;

    public OCLBackend(OptionValues options, Providers providers, OCLTargetDescription target, OCLCodeProvider codeCache, OCLDeviceContextInterface deviceContext) {
        super(providers);
        this.options = options;
        this.target = target;
        this.codeCache = codeCache;
        this.deviceContext = deviceContext;
        this.architecture = (OCLArchitecture)target.arch;
    }

    public static boolean isDeviceAnFPGAAccelerator(OCLDeviceContextInterface deviceContext) {
        return deviceContext.isPlatformFPGA();
    }

    public String decodeDeopt(long value) {
        return BackendDeopt.decodeDeopt((long)value, (Providers)this.getProviders());
    }

    public boolean isInitialised() {
        return this.backEndInitialized;
    }

    public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
        return new OCLReferenceMapBuilder();
    }

    public void allocateTornadoVMBuffersOnDevice() {
        this.deviceContext.getMemoryManager().allocateDeviceMemoryRegions();
    }

    public int[] getDriverAndDevice() {
        int numDev = ((OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class)).getNumDevices();
        int deviceIndex = 0;
        for (int i = 0; i < numDev; ++i) {
            TornadoXPUDevice device = ((OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class)).getDevice(i);
            OCLTargetDevice dev = (OCLTargetDevice)device.getPhysicalDevice();
            if (dev != this.deviceContext.getDevice()) continue;
            deviceIndex = i;
        }
        int driverIndex = TornadoCoreRuntime.getTornadoRuntime().getBackendIndex(OCLBackendImpl.class);
        return new int[]{driverIndex, deviceIndex};
    }

    public void init() {
        if (TornadoOptions.VIRTUAL_DEVICE_ENABLED) {
            this.backEndInitialized = true;
            return;
        }
        this.allocateTornadoVMBuffersOnDevice();
        this.backEndInitialized = true;
    }

    public int getMethodIndex() {
        return 0;
    }

    public OCLDeviceContextInterface getDeviceContext() {
        return this.deviceContext;
    }

    protected OCLAssembler createAssembler() {
        return new OCLAssembler(this.target);
    }

    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod method, TornadoProfiler profiler) {
        this.emitCode((OCLCompilationResultBuilder)crb, lir, method, profiler);
    }

    public void emitCode(OCLCompilationResultBuilder crb, LIR lir, ResolvedJavaMethod method, TornadoProfiler profiler) {
        TaskDataContext taskMetaData = crb.getTaskMetaData();
        profiler.start(ProfilerType.TASK_CODE_GENERATION_TIME, taskMetaData.getId());
        OCLAssembler asm = (OCLAssembler)crb.asm;
        this.emitPrologue(crb, asm, method, lir);
        crb.emit(lir);
        this.emitEpilogue(asm);
        profiler.stop(ProfilerType.TASK_CODE_GENERATION_TIME, taskMetaData.getId());
        profiler.sum(ProfilerType.TOTAL_CODE_GENERATION_TIME, profiler.getTaskTimer(ProfilerType.TASK_CODE_GENERATION_TIME, taskMetaData.getId()));
    }

    private void emitEpilogue(OCLAssembler asm) {
        asm.endScope(" kernel");
    }

    private void addVariableDef(Map<OCLKind, Set<Variable>> kindToVariable, Variable value) {
        if (value != null) {
            OCLKind oclKind;
            if (!(value.getPlatformKind() instanceof OCLKind)) {
                TornadoInternalError.shouldNotReachHere();
            }
            if ((oclKind = (OCLKind)value.getPlatformKind()) == OCLKind.ILLEGAL) {
                TornadoInternalError.shouldNotReachHere();
            }
            if (!kindToVariable.containsKey((Object)oclKind)) {
                kindToVariable.put(oclKind, new HashSet());
            }
            Set<Variable> varList = kindToVariable.get((Object)oclKind);
            varList.add(value);
        }
    }

    private void emitVariableDefs(OCLCompilationResultBuilder crb, OCLAssembler asm, LIR lir) {
        HashMap kindToVariable = new HashMap();
        int expectedVariables = lir.numVariables();
        AtomicInteger variableCount = new AtomicInteger();
        for (int b : lir.linearScanOrder()) {
            for (LIRInstruction lirInstruction : lir.getLIRforBlock(lir.getBlockById(b))) {
                lirInstruction.forEachOutput((instruction, value, mode, flags) -> {
                    Variable variable;
                    if (value instanceof Variable && (variable = (Variable)value).toString() != null) {
                        this.addVariableDef(kindToVariable, variable);
                        variableCount.incrementAndGet();
                    }
                    return value;
                });
            }
        }
        Logger.traceCodeGen((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"found %d variable, expected (%d)", (Object[])new Object[]{variableCount.get(), expectedVariables});
        Object object = kindToVariable.keySet().iterator();
        while (object.hasNext()) {
            OCLKind type = (OCLKind)((Object)object.next());
            asm.indent();
            asm.emit("%s ", new Object[]{type});
            for (Variable var : (Set)kindToVariable.get((Object)type)) {
                asm.emitValue(crb, (Value)var);
                asm.emit(", ");
            }
            asm.emitByte(59, asm.position() - 2);
            asm.eol();
        }
    }

    private void emitDebugKernelArgs(OCLAssembler asm, ResolvedJavaMethod method) {
        asm.emitLine("if(get_global_id(0) == 0 && get_global_id(1) ==0){");
        asm.pushIndent();
        asm.emitStmt("int numArgs = slots[5] >> 32", new Object[0]);
        asm.emitStmt("printf(\"got %%d args...\\n\",numArgs)", new Object[0]);
        asm.emitLine("for(int i=0;i<numArgs;i++) {");
        asm.pushIndent();
        asm.emitStmt("printf(\"%20s - arg[%%d]: 0x%%lx\\n\", i, slots[6 + i])", method.getName());
        asm.popIndent();
        asm.emitLine("}");
        asm.popIndent();
        asm.emitLine("}");
    }

    private void emitPrologue(OCLCompilationResultBuilder crb, OCLAssembler asm, ResolvedJavaMethod method, LIR lir) {
        String methodName = crb.compilationResult.getName();
        CallingConvention incomingArguments = CodeUtil.getCallingConvention((CodeCacheProvider)this.codeCache, (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, (ResolvedJavaMethod)method);
        if (crb.isKernel()) {
            ControlFlowGraph cfg = (ControlFlowGraph)lir.getControlFlowGraph();
            if (cfg.getStartBlock().getEndNode().predecessor() instanceof FPGAWorkGroupSizeNode) {
                FPGAWorkGroupSizeNode fpgaNode = (FPGAWorkGroupSizeNode)cfg.getStartBlock().getEndNode().predecessor();
                String attribute = fpgaNode.createThreadAttribute();
                asm.emitSymbol(attribute);
                asm.emitLine("");
            }
            asm.emit("%s void %s(%s", "__kernel", methodName, this.architecture.getABI());
            this.emitMethodParameters(asm, method, incomingArguments, true);
            asm.emitLine(")");
            asm.beginScope();
            this.emitVariableDefs(crb, asm, lir);
            if (TornadoOptions.DEBUG_KERNEL_ARGS && !method.getDeclaringClass().getUnqualifiedName().equalsIgnoreCase(((Object)((Object)this)).getClass().getSimpleName())) {
                this.emitDebugKernelArgs(asm, method);
            }
            if (TornadoOptions.ENABLE_EXCEPTIONS) {
                asm.emitStmt("if(slots[0] != 0) return", new Object[0]);
            }
            asm.eol();
        } else {
            String returnStr;
            methodName = OCLUtils.makeMethodName(method);
            JavaKind returnKind = method.getSignature().getReturnKind();
            if (returnKind == JavaKind.Void) {
                returnStr = "void";
            } else {
                ResolvedJavaType returnType = method.getSignature().getReturnType(null).resolve(method.getDeclaringClass());
                OCLKind returnOclKind = returnType.getAnnotation(Vector.class) == null ? ((OCLTargetDescription)this.getTarget()).getOCLKind(returnKind) : OCLKind.fromResolvedJavaType(returnType);
                returnStr = returnOclKind.toString();
            }
            asm.emit("%s %s(%s", returnStr, methodName, this.architecture.getABI());
            this.emitMethodParameters(asm, method, incomingArguments, false);
            asm.emit(")");
            asm.eol();
            asm.beginScope();
            this.emitVariableDefs(crb, asm, lir);
            asm.eol();
        }
    }

    private String getParameterName(Local local) {
        Object parameterName = local.getName();
        if (OCLTokens.openCLTokens.contains(parameterName)) {
            parameterName = "_" + (String)parameterName;
        }
        return parameterName;
    }

    private void emitMethodParameters(OCLAssembler asm, ResolvedJavaMethod method, CallingConvention incomingArguments, boolean isKernel) {
        Local[] locals = method.getLocalVariableTable().getLocalsAt(0);
        for (int i = 0; i < incomingArguments.getArgumentCount(); ++i) {
            OCLKind tmpKind;
            AllocatableValue param;
            JavaType javaType = locals[i].getType();
            JavaKind javaKind = CodeUtil.convertJavaKind((JavaType)javaType);
            if (isKernel) {
                if (javaKind.isPrimitive() || CodeUtil.isHalfFloat((JavaType)javaType)) {
                    param = incomingArguments.getArgument(i);
                    OCLKind kind = (OCLKind)param.getPlatformKind();
                    asm.emit(", ");
                    asm.emit("__private %s %s", kind.toString(), locals[i].getName());
                    continue;
                }
                if (javaType.toJavaName().equals(KernelContext.class.getName()) || javaType.toJavaName().equals(AtomicInteger.class.getName())) continue;
                asm.emit(", ");
                String parameterName = this.getParameterName(locals[i]);
                asm.emit("__global %s *%s", "uchar", parameterName);
                continue;
            }
            param = incomingArguments.getArgument(i);
            OCLKind oclKind = (OCLKind)param.getPlatformKind();
            if (javaKind.isObject() && (tmpKind = OCLKind.resolveToVectorKind(javaType.resolve(method.getDeclaringClass()))) != OCLKind.ILLEGAL) {
                oclKind = tmpKind;
            }
            TornadoInternalError.guarantee((oclKind != OCLKind.ILLEGAL ? 1 : 0) != 0, (String)"illegal type for %s", (Object[])new Object[]{param.getPlatformKind()});
            asm.emit(", ");
            asm.emit("%s %s", oclKind.toString(), locals[i].getName());
        }
    }

    public OCLSuitesProvider getTornadoSuites() {
        return ((OCLProviders)this.getProviders()).getSuitesProvider();
    }

    public OCLCompilationResultBuilder newCompilationResultBuilder(FrameMap frameMap, OCLCompilationResult compilationResult, boolean isKernel, boolean isParallel, LIR lir) {
        OCLAssembler asm = this.createAssembler();
        OCLFrameContext frameContext = new OCLFrameContext();
        OCLDataBuilder dataBuilder = new OCLDataBuilder();
        OCLCompilationResultBuilder crb = new OCLCompilationResultBuilder((CodeGenProviders)this.getProviders(), frameMap, asm, dataBuilder, frameContext, this.options, TornadoCoreRuntime.getDebugContext(), compilationResult, lir);
        crb.setKernel(isKernel);
        crb.setParallel(isParallel);
        crb.setDeviceContext(this.deviceContext);
        return crb;
    }

    private FrameMap newFrameMap(RegisterConfig registerConfig) {
        return new OCLFrameMap(this.getCodeCache(), registerConfig, this);
    }

    public FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new OCLFrameMapBuilder(this.newFrameMap(registerConfigNonNull), this.getCodeCache(), registerConfig);
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier identifier, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig) {
        return new OCLLIRGenerationResult(identifier, lir, frameMapBuilder, registerAllocationConfig, new CallingConvention(0, null, (AllocatableValue[])null));
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenResult) {
        return new OCLLIRGenerator((CodeGenProviders)this.getProviders(), lirGenResult);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new OCLNodeLIRBuilder(graph, lirGen, new OCLNodeMatchRules(lirGen));
    }

    public String toString() {
        return String.format("Backend: arch=%s, device=%s", this.architecture.getName(), this.deviceContext.getDevice().getDeviceName());
    }

    public OCLCodeProvider getCodeCache() {
        return this.codeCache;
    }

    public SuitesProvider getSuites() {
        TornadoInternalError.unimplemented((String)"Get suites method in OCLBackend not implemented yet.");
        return null;
    }

    public void reset(long executionPlanId) {
        this.getDeviceContext().reset(executionPlanId);
    }

    protected CompiledCode createCompiledCode(ResolvedJavaMethod rjm, CompilationRequest cr, CompilationResult cr1, boolean isDefault, OptionValues options) {
        TornadoInternalError.unimplemented((String)"Create compiled code method in OCLBackend not implemented yet.");
        return null;
    }
}

