/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLVariablePrefix;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResultBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIROp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLNullary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLReturnSlot;

public final class OCLAssembler
extends Assembler {
    private static final boolean EMIT_INTRINSICS = false;
    private int indent = 0;
    private int lastIndent;
    private String delimiter = ";";
    private boolean emitEOL = true;
    private List<String> operandStack = new ArrayList<String>(10);
    private boolean pushToStack = false;

    public OCLAssembler(TargetDescription target) {
        super(target, null);
        if (((OCLTargetDescription)target).supportsFP64()) {
            this.emitLine("#pragma OPENCL EXTENSION cl_khr_fp64 : enable  ");
        }
        this.emitLine("#pragma OPENCL EXTENSION cl_khr_fp16 : enable  ");
        if (((OCLTargetDescription)target).supportsInt64Atomics()) {
            this.emitLine("#pragma OPENCL EXTENSION cl_khr_int64_base_atomics : enable  ");
        }
    }

    public static String convertValueFromGraalFormat(Value input) {
        String type = input.getPlatformKind().name().toLowerCase();
        String indexValue = OCLAssembler.getAbsoluteIndexFromValue(input);
        OCLVariablePrefix typePrefix = Arrays.stream(OCLVariablePrefix.values()).filter(tp -> tp.getType().equals(type)).findFirst().orElse(null);
        if (typePrefix == null) {
            throw new TornadoRuntimeException("Unsupported type: " + type);
        }
        String result = typePrefix.getPrefix() + indexValue;
        return result;
    }

    public static String getAbsoluteIndexFromValue(Value value) {
        int startIndex = value.toString().indexOf(91) + 1;
        int endIndex = value.toString().indexOf(124);
        return value.toString().substring(startIndex, endIndex).trim().replace("v", "");
    }

    private void emitAtomicIntrinsics() {
        this.emitLine("inline void atomicAdd_Tornado_Floats(volatile __global float *source, const float operand) {\n   union {\n       unsigned int intVal;\n       float floatVal;\n   } newVal;\n   union {\n       unsigned int intVal;\n       float floatVal;\n   } prevVal;\n   barrier(CLK_GLOBAL_MEM_FENCE);\n   do {\n       prevVal.floatVal = *source;\n       newVal.floatVal = prevVal.floatVal + operand;\n   } while (atomic_cmpxchg((volatile __global unsigned int *)source, prevVal.intVal,\n   newVal.intVal) != prevVal.intVal);}");
        this.emitLine("inline void atomicAdd_Tornado_Floats2(volatile __global float *addr, float val)\n{\n    union {\n        unsigned int u32;\n        float f32;\n    } next, expected, current;\n    current.f32 = *addr;\nbarrier(CLK_GLOBAL_MEM_FENCE);\n    do {\n       expected.f32 = current.f32;\n       next.f32 = expected.f32 + val;\n       current.u32 = atomic_cmpxchg( (volatile __global unsigned int *)addr,\n       expected.u32, next.u32);\n    } while( current.u32 != expected.u32 );\n}");
        this.emitLine("inline void atomicMul_Tornado_Int(volatile __global int *source, const float operand) {\n   union {\n       unsigned int intVal;\n       int value;\n   } newVal;\n   union {\n       unsigned int intVal;\n       int value;\n   } prevVal;\n   barrier(CLK_GLOBAL_MEM_FENCE);\n   do {\n       prevVal.value = *source;\n       newVal.value = prevVal.value * operand;\n   } while (atomic_cmpxchg((volatile __global unsigned int *)source, prevVal.intVal,\n   newVal.intVal) != prevVal.intVal);}");
    }

    public void align(int arg0) {
    }

    public void halt() {
    }

    public void ensureUniquePC() {
    }

    public AbstractAddress getPlaceholder(int i) {
        TornadoInternalError.unimplemented((String)"Place holder not implemented yet.");
        return null;
    }

    public void jmp(Label arg0) {
    }

    protected void patchJumpTarget(int arg0, int arg1) {
        TornadoInternalError.unimplemented((String)"Patch jump target not implemented yet.");
    }

    public AbstractAddress makeAddress(int transferSize, Register base, int displacement) {
        TornadoInternalError.unimplemented((String)"Make address not implemented yet.");
        return null;
    }

    public void emitStmt(String fmt, Object ... args) {
        this.indent();
        this.emit("%s", String.format(fmt, args));
        this.delimiter();
        this.eol();
    }

    public void emitString(String fmt, Object ... args) {
        this.indent();
        this.emitString(String.format(fmt, args));
    }

    public void emitSubString(String str) {
        TornadoInternalError.guarantee((str != null ? 1 : 0) != 0, (String)"emitting null string", (Object[])new Object[0]);
        if (this.pushToStack) {
            this.operandStack.add(str);
        } else {
            for (byte b : str.getBytes()) {
                this.emitByte(b);
            }
        }
    }

    public List<String> getOperandStack() {
        return this.operandStack;
    }

    public void beginStackPush() {
        this.pushToStack = true;
    }

    public void endStackPush() {
        this.pushToStack = false;
    }

    public String getLastOp() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.operandStack) {
            sb.append(str);
        }
        this.operandStack.clear();
        return sb.toString();
    }

    public void pushIndent() {
        assert (this.indent >= 0);
        ++this.indent;
    }

    public void popIndent() {
        assert (this.indent > 0);
        --this.indent;
    }

    public void indentOff() {
        this.lastIndent = this.indent;
        this.indent = 0;
    }

    public void indentOn() {
        this.indent = this.lastIndent;
    }

    public void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.emitSymbol("  ");
        }
    }

    public void comment(String comment) {
        this.emit(" /* " + comment + " */ ");
        this.eol();
    }

    public void loopBreak() {
        this.emit("break");
    }

    public void emitSymbol(String sym) {
        for (byte b : sym.getBytes()) {
            this.emitByte(b);
        }
    }

    public void eolOff() {
        this.emitEOL = false;
    }

    public void eolOn() {
        this.emitEOL = true;
    }

    public void eol() {
        if (this.emitEOL) {
            this.emitSymbol("\n");
        } else {
            this.space();
        }
    }

    public void setDelimiter(String value) {
        this.delimiter = value;
    }

    public void delimiter() {
        this.emitSymbol(this.delimiter);
    }

    public void emitLine(String fmt, Object ... args) {
        this.emitLine(String.format(fmt, args));
    }

    public void emitLine(String str) {
        this.indent();
        this.emitSubString(str);
        this.eol();
    }

    public void emit(String str) {
        this.emitSubString(str);
    }

    public void emitLineGlobal(String str) {
        int size = this.position();
        byte[] codeCopy = this.copy(0, size);
        String s = new String(codeCopy);
        str = (String)str + s;
        this.emitString((String)str, 0);
    }

    public void emit(String fmt, Object ... args) {
        this.emitSubString(String.format(fmt, args));
    }

    public void dump() {
        for (int i = 0; i < this.position(); ++i) {
            System.out.printf("%c", Character.valueOf((char)this.getByte(i)));
        }
    }

    public void ret() {
        this.emitStmt("return", new Object[0]);
    }

    public void endScope(String blockName) {
        this.popIndent();
        this.emitLine("}  // " + blockName);
    }

    public void endScope() {
        this.popIndent();
        this.emitLine("}");
    }

    public void beginScope() {
        this.emitLine("{");
        this.pushIndent();
    }

    private String encodeString(String str) {
        return str.replace("\n", "\\n").replace("\t", "\\t").replace("\"", "");
    }

    private String addLiteralSuffix(OCLKind oclKind, String value) {
        Object result = value;
        if (oclKind == OCLKind.FLOAT) {
            result = (String)result + "F";
        } else if (oclKind.isInteger()) {
            if (oclKind.isUnsigned()) {
                result = (String)result + "U";
            }
            if (oclKind == OCLKind.LONG || oclKind == OCLKind.ULONG) {
                result = (String)result + "L";
            }
        }
        return result;
    }

    public void emitConstant(ConstantValue cv) {
        this.emit(this.formatConstant(cv));
    }

    public void emitConstant(Constant constant) {
        this.emit(constant.toValueString());
    }

    public String formatConstant(ConstantValue cv) {
        String result = "";
        JavaConstant javaConstant = cv.getJavaConstant();
        Constant constant = cv.getConstant();
        OCLKind oclKind = (OCLKind)cv.getPlatformKind();
        if (javaConstant.isNull()) {
            result = this.addLiteralSuffix(oclKind, "0");
            if (oclKind.isVector()) {
                result = String.format("(%s)(%s)", oclKind.name(), result);
            }
        } else if (constant instanceof HotSpotObjectConstant) {
            HotSpotObjectConstant objConst = (HotSpotObjectConstant)constant;
            if (objConst.getJavaKind().isObject() && objConst.getType().getName().compareToIgnoreCase("Ljava/lang/String;") == 0) {
                result = this.encodeString(objConst.toValueString());
            }
        } else {
            result = constant.toValueString();
            result = this.addLiteralSuffix(oclKind, result);
        }
        return result;
    }

    public String toString(Value value) {
        String result = "";
        if (value instanceof Variable) {
            Variable var = (Variable)value;
            return OCLAssembler.convertValueFromGraalFormat((Value)var);
        }
        if (value instanceof ConstantValue) {
            if (!((ConstantValue)value).isJavaConstant()) {
                TornadoInternalError.shouldNotReachHere((String)"constant value: ", (Object[])new Object[]{value});
            }
            ConstantValue cv = (ConstantValue)value;
            return this.formatConstant(cv);
        }
        if (value instanceof OCLNullary.Parameter) {
            return value.toString();
        }
        TornadoInternalError.unimplemented((String)"value: toString() type=%s, value=%s", (Object[])new Object[]{value.getClass().getName(), value});
        return result;
    }

    public void emitValue(OCLCompilationResultBuilder crb, Value value) {
        if (value instanceof OCLReturnSlot) {
            ((OCLReturnSlot)value).emit(crb, this);
        } else {
            this.emit(this.toString(value));
        }
    }

    public void emitValueWithFormat(OCLCompilationResultBuilder crb, Value value) {
        if (value instanceof OCLReturnSlot) {
            ((OCLReturnSlot)value).emit(crb, this);
        } else {
            this.emit(OCLAssembler.convertValueFromGraalFormat(value));
        }
    }

    public String getStringValue(OCLCompilationResultBuilder crb, Value value) {
        if (value instanceof OCLReturnSlot) {
            return ((OCLReturnSlot)value).getStringFormat();
        }
        return this.toString(value);
    }

    public void assign() {
        this.emitSymbol(" = ");
    }

    public void ifStmt(OCLCompilationResultBuilder crb, Value condition) {
        this.indent();
        this.emitSymbol("if");
        this.emitSymbol("(");
        this.emit(this.toString(condition));
        if ((OCLKind)condition.getPlatformKind() == OCLKind.INT) {
            this.emit(" == 1");
        }
        this.emitSymbol(")");
        this.eol();
    }

    public void space() {
        this.emitSymbol(" ");
    }

    public void elseIfStmt(OCLCompilationResultBuilder crb, Value condition) {
        this.indent();
        this.emitSymbol("else");
        this.space();
        this.emitSymbol("if");
        this.emitSymbol("(");
        this.emitValue(crb, condition);
        this.emitSymbol(")");
        this.eol();
    }

    public void elseStmt() {
        this.emitSymbol("else");
    }

    public void emitValueOrOp(OCLCompilationResultBuilder crb, Value value) {
        if (value instanceof OCLLIROp) {
            ((OCLLIROp)value).emit(crb, this);
        } else {
            this.emitValue(crb, value);
        }
    }

    public static class OCLOp16
    extends OCLOp8 {
        public static final OCLOp16 VMOV_SHORT16 = new OCLOp16("(short16)");
        public static final OCLOp16 VMOV_INT16 = new OCLOp16("(int16)");
        public static final OCLOp16 VMOV_FLOAT16 = new OCLOp16("(float16)");
        public static final OCLOp16 VMOV_BYTE16 = new OCLOp16("(char16)");
        public static final OCLOp16 VMOV_DOUBLE16 = new OCLOp16("(double16)");
        public static final OCLOp16 VMOV_HALF16 = new OCLOp16("(half16)");

        protected OCLOp16(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value s0, Value s1, Value s2, Value s3, Value s4, Value s5, Value s6, Value s7, Value s8, Value s9, Value s10, Value s11, Value s12, Value s13, Value s14, Value s15) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValue(crb, s0);
            asm.emit(", ");
            asm.emitValue(crb, s1);
            asm.emit(", ");
            asm.emitValue(crb, s2);
            asm.emit(", ");
            asm.emitValue(crb, s3);
            asm.emit(", ");
            asm.emitValue(crb, s4);
            asm.emit(", ");
            asm.emitValue(crb, s5);
            asm.emit(", ");
            asm.emitValue(crb, s6);
            asm.emit(", ");
            asm.emitValue(crb, s7);
            asm.emit(", ");
            asm.emitValue(crb, s8);
            asm.emit(", ");
            asm.emitValue(crb, s9);
            asm.emit(", ");
            asm.emitValue(crb, s10);
            asm.emit(", ");
            asm.emitValue(crb, s11);
            asm.emit(", ");
            asm.emitValue(crb, s12);
            asm.emit(", ");
            asm.emitValue(crb, s13);
            asm.emit(", ");
            asm.emitValue(crb, s14);
            asm.emit(", ");
            asm.emitValue(crb, s15);
            asm.emit(")");
        }
    }

    public static class OCLOp8
    extends OCLOp4 {
        public static final OCLOp8 VMOV_SHORT8 = new OCLOp8("(short8)");
        public static final OCLOp8 VMOV_INT8 = new OCLOp8("(int8)");
        public static final OCLOp8 VMOV_FLOAT8 = new OCLOp8("(float8)");
        public static final OCLOp8 VMOV_BYTE8 = new OCLOp8("(char8)");
        public static final OCLOp8 VMOV_DOUBLE8 = new OCLOp8("(double8)");
        public static final OCLOp8 VMOV_HALF8 = new OCLOp8("(half8)");

        protected OCLOp8(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value s0, Value s1, Value s2, Value s3, Value s4, Value s5, Value s6, Value s7) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValue(crb, s0);
            asm.emit(", ");
            asm.emitValue(crb, s1);
            asm.emit(", ");
            asm.emitValue(crb, s2);
            asm.emit(", ");
            asm.emitValue(crb, s3);
            asm.emit(", ");
            asm.emitValue(crb, s4);
            asm.emit(", ");
            asm.emitValue(crb, s5);
            asm.emit(", ");
            asm.emitValue(crb, s6);
            asm.emit(", ");
            asm.emitValue(crb, s7);
            asm.emit(")");
        }
    }

    public static class OCLOp4
    extends OCLOp3 {
        public static final OCLOp4 VMOV_SHORT4 = new OCLOp4("(short4)");
        public static final OCLOp4 VMOV_INT4 = new OCLOp4("(int4)");
        public static final OCLOp4 VMOV_FLOAT4 = new OCLOp4("(float4)");
        public static final OCLOp4 VMOV_BYTE4 = new OCLOp4("(char4)");
        public static final OCLOp4 VMOV_DOUBLE4 = new OCLOp4("(double4)");
        public static final OCLOp4 VMOV_HALF4 = new OCLOp4("(half4)");

        protected OCLOp4(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value s0, Value s1, Value s2, Value s3) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValue(crb, s0);
            asm.emit(", ");
            asm.emitValue(crb, s1);
            asm.emit(", ");
            asm.emitValue(crb, s2);
            asm.emit(", ");
            asm.emitValue(crb, s3);
            asm.emit(")");
        }
    }

    public static class OCLOp3
    extends OCLOp2 {
        public static final OCLOp3 VMOV_SHORT3 = new OCLOp3("(short3)");
        public static final OCLOp3 VMOV_INT3 = new OCLOp3("(int3)");
        public static final OCLOp3 VMOV_FLOAT3 = new OCLOp3("(float3)");
        public static final OCLOp3 VMOV_BYTE3 = new OCLOp3("(char3)");
        public static final OCLOp3 VMOV_DOUBLE3 = new OCLOp3("(double3)");
        public static final OCLOp3 VMOV_HALF3 = new OCLOp3("(half3)");

        public OCLOp3(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value s0, Value s1, Value s2) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValue(crb, s0);
            asm.emit(", ");
            asm.emitValue(crb, s1);
            asm.emit(", ");
            asm.emitValue(crb, s2);
            asm.emit(")");
        }
    }

    public static class OCLOp2
    extends OCLOp {
        public static final OCLOp2 VMOV_SHORT2 = new OCLOp2("(short2)");
        public static final OCLOp2 VMOV_INT2 = new OCLOp2("(int2)");
        public static final OCLOp2 VMOV_FLOAT2 = new OCLOp2("(float2)");
        public static final OCLOp2 VMOV_BYTE2 = new OCLOp2("(char2)");
        public static final OCLOp2 VMOV_DOUBLE2 = new OCLOp2("(double2)");
        public static final OCLOp2 VMOV_HALF2 = new OCLOp2("(half2)");

        protected OCLOp2(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value s0, Value s1) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValue(crb, s0);
            asm.emit(", ");
            asm.emitValue(crb, s1);
            asm.emit(")");
        }
    }

    public static class OCLTernaryTemplate
    extends OCLTernaryOp {
        public static final OCLTernaryTemplate SELECT = new OCLTernaryTemplate("select", "(%s) ? %s : %s");
        private final String template;

        protected OCLTernaryTemplate(String opcode, String template) {
            super(opcode);
            this.template = template;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x, Value y, Value z) {
            OCLAssembler asm = crb.getAssembler();
            asm.beginStackPush();
            asm.emitValueOrOp(crb, x);
            String input1 = asm.getLastOp();
            asm.emitValueOrOp(crb, y);
            String input2 = asm.getLastOp();
            asm.emitValueOrOp(crb, z);
            String input3 = asm.getLastOp();
            asm.endStackPush();
            asm.emit(this.template, input1, input2, input3);
        }
    }

    public static class OCLTernaryIntrinsic
    extends OCLTernaryOp {
        public static final OCLTernaryIntrinsic VSTORE2 = new OCLTernaryIntrinsic("vstore2");
        public static final OCLTernaryIntrinsic VSTORE3 = new OCLTernaryIntrinsic("vstore3");
        public static final OCLTernaryIntrinsic VSTORE4 = new OCLTernaryIntrinsic("vstore4");
        public static final OCLTernaryIntrinsic VSTORE8 = new OCLTernaryIntrinsic("vstore8");
        public static final OCLTernaryIntrinsic VSTORE16 = new OCLTernaryIntrinsic("vstore16");
        public static final OCLTernaryIntrinsic CLAMP = new OCLTernaryIntrinsic("clamp");
        public static final OCLTernaryIntrinsic FMA = new OCLTernaryIntrinsic("fma");

        protected OCLTernaryIntrinsic(String opcode) {
            super(opcode);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x, Value y, Value z) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValueOrOp(crb, x);
            asm.emit(", ");
            asm.emitValueOrOp(crb, y);
            asm.emit(", ");
            asm.emitValueOrOp(crb, z);
            asm.emit(")");
        }
    }

    public static class OCLTernaryOp
    extends OCLOp {
        protected OCLTernaryOp(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value x, Value y, Value z) {
            OCLAssembler asm = crb.getAssembler();
            asm.emitLine("// unimplemented ternary op:");
        }
    }

    public static class OCLBinaryTemplate
    extends OCLBinaryOp {
        public static final OCLBinaryTemplate DECLARE_BYTE_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "byte %s[%s]");
        public static final OCLBinaryTemplate DECLARE_CHAR_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "char %s[%s]");
        public static final OCLBinaryTemplate DECLARE_SHORT_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "short %s[%s]");
        public static final OCLBinaryTemplate DECLARE_INT_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "int %s[%s]");
        public static final OCLBinaryTemplate DECLARE_LONG_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "long %s[%s]");
        public static final OCLBinaryTemplate DECLARE_FLOAT_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "float %s[%s]");
        public static final OCLBinaryTemplate DECLARE_DOUBLE_ARRAY = new OCLBinaryTemplate("DECLARE_ARRAY", "double %s[%s]");
        public static final OCLBinaryTemplate ARRAY_INDEX = new OCLBinaryTemplate("index", "%s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_CHAR_ARRAY = new OCLBinaryTemplate("new private array char", "__private char %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_FLOAT_ARRAY = new OCLBinaryTemplate("new private array float", "__private float %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_INT_ARRAY = new OCLBinaryTemplate("new private array int", "__private int %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_DOUBLE_ARRAY = new OCLBinaryTemplate("new private array double", "__private double %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_LONG_ARRAY = new OCLBinaryTemplate("new private array long", "__private long %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_SHORT_ARRAY = new OCLBinaryTemplate("new private array short", "__private short %s[%s]");
        public static final OCLBinaryTemplate NEW_PRIVATE_BYTE_ARRAY = new OCLBinaryTemplate("new private array byte", "__private byte %s[%s]");
        public static final OCLBinaryTemplate PRIVATE_INT_ARRAY_PTR = new OCLBinaryTemplate("private pointer array int", "__private int* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_CHAR_ARRAY_PTR = new OCLBinaryTemplate("private pointer array char", "__private char* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_FLOAT_ARRAY_PTR = new OCLBinaryTemplate("private pointer array float", "__private float* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_DOUBLE_ARRAY_PTR = new OCLBinaryTemplate("private pointer array double", "__private double* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_LONG_ARRAY_PTR = new OCLBinaryTemplate("private pointer array long", "__private long* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_SHORT_ARRAY_PTR = new OCLBinaryTemplate("private pointer array short", "__private short* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_BYTE_ARRAY_PTR = new OCLBinaryTemplate("private pointer array byte", "__private byte* %s = %s");
        public static final OCLBinaryTemplate PRIVATE_INT_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array int", "__private int* %s = ((__private int *) %s)");
        public static final OCLBinaryTemplate PRIVATE_CHAR_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array char", "__private char* %s = ((__private char *) %s)");
        public static final OCLBinaryTemplate PRIVATE_FLOAT_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array float", "__private float* %s = ((__private float *) %s)");
        public static final OCLBinaryTemplate PRIVATE_DOUBLE_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array double", "__private double* %s = ((__private double *) %s)");
        public static final OCLBinaryTemplate PRIVATE_LONG_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array long", "__private long* %s = ((__private long *) %s)");
        public static final OCLBinaryTemplate PRIVATE_SHORT_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array short", "__private short* %s = ((__private short *) %s)");
        public static final OCLBinaryTemplate PRIVATE_BYTE_ARRAY_PTR_COPY = new OCLBinaryTemplate("private pointer copy array byte", "__private byte* %s = ((__private byte *) %s)");
        public static final OCLBinaryTemplate NEW_LOCAL_FLOAT_ARRAY = new OCLBinaryTemplate("local memory array float", "__local float %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_INT_ARRAY = new OCLBinaryTemplate("local memory array int", "__local int %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_DOUBLE_ARRAY = new OCLBinaryTemplate("local memory array double", "__local double %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_LONG_ARRAY = new OCLBinaryTemplate("local memory array long", "__local long %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_SHORT_ARRAY = new OCLBinaryTemplate("local memory array short", "__local short %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_CHAR_ARRAY = new OCLBinaryTemplate("local memory array char", "__local char %s[%s]");
        public static final OCLBinaryTemplate NEW_LOCAL_HALF_FLOAT_ARRAY = new OCLBinaryTemplate("local memory array half", "__local half %s[%s]");
        private final String template;

        protected OCLBinaryTemplate(String opcode, String template) {
            super(opcode);
            this.template = template;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x, Value y) {
            OCLAssembler asm = crb.getAssembler();
            asm.beginStackPush();
            asm.emitValueOrOp(crb, x);
            String input1 = asm.getLastOp();
            asm.emitValueOrOp(crb, y);
            String input2 = asm.getLastOp();
            asm.endStackPush();
            asm.emit(this.template, input1, input2);
        }
    }

    public static class OCLBinaryIntrinsicCmp
    extends OCLBinaryOp {
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_EQUAL = new OCLBinaryIntrinsicCmp("isequal");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_NOT_EQUAL = new OCLBinaryIntrinsicCmp("isnotequal");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_GREATER = new OCLBinaryIntrinsicCmp("isgreater");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_GREATEREQUAL = new OCLBinaryIntrinsicCmp("isgreaterequal");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_LESS = new OCLBinaryIntrinsicCmp("isless");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_LESSEQUAL = new OCLBinaryIntrinsicCmp("islessequal");
        public static final OCLBinaryIntrinsicCmp FLOAT_IS_LESSGREATER = new OCLBinaryIntrinsicCmp("islessgreater");

        protected OCLBinaryIntrinsicCmp(String opcode) {
            super(opcode);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x, Value y) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValueOrOp(crb, x);
            asm.emit(", ");
            asm.emitValueOrOp(crb, y);
            asm.emit(")");
        }
    }

    public static class OCLBinaryIntrinsic
    extends OCLBinaryOp {
        public static final OCLBinaryIntrinsic INT_MIN = new OCLBinaryIntrinsic("min");
        public static final OCLBinaryIntrinsic INT_MAX = new OCLBinaryIntrinsic("max");
        public static final OCLBinaryIntrinsic ATAN2 = new OCLBinaryIntrinsic("atan2");
        public static final OCLBinaryIntrinsic FLOAT_MIN = new OCLBinaryIntrinsic("fmin");
        public static final OCLBinaryIntrinsic FLOAT_MAX = new OCLBinaryIntrinsic("fmax");
        public static final OCLBinaryIntrinsic FLOAT_POW = new OCLBinaryIntrinsic("pow");
        public static final OCLBinaryIntrinsic ATOMIC_ADD = new OCLBinaryIntrinsic("atomic_add");
        public static final OCLBinaryIntrinsic ATOMIC_SUB = new OCLBinaryIntrinsic("atomic_sub");
        public static final OCLBinaryIntrinsic ATOMIC_XCHG = new OCLBinaryIntrinsic("atomic_xchg");
        public static final OCLBinaryIntrinsic ATOMIC_MIN = new OCLBinaryIntrinsic("atomic_min");
        public static final OCLBinaryIntrinsic ATOMIC_MAX = new OCLBinaryIntrinsic("atomic_max");
        public static final OCLBinaryIntrinsic ATOMIC_AND = new OCLBinaryIntrinsic("atomic_and");
        public static final OCLBinaryIntrinsic ATOMIC_OR = new OCLBinaryIntrinsic("atomic_or");
        public static final OCLBinaryIntrinsic ATOMIC_XOR = new OCLBinaryIntrinsic("atomic_xor");
        public static final OCLBinaryIntrinsic VLOAD2 = new OCLBinaryIntrinsic("vload2");
        public static final OCLBinaryIntrinsic VLOAD3 = new OCLBinaryIntrinsic("vload3");
        public static final OCLBinaryIntrinsic VLOAD4 = new OCLBinaryIntrinsic("vload4");
        public static final OCLBinaryIntrinsic VLOAD8 = new OCLBinaryIntrinsic("vload8");
        public static final OCLBinaryIntrinsic VLOAD16 = new OCLBinaryIntrinsic("vload16");
        public static final OCLBinaryIntrinsic DOT = new OCLBinaryIntrinsic("dot");
        public static final OCLBinaryIntrinsic CROSS = new OCLBinaryIntrinsic("cross");

        protected OCLBinaryIntrinsic(String opcode) {
            super(opcode);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x, Value y) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            asm.emit("(");
            asm.emitValueOrOp(crb, x);
            asm.emit(", ");
            asm.emitValueOrOp(crb, y);
            asm.emit(")");
        }
    }

    public static class OCLBinaryOp
    extends OCLOp {
        public static final OCLBinaryOp ADD = new OCLBinaryOp("+");
        public static final OCLBinaryOp SUB = new OCLBinaryOp("-");
        public static final OCLBinaryOp MUL = new OCLBinaryOp("*");
        public static final OCLBinaryOp DIV = new OCLBinaryOp("/");
        public static final OCLBinaryOp MOD = new OCLBinaryOp("%");
        public static final OCLBinaryOp BITWISE_AND = new OCLBinaryOp("&");
        public static final OCLBinaryOp BITWISE_OR = new OCLBinaryOp("|");
        public static final OCLBinaryOp BITWISE_XOR = new OCLBinaryOp("^");
        public static final OCLBinaryOp BITWISE_LEFT_SHIFT = new OCLBinaryOp("<<");
        public static final OCLBinaryOp BITWISE_RIGHT_SHIFT = new OCLBinaryOp(">>");
        public static final OCLBinaryOp LOGICAL_AND = new OCLBinaryOp("&&");
        public static final OCLBinaryOp LOGICAL_OR = new OCLBinaryOp("||");
        public static final OCLBinaryOp ASSIGN = new OCLBinaryOp("=");
        public static final OCLBinaryOp VECTOR_SELECT = new OCLBinaryOp(".");
        public static final OCLBinaryOp RELATIONAL_EQ = new OCLBinaryOp("==");
        public static final OCLBinaryOp RELATIONAL_NE = new OCLBinaryOp("!=");
        public static final OCLBinaryOp RELATIONAL_GT = new OCLBinaryOp(">");
        public static final OCLBinaryOp RELATIONAL_LT = new OCLBinaryOp("<");
        public static final OCLBinaryOp RELATIONAL_GTE = new OCLBinaryOp(">=");
        public static final OCLBinaryOp RELATIONAL_LTE = new OCLBinaryOp("<=");

        protected OCLBinaryOp(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb, Value x, Value y) {
            OCLAssembler asm = crb.getAssembler();
            asm.emitValueOrOp(crb, x);
            asm.space();
            this.emitOpcode(asm);
            asm.space();
            asm.emitValueOrOp(crb, y);
        }
    }

    public static class OCLUnaryTemplate
    extends OCLUnaryOp {
        public static final OCLUnaryTemplate MEM_CHECK = new OCLUnaryTemplate("mem check", "MEM_CHECK(%s)");
        public static final OCLUnaryTemplate INDIRECTION = new OCLUnaryTemplate("deref", "*(%s)");
        public static final OCLUnaryTemplate CAST_TO_POINTER = new OCLUnaryTemplate("cast ptr", "(%s *)");
        public static final OCLUnaryTemplate LOAD_ADDRESS_ABS = new OCLUnaryTemplate("load address", "*(%s)");
        public static final OCLUnaryTemplate ADDRESS_OF = new OCLUnaryTemplate("address of", "&(%s)");
        public static final OCLUnaryTemplate NEW_INT_ARRAY = new OCLUnaryTemplate("int[]", "int[%s]");
        public static final OCLUnaryTemplate NEW_LONG_ARRAY = new OCLUnaryTemplate("long[]", "long[%s]");
        public static final OCLUnaryTemplate NEW_FLOAT_ARRAY = new OCLUnaryTemplate("float[]", "float[%s]");
        public static final OCLUnaryTemplate NEW_DOUBLE_ARRAY = new OCLUnaryTemplate("double[]", "double[%s]");
        public static final OCLUnaryTemplate NEW_BYTE_ARRAY = new OCLUnaryTemplate("char[]", "char[%s]");
        public static final OCLUnaryTemplate NEW_CHAR_ARRAY = new OCLUnaryTemplate("char[]", "char[%s]");
        public static final OCLUnaryTemplate NEW_SHORT_ARRAY = new OCLUnaryTemplate("short[]", "short[%s]");
        private final String template;

        protected OCLUnaryTemplate(String opcode, String template) {
            super(opcode);
            this.template = template;
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value value) {
            OCLAssembler asm = crb.getAssembler();
            asm.emit(this.template, asm.toString(value));
        }

        public String getTemplate() {
            return this.template;
        }
    }

    public static class OCLUnaryIntrinsic
    extends OCLUnaryOp {
        public static final OCLUnaryIntrinsic GLOBAL_ID = new OCLUnaryIntrinsic("get_global_id");
        public static final OCLUnaryIntrinsic GLOBAL_SIZE = new OCLUnaryIntrinsic("get_global_size");
        public static final OCLUnaryIntrinsic OCL_KERNEL_CONTEXT_ACCESS = new OCLUnaryIntrinsic("_kernel_context");
        public static final OCLUnaryIntrinsic LOCAL_ID = new OCLUnaryIntrinsic("get_local_id");
        public static final OCLUnaryIntrinsic LOCAL_SIZE = new OCLUnaryIntrinsic("get_local_size");
        public static final OCLUnaryIntrinsic GROUP_ID = new OCLUnaryIntrinsic("get_group_id");
        public static final OCLUnaryIntrinsic GROUP_SIZE = new OCLUnaryIntrinsic("get_group_size");
        public static final OCLUnaryIntrinsic ATOMIC_INC = new OCLUnaryIntrinsic("atomic_inc");
        public static final OCLUnaryIntrinsic ATOMIC_FETCH_ADD_EXPLICIT = new OCLUnaryIntrinsic("atomic_fetch_add_explicit");
        public static final OCLUnaryIntrinsic ATOMIC_FETCH_SUB_EXPLICIT = new OCLUnaryIntrinsic("atomic_fetch_sub_explicit");
        public static final OCLUnaryIntrinsic ATOM_ADD = new OCLUnaryIntrinsic("atom_add");
        public static final OCLUnaryIntrinsic ATOMIC_ADD = new OCLUnaryIntrinsic("atomic_add");
        public static final OCLUnaryIntrinsic ATOMIC_VAR_INIT = new OCLUnaryIntrinsic("ATOMIC_VAR_INIT");
        public static final OCLUnaryIntrinsic ATOMIC_DEC = new OCLUnaryIntrinsic("atomic_dec");
        public static final OCLUnaryIntrinsic ATOMIC_GET = new OCLUnaryIntrinsic("atomic[0]");
        public static final OCLUnaryIntrinsic MEMORY_ORDER_RELAXED = new OCLUnaryIntrinsic("memory_order_relaxed");
        public static final OCLUnaryIntrinsic BARRIER = new OCLUnaryIntrinsic("barrier");
        public static final OCLUnaryIntrinsic MEM_FENCE = new OCLUnaryIntrinsic("mem_fence");
        public static final OCLUnaryIntrinsic READ_MEM_FENCE = new OCLUnaryIntrinsic("read_mem_fence");
        public static final OCLUnaryIntrinsic WRITE_MEM_FENCE = new OCLUnaryIntrinsic("write_mem_fence");
        public static final OCLUnaryIntrinsic ABS = new OCLUnaryIntrinsic("abs");
        public static final OCLUnaryIntrinsic CEIL = new OCLUnaryIntrinsic("ceil");
        public static final OCLUnaryIntrinsic EXP = new OCLUnaryIntrinsic("exp");
        public static final OCLUnaryIntrinsic SQRT = new OCLUnaryIntrinsic("sqrt");
        public static final OCLUnaryIntrinsic LOG = new OCLUnaryIntrinsic("log");
        public static final OCLUnaryIntrinsic RADIANS = new OCLUnaryIntrinsic("radians");
        public static final OCLUnaryIntrinsic RSQRT = new OCLUnaryIntrinsic("rsqrt");
        public static final OCLUnaryIntrinsic NATIVE_COS = new OCLUnaryIntrinsic("native_cos");
        public static final OCLUnaryIntrinsic NATIVE_SIN = new OCLUnaryIntrinsic("native_sin");
        public static final OCLUnaryIntrinsic NATIVE_SQRT = new OCLUnaryIntrinsic("native_sqrt");
        public static final OCLUnaryIntrinsic NATIVE_TAN = new OCLUnaryIntrinsic("native_tan");
        public static final OCLUnaryIntrinsic SIN = new OCLUnaryIntrinsic("sin");
        public static final OCLUnaryIntrinsic COS = new OCLUnaryIntrinsic("cos");
        public static final OCLUnaryIntrinsic TAN = new OCLUnaryIntrinsic("tan");
        public static final OCLUnaryIntrinsic TANH = new OCLUnaryIntrinsic("tanh");
        public static final OCLUnaryIntrinsic ATAN = new OCLUnaryIntrinsic("atan");
        public static final OCLUnaryIntrinsic ASIN = new OCLUnaryIntrinsic("asin");
        public static final OCLUnaryIntrinsic ASINH = new OCLUnaryIntrinsic("asinh");
        public static final OCLUnaryIntrinsic ACOS = new OCLUnaryIntrinsic("acos");
        public static final OCLUnaryIntrinsic ACOSH = new OCLUnaryIntrinsic("acosh");
        public static final OCLUnaryIntrinsic SINPI = new OCLUnaryIntrinsic("sinpi");
        public static final OCLUnaryIntrinsic COSPI = new OCLUnaryIntrinsic("cospi");
        public static final OCLUnaryIntrinsic SIGN = new OCLUnaryIntrinsic("sign");
        public static final OCLUnaryIntrinsic LOCAL_MEMORY = new OCLUnaryIntrinsic("__local");
        public static final OCLUnaryIntrinsic POPCOUNT = new OCLUnaryIntrinsic("popcount");
        public static final OCLUnaryIntrinsic FLOAT_ABS = new OCLUnaryIntrinsic("fabs");
        public static final OCLUnaryIntrinsic FLOAT_TRUNC = new OCLUnaryIntrinsic("trunc");
        public static final OCLUnaryIntrinsic FLOAT_FLOOR = new OCLUnaryIntrinsic("floor");
        public static final OCLUnaryIntrinsic SIGN_BIT = new OCLUnaryIntrinsic("signbit");
        public static final OCLUnaryIntrinsic ANY = new OCLUnaryIntrinsic("any");
        public static final OCLUnaryIntrinsic ALL = new OCLUnaryIntrinsic("all");
        public static final OCLUnaryIntrinsic AS_FLOAT = new OCLUnaryIntrinsic("as_float");
        public static final OCLUnaryIntrinsic AS_INT = new OCLUnaryIntrinsic("as_int");
        public static final OCLUnaryIntrinsic IS_FINITE = new OCLUnaryIntrinsic("isfinite");
        public static final OCLUnaryIntrinsic IS_INF = new OCLUnaryIntrinsic("isinf");
        public static final OCLUnaryIntrinsic IS_NAN = new OCLUnaryIntrinsic("isnan");
        public static final OCLUnaryIntrinsic IS_NORMAL = new OCLUnaryIntrinsic("isnormal");

        protected OCLUnaryIntrinsic(String opcode) {
            super(opcode, true);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb, Value x) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
            if (x != null) {
                asm.emit("(");
                asm.emitValueOrOp(crb, x);
                asm.emit(")");
            }
        }

        public void emit(OCLCompilationResultBuilder crb) {
            this.emit(crb, null);
        }
    }

    public static class OCLUnaryOp
    extends OCLOp {
        public static final OCLUnaryOp RETURN = new OCLUnaryOp("return ", true);
        public static final OCLUnaryOp INC = new OCLUnaryOp("++", false);
        public static final OCLUnaryOp DEC = new OCLUnaryOp("--", false);
        public static final OCLUnaryOp NEGATE = new OCLUnaryOp("-", true);
        public static final OCLUnaryOp LOGICAL_NOT = new OCLUnaryOp("!", true);
        public static final OCLUnaryOp BITWISE_NOT = new OCLUnaryOp("~", true);
        public static final OCLUnaryOp CAST_TO_INT = new OCLUnaryOp("(int) ", true);
        public static final OCLUnaryOp CAST_TO_SHORT = new OCLUnaryOp("(short) ", true);
        public static final OCLUnaryOp CAST_TO_LONG = new OCLUnaryOp("(long) ", true);
        public static final OCLUnaryOp CAST_TO_ULONG = new OCLUnaryOp("(ulong) ", true);
        public static final OCLUnaryOp CAST_TO_FLOAT = new OCLUnaryOp("(float) ", true);
        public static final OCLUnaryOp CAST_TO_BYTE = new OCLUnaryOp("(char) ", true);
        public static final OCLUnaryOp CAST_TO_DOUBLE = new OCLUnaryOp("(double) ", true);
        public static final OCLUnaryOp CAST_TO_INT_PTR = new OCLUnaryOp("(int *) ", true);
        public static final OCLUnaryOp CAST_TO_SHORT_PTR = new OCLUnaryOp("(short *) ", true);
        public static final OCLUnaryOp CAST_TO_LONG_PTR = new OCLUnaryOp("(long *) ", true);
        public static final OCLUnaryOp CAST_TO_ULONG_PTR = new OCLUnaryOp("(ulong *) ", true);
        public static final OCLUnaryOp CAST_TO_FLOAT_PTR = new OCLUnaryOp("(float *) ", true);
        public static final OCLUnaryOp CAST_TO_BYTE_PTR = new OCLUnaryOp("(char *) ", true);
        private final boolean prefix;

        protected OCLUnaryOp(String opcode) {
            this(opcode, false);
        }

        protected OCLUnaryOp(String opcode, boolean prefix) {
            super(opcode);
            this.prefix = prefix;
        }

        public void emit(OCLCompilationResultBuilder crb, Value x) {
            OCLAssembler asm = crb.getAssembler();
            if (this.prefix) {
                this.emitOpcode(asm);
                asm.emitValueOrOp(crb, x);
            } else {
                asm.emitValueOrOp(crb, x);
                this.emitOpcode(asm);
            }
        }
    }

    public static class OCLNullaryTemplate
    extends OCLNullaryOp {
        public OCLNullaryTemplate(String opcode) {
            super(opcode);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb) {
            OCLAssembler asm = crb.getAssembler();
            asm.emit(this.opcode);
        }
    }

    public static class OCLNullaryIntrinsic
    extends OCLNullaryOp {
        protected OCLNullaryIntrinsic(String opcode) {
            super(opcode);
        }

        @Override
        public void emit(OCLCompilationResultBuilder crb) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
        }
    }

    public static class OCLNullaryOp
    extends OCLOp {
        public static final OCLNullaryOp RETURN = new OCLNullaryOp("return");

        protected OCLNullaryOp(String opcode) {
            super(opcode);
        }

        public void emit(OCLCompilationResultBuilder crb) {
            OCLAssembler asm = crb.getAssembler();
            this.emitOpcode(asm);
        }
    }

    public static class OCLOp {
        protected final String opcode;

        protected OCLOp(String opcode) {
            this.opcode = opcode;
        }

        protected final void emitOpcode(OCLAssembler asm) {
            asm.emit(this.opcode);
        }

        public boolean equals(OCLOp other) {
            return this.opcode.equals(other.opcode);
        }

        public String toString() {
            return this.opcode;
        }
    }
}

