/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCanonicalizer;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilerConfiguration;
import uk.ac.manchester.tornado.runtime.graal.TornadoLIRSuites;
import uk.ac.manchester.tornado.runtime.graal.TornadoSuites;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoCompilerConfiguration;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSketchTier;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSuitesProvider;

public class OCLSuitesProvider
implements TornadoSuitesProvider {
    private final PhaseSuite<HighTierContext> graphBuilderSuite;
    private final TornadoSuites suites;
    private final TornadoLIRSuites lirSuites;
    private final OCLCanonicalizer canonicalizer;

    public OCLSuitesProvider(OptionValues options, TornadoDeviceContext deviceContext, GraphBuilderConfiguration.Plugins plugins, MetaAccessProvider metaAccessProvider, OCLCompilerConfiguration compilerConfig, AddressLoweringByNodePhase.AddressLowering addressLowering) {
        this.graphBuilderSuite = this.createGraphBuilderSuite(plugins);
        this.canonicalizer = new OCLCanonicalizer();
        this.suites = new TornadoSuites(options, deviceContext, (TornadoCompilerConfiguration)compilerConfig, metaAccessProvider, (CanonicalizerPhase.CustomSimplification)this.canonicalizer, addressLowering);
        this.lirSuites = new TornadoLIRSuites(this.suites.getPreAllocationOptimizationStage(), this.suites.getAllocationStage(), this.suites.getPostAllocationOptimizationStage());
    }

    private PhaseSuite<HighTierContext> createGraphBuilderSuite(GraphBuilderConfiguration.Plugins plugins) {
        PhaseSuite suite = new PhaseSuite();
        GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault((GraphBuilderConfiguration.Plugins)plugins);
        config.withEagerResolving(true);
        suite.appendPhase((BasePhase)new GraphBuilderPhase(config));
        return suite;
    }

    public TornadoSuites getSuites() {
        return this.suites;
    }

    public PhaseSuite<HighTierContext> getGraphBuilderSuite() {
        return this.graphBuilderSuite;
    }

    public TornadoLIRSuites getLIRSuites() {
        return this.lirSuites;
    }

    public TornadoSketchTier getSketchTier() {
        return this.suites.getSketchTier();
    }
}

