/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

public class OCLStamp
extends ObjectStamp {
    private OCLKind oclKind;
    private static final ResolvedJavaType STAMP_TYPE = null;
    private static final boolean EXACT_TYPE = true;
    private static final boolean NON_NULL = true;
    private static final boolean ALWAYS_NULL = false;
    private static final boolean ALWAYS_ARRAY = false;

    public OCLStamp(OCLKind lirKind) {
        super(STAMP_TYPE, true, true, false, false);
        this.oclKind = lirKind;
    }

    public Stamp constant(Constant cnstnt, MetaAccessProvider map) {
        TornadoInternalError.shouldNotReachHere();
        return this;
    }

    public Stamp empty() {
        return this;
    }

    public LIRKind getLIRKind(LIRKindTool lirKindTool) {
        return LIRKind.value((PlatformKind)this.oclKind);
    }

    public OCLKind getOCLKind() {
        return this.oclKind;
    }

    public JavaKind getStackKind() {
        if (this.oclKind.isPrimitive()) {
            switch (this.oclKind) {
                case BOOL: {
                    return JavaKind.Boolean;
                }
                case CHAR: 
                case UCHAR: {
                    return JavaKind.Byte;
                }
                case SHORT: 
                case USHORT: 
                case HALF: {
                    return JavaKind.Short;
                }
                case UINT: 
                case INT: {
                    return JavaKind.Int;
                }
                case LONG: 
                case ULONG: {
                    return JavaKind.Long;
                }
                case FLOAT: {
                    return JavaKind.Float;
                }
                case DOUBLE: {
                    return JavaKind.Double;
                }
            }
            return JavaKind.Illegal;
        }
        if (this.oclKind.isVector()) {
            return JavaKind.Object;
        }
        return JavaKind.Illegal;
    }

    public boolean hasValues() {
        return true;
    }

    public Stamp improveWith(Stamp stamp) {
        return this;
    }

    public boolean isCompatible(Constant constant) {
        TornadoInternalError.shouldNotReachHere();
        return false;
    }

    public boolean isCompatible(Stamp stamp) {
        if (stamp instanceof OCLStamp && ((OCLStamp)stamp).oclKind == this.oclKind) {
            return true;
        }
        TornadoInternalError.unimplemented((String)"stamp iscompat: %s + %s", (Object[])new Object[]{this, stamp});
        return false;
    }

    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        if (this.oclKind.getJavaClass() != null) {
            return metaAccess.lookupJavaType(this.oclKind.getJavaClass());
        }
        TornadoInternalError.shouldNotReachHere();
        return null;
    }

    public Stamp join(Stamp stamp) {
        if (stamp instanceof OCLStamp && ((OCLStamp)stamp).oclKind == this.oclKind) {
            return this;
        }
        return this;
    }

    public Stamp meet(Stamp stamp) {
        return this;
    }

    public Constant readConstant(MemoryAccessProvider metaAccess, Constant constant, long displacment) {
        TornadoInternalError.shouldNotReachHere();
        return null;
    }

    public String toString() {
        return "ocl: " + this.oclKind.name();
    }

    public Stamp unrestricted() {
        return this;
    }
}

