/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import java.util.Iterator;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryExtendKind;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.ExtendableMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.DefaultJavaLoweringProvider;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.word.LocationIdentity;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.AtomicAddNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.CastNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FixedArrayNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GlobalThreadIdNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GlobalThreadSizeNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GroupIdNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalArrayNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalThreadIdNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalThreadSizeNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLDecompressedReadFieldNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.ReadHalfFloatNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.WriteHalfFloatNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.calc.DivNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.LoadIndexedVectorNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.snippets.ReduceCPUSnippets;
import uk.ac.manchester.tornado.drivers.opencl.graal.snippets.ReduceGPUSnippets;
import uk.ac.manchester.tornado.drivers.providers.TornadoMemoryOrder;
import uk.ac.manchester.tornado.runtime.TornadoVMConfigAccess;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.GetGroupIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.GlobalGroupSizeFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.LocalGroupSizeFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.NewArrayNonVirtualizableNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.StoreAtomicIndexedNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ThreadIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ThreadLocalIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoDirectCallTargetNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.WriteAtomicNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkLocalArray;

public class OCLLoweringProvider
extends DefaultJavaLoweringProvider {
    private static final boolean USE_ATOMICS = false;
    private static boolean gpuSnippet = false;
    private final ConstantReflectionProvider constantReflection;
    private final TornadoVMConfigAccess vmConfig;
    private ReduceGPUSnippets.Templates gpuReduceSnippets;
    private ReduceCPUSnippets.Templates cpuReduceSnippets;

    public OCLLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, ConstantReflectionProvider constantReflection, TornadoVMConfigAccess vmConfig, OCLTargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, (TargetDescription)target, false);
        this.vmConfig = vmConfig;
        this.constantReflection = constantReflection;
    }

    public static boolean isGPUSnippet() {
        return gpuSnippet;
    }

    public void initialize(OptionValues options, SnippetCounter.Group.Factory factory, Providers providers) {
        super.initialize(options, factory, providers);
        this.initializeSnippets(options, factory, providers);
    }

    private void initializeSnippets(OptionValues options, SnippetCounter.Group.Factory factory, Providers providers) {
        this.cpuReduceSnippets = new ReduceCPUSnippets.Templates(options, providers);
        this.gpuReduceSnippets = new ReduceGPUSnippets.Templates(options, providers);
    }

    public void lower(Node node, LoweringTool tool) {
        if (node instanceof Invoke) {
            this.lowerInvoke((Invoke)node, tool, (StructuredGraph)node.graph());
        } else if (!(node instanceof AbstractDeoptimizeNode || node instanceof UnwindNode || node instanceof RemNode)) {
            if (node instanceof FloatConvertNode) {
                this.lowerFloatConvertNode((FloatConvertNode)node);
            } else if (node instanceof NewArrayNonVirtualizableNode) {
                this.lowerNewArrayNode((NewArrayNonVirtualizableNode)node);
            } else if (node instanceof AtomicAddNode) {
                this.lowerAtomicAddNode((AtomicAddNode)node, tool);
            } else if (node instanceof LoadIndexedNode) {
                this.lowerLoadIndexedNode((LoadIndexedNode)node, tool);
            } else if (node instanceof StoreIndexedNode) {
                this.lowerStoreIndexedNode((StoreIndexedNode)node, tool);
            } else if (node instanceof StoreAtomicIndexedNode) {
                this.lowerReduceSnippets(node, tool);
            } else if (node instanceof WriteAtomicNode) {
                this.lowerReduceSnippets(node, tool);
            } else if (node instanceof LoadFieldNode) {
                this.lowerLoadFieldNode((LoadFieldNode)node, tool);
            } else if (node instanceof StoreFieldNode) {
                this.lowerStoreFieldNode((StoreFieldNode)node, tool);
            } else if (node instanceof ArrayLengthNode) {
                this.lowerArrayLengthNode((ArrayLengthNode)node, tool);
            } else if (node instanceof IntegerDivRemNode) {
                this.lowerIntegerDivRemNode((IntegerDivRemNode)node);
            } else if (!(node instanceof InstanceOfNode)) {
                if (node instanceof ThreadIdFixedWithNextNode) {
                    this.lowerThreadIdNode((ThreadIdFixedWithNextNode)node);
                } else if (node instanceof ThreadLocalIdFixedWithNextNode) {
                    this.lowerLocalThreadIdNode((ThreadLocalIdFixedWithNextNode)node);
                } else if (node instanceof GetGroupIdFixedWithNextNode) {
                    this.lowerGetGroupIdNode((GetGroupIdFixedWithNextNode)node);
                } else if (node instanceof GlobalGroupSizeFixedWithNextNode) {
                    this.lowerGlobalGroupSizeNode((GlobalGroupSizeFixedWithNextNode)node);
                } else if (node instanceof LocalGroupSizeFixedWithNextNode) {
                    this.lowerLocalGroupSizeNode((LocalGroupSizeFixedWithNextNode)node);
                } else {
                    super.lower(node, tool);
                }
            }
        }
    }

    public Integer smallestCompareWidth() {
        return null;
    }

    public boolean supportsBulkZeroing() {
        TornadoInternalError.unimplemented((String)"OCLLoweringProvider::supportsBulkZeroing unimplemented");
        return false;
    }

    public boolean supportsRounding() {
        return false;
    }

    public boolean writesStronglyOrdered() {
        return false;
    }

    public boolean divisionOverflowIsJVMSCompliant() {
        return false;
    }

    public boolean narrowsUseCastValue() {
        return false;
    }

    public boolean supportsFoldingExtendIntoAccess(ExtendableMemoryAccess access, MemoryExtendKind extendKind) {
        return false;
    }

    private void lowerReduceSnippets(Node node, LoweringTool tool) {
        StructuredGraph graph = null;
        ValueNode startIndexNode = null;
        if (node instanceof StoreAtomicIndexedNode) {
            graph = ((StoreAtomicIndexedNode)node).graph();
            startIndexNode = ((StoreAtomicIndexedNode)node).getStartNode();
        } else if (node instanceof WriteAtomicNode) {
            graph = ((WriteAtomicNode)node).graph();
            startIndexNode = ((WriteAtomicNode)node).getStartNode();
        }
        GlobalThreadIdNode oclIdNode = (GlobalThreadIdNode)graph.getNodes().filter(GlobalThreadIdNode.class).first();
        GlobalThreadSizeNode oclGlobalSize = (GlobalThreadSizeNode)graph.getNodes().filter(GlobalThreadSizeNode.class).first();
        ValueNode threadID = null;
        Iterator usages = oclIdNode.usages().iterator();
        boolean cpuScheduler = false;
        block0: while (usages.hasNext()) {
            Node n = (Node)usages.next();
            if (n instanceof BinaryArithmeticNode && n.usages().filter(PhiNode.class).isNotEmpty()) {
                gpuSnippet = true;
                threadID = (ValueNode)n.usages().filter(PhiNode.class).first();
                break;
            }
            if (n instanceof PhiNode) {
                gpuSnippet = true;
                threadID = (ValueNode)n;
                break;
            }
            if (!(n instanceof MulNode)) continue;
            for (Node n2 : n.usages()) {
                if (!(n2 instanceof PhiNode)) continue;
                threadID = (ValueNode)n2;
                cpuScheduler = true;
                continue block0;
            }
        }
        if (cpuScheduler) {
            if (node instanceof StoreAtomicIndexedNode) {
                storeAtomicIndexedNode = (StoreAtomicIndexedNode)node;
                this.cpuReduceSnippets.lower(storeAtomicIndexedNode, threadID, (ValueNode)oclIdNode, startIndexNode, tool);
            } else if (node instanceof WriteAtomicNode) {
                writeAtomicNode = (WriteAtomicNode)node;
                this.cpuReduceSnippets.lower(writeAtomicNode, threadID, (ValueNode)oclIdNode, startIndexNode, tool);
            }
        } else if (node instanceof StoreAtomicIndexedNode) {
            storeAtomicIndexedNode = (StoreAtomicIndexedNode)node;
            this.gpuReduceSnippets.lower(storeAtomicIndexedNode, threadID, oclGlobalSize, tool);
        } else if (node instanceof WriteAtomicNode) {
            writeAtomicNode = (WriteAtomicNode)node;
            this.gpuReduceSnippets.lower(writeAtomicNode, threadID, oclGlobalSize, tool);
        }
    }

    private void lowerIntegerDivRemNode(IntegerDivRemNode integerDivRemNode) {
        StructuredGraph graph = integerDivRemNode.graph();
        switch (integerDivRemNode.getOp()) {
            case DIV: {
                ValueNode div = (ValueNode)graph.addOrUnique((Node)DivNode.create(integerDivRemNode.getX(), integerDivRemNode.getY()));
                graph.replaceFixedWithFloating((FixedWithNextNode)integerDivRemNode, div);
                break;
            }
            case REM: {
                ValueNode rem = (ValueNode)graph.addOrUnique((Node)RemNode.create((ValueNode)integerDivRemNode.getX(), (ValueNode)integerDivRemNode.getY(), (NodeView)NodeView.DEFAULT));
                graph.replaceFixedWithFloating((FixedWithNextNode)integerDivRemNode, rem);
            }
        }
    }

    private void lowerThreadIdNode(ThreadIdFixedWithNextNode threadIdNode) {
        StructuredGraph graph = threadIdNode.graph();
        GlobalThreadIdNode globalThreadIdNode = (GlobalThreadIdNode)graph.addOrUnique((Node)new GlobalThreadIdNode(ConstantNode.forInt((int)threadIdNode.getDimension(), (StructuredGraph)graph)));
        graph.replaceFixedWithFloating((FixedWithNextNode)threadIdNode, (ValueNode)globalThreadIdNode);
    }

    private void lowerLocalThreadIdNode(ThreadLocalIdFixedWithNextNode threadLocalIdNode) {
        StructuredGraph graph = threadLocalIdNode.graph();
        LocalThreadIdNode localThreadIdNode = (LocalThreadIdNode)graph.addOrUnique((Node)new LocalThreadIdNode(ConstantNode.forInt((int)threadLocalIdNode.getDimension(), (StructuredGraph)graph)));
        graph.replaceFixedWithFloating((FixedWithNextNode)threadLocalIdNode, (ValueNode)localThreadIdNode);
    }

    private void lowerGetGroupIdNode(GetGroupIdFixedWithNextNode getGroupIdNode) {
        StructuredGraph graph = getGroupIdNode.graph();
        GroupIdNode groupIdNode = (GroupIdNode)graph.addOrUnique((Node)new GroupIdNode(ConstantNode.forInt((int)getGroupIdNode.getDimension(), (StructuredGraph)graph)));
        graph.replaceFixedWithFloating((FixedWithNextNode)getGroupIdNode, (ValueNode)groupIdNode);
    }

    private void lowerGlobalGroupSizeNode(GlobalGroupSizeFixedWithNextNode globalGroupSizeNode) {
        StructuredGraph graph = globalGroupSizeNode.graph();
        GlobalThreadSizeNode globalThreadSizeNode = (GlobalThreadSizeNode)graph.addOrUnique((Node)new GlobalThreadSizeNode(ConstantNode.forInt((int)globalGroupSizeNode.getDimension(), (StructuredGraph)graph)));
        graph.replaceFixedWithFloating((FixedWithNextNode)globalGroupSizeNode, (ValueNode)globalThreadSizeNode);
    }

    private void lowerLocalGroupSizeNode(LocalGroupSizeFixedWithNextNode localGroupSizeNode) {
        StructuredGraph graph = localGroupSizeNode.graph();
        LocalThreadSizeNode localThreadSizeNode = (LocalThreadSizeNode)graph.addOrUnique((Node)new LocalThreadSizeNode(ConstantNode.forInt((int)localGroupSizeNode.getDimension(), (StructuredGraph)graph)));
        graph.replaceFixedWithFloating((FixedWithNextNode)localGroupSizeNode, (ValueNode)localThreadSizeNode);
    }

    protected void lowerArrayLengthNode(ArrayLengthNode arrayLengthNode, LoweringTool tool) {
        StructuredGraph graph = arrayLengthNode.graph();
        ValueNode array = arrayLengthNode.array();
        AddressNode address = this.createOffsetAddress(graph, array, this.arrayLengthOffset());
        ReadNode arrayLengthRead = (ReadNode)graph.add((Node)new ReadNode(address, NamedLocationIdentity.ARRAY_LENGTH_LOCATION, StampFactory.positiveInt(), BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE));
        graph.replaceFixedWithFixed((FixedWithNextNode)arrayLengthNode, (FixedWithNextNode)arrayLengthRead);
    }

    public void lowerLoadIndexedNode(LoadIndexedNode loadIndexed, LoweringTool tool) {
        LocalArrayNode localArrayNode;
        StructuredGraph graph = loadIndexed.graph();
        JavaKind elementKind = loadIndexed.elementKind();
        Stamp loadStamp = loadIndexed.stamp(NodeView.DEFAULT);
        if (!(loadIndexed.stamp(NodeView.DEFAULT) instanceof OCLStamp)) {
            loadStamp = this.loadStamp(loadIndexed.stamp(NodeView.DEFAULT), elementKind, false);
        }
        AddressNode address = this.createArrayAccess(graph, loadIndexed, elementKind);
        ValueNode valueNode = loadIndexed.array();
        if (valueNode instanceof LocalArrayNode && (localArrayNode = (LocalArrayNode)valueNode).getOCLKind() == OCLKind.HALF) {
            ReadHalfFloatNode localHalfFloatRead = (ReadHalfFloatNode)graph.add((Node)new ReadHalfFloatNode(address, loadIndexed.index()));
            loadIndexed.replaceAtUsages((Node)localHalfFloatRead);
            graph.replaceFixed((FixedWithNextNode)loadIndexed, (Node)localHalfFloatRead);
        } else {
            ReadNode memoryRead = loadIndexed instanceof LoadIndexedVectorNode ? (ReadNode)graph.add((Node)new ReadNode(address, LocationIdentity.any(), loadStamp, BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE)) : (ReadNode)graph.add((Node)new ReadNode(address, NamedLocationIdentity.getArrayLocation((JavaKind)elementKind), loadStamp, BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE));
            loadIndexed.replaceAtUsages((Node)memoryRead);
            graph.replaceFixed((FixedWithNextNode)loadIndexed, (Node)memoryRead);
        }
    }

    public void lowerStoreIndexedNode(StoreIndexedNode storeIndexed, LoweringTool tool) {
        LocalArrayNode localArrayNode;
        StructuredGraph graph = storeIndexed.graph();
        JavaKind elementKind = storeIndexed.elementKind();
        ValueNode value = storeIndexed.value();
        ValueNode array = storeIndexed.array();
        AddressNode address = this.createArrayAddress(graph, array, elementKind, storeIndexed.index());
        if (array instanceof LocalArrayNode && (localArrayNode = (LocalArrayNode)array).getOCLKind() == OCLKind.HALF) {
            WriteHalfFloatNode localHalfFloatWrite = (WriteHalfFloatNode)graph.add((Node)new WriteHalfFloatNode(address, value, storeIndexed.index()));
            graph.replaceFixedWithFixed((FixedWithNextNode)storeIndexed, (FixedWithNextNode)localHalfFloatWrite);
        } else {
            AbstractWriteNode memoryWrite = this.createMemWriteNode(elementKind, value, array, address, graph, storeIndexed);
            memoryWrite.setStateAfter(storeIndexed.stateAfter());
            graph.replaceFixedWithFixed((FixedWithNextNode)storeIndexed, (FixedWithNextNode)memoryWrite);
        }
    }

    protected void lowerLoadFieldNode(LoadFieldNode loadField, LoweringTool tool) {
        assert (loadField.getStackKind() != JavaKind.Illegal);
        StructuredGraph graph = loadField.graph();
        ResolvedJavaField field = loadField.field();
        ValueNode object = loadField.isStatic() ? this.staticFieldBase(graph, field) : loadField.object();
        Stamp loadStamp = this.loadStamp(loadField.stamp(NodeView.DEFAULT), field.getJavaKind());
        AddressNode address = this.createFieldAddress(graph, object, field);
        assert (address != null) : "Field that is loaded must not be eliminated: " + field.getDeclaringClass().toJavaName(true) + "." + field.getName();
        boolean areCoopsEnabled = TornadoOptions.coopsUsed();
        if (areCoopsEnabled && !field.getJavaKind().isPrimitive()) {
            OCLDecompressedReadFieldNode decompressedNode = (OCLDecompressedReadFieldNode)graph.add((Node)new OCLDecompressedReadFieldNode(object, address, loadStamp));
            loadField.replaceAtUsages((Node)decompressedNode);
            graph.replaceFixed((FixedWithNextNode)loadField, (Node)decompressedNode);
        } else {
            FieldLocationIdentity fieldLocationIdentity = new FieldLocationIdentity(field);
            ReadNode memoryRead = (ReadNode)graph.add((Node)new ReadNode(address, (LocationIdentity)fieldLocationIdentity, loadStamp, BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE));
            loadField.replaceAtUsages((Node)memoryRead);
            graph.replaceFixed((FixedWithNextNode)loadField, (Node)memoryRead);
        }
    }

    protected void lowerStoreFieldNode(StoreFieldNode storeField, LoweringTool tool) {
        StructuredGraph graph = storeField.graph();
        ResolvedJavaField field = storeField.field();
        ValueNode object = storeField.isStatic() ? this.staticFieldBase(graph, field) : storeField.object();
        AddressNode address = this.createFieldAddress(graph, object, field);
        assert (address != null);
        FieldLocationIdentity fieldLocationIdentity = new FieldLocationIdentity(field);
        WriteNode memoryWrite = (WriteNode)graph.add((Node)new WriteNode(address, (LocationIdentity)fieldLocationIdentity, storeField.value(), BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE));
        memoryWrite.setStateAfter(storeField.stateAfter());
        graph.replaceFixedWithFixed((FixedWithNextNode)storeField, (FixedWithNextNode)memoryWrite);
    }

    private void lowerAtomicAddNode(AtomicAddNode atomicAdd, LoweringTool tool) {
        TornadoInternalError.shouldNotReachHere((String)"need to use builtin nodes");
    }

    private void lowerInvoke(Invoke invoke, LoweringTool tool, StructuredGraph graph) {
        if (invoke.callTarget() instanceof MethodCallTargetNode) {
            ObjectStamp os;
            ResolvedJavaType type;
            OCLKind oclKind;
            ValueNode receiver;
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            NodeInputList parameters = callTarget.arguments();
            ValueNode valueNode = receiver = parameters.size() <= 0 ? null : (ValueNode)parameters.get(0);
            if (!callTarget.isStatic() && receiver.stamp(NodeView.DEFAULT) instanceof ObjectStamp && !StampTool.isPointerNonNull((ValueNode)receiver)) {
                ValueNode nonNullReceiver = this.createNullCheckedValue(receiver, invoke.asFixedNode(), tool);
                parameters.set(0, (Object)nonNullReceiver);
                receiver = nonNullReceiver;
            }
            JavaType[] signature = callTarget.targetMethod().getSignature().toParameterTypes(callTarget.isStatic() ? null : callTarget.targetMethod().getDeclaringClass());
            LoweredCallTargetNode loweredCallTarget = null;
            StampPair returnStampPair = callTarget.returnStamp();
            Stamp returnStamp = returnStampPair.getTrustedStamp();
            if (returnStamp instanceof ObjectStamp && (oclKind = OCLKind.fromResolvedJavaType(type = (os = (ObjectStamp)returnStamp).javaType(tool.getMetaAccess()))) != OCLKind.ILLEGAL) {
                returnStampPair = StampPair.createSingle((Stamp)OCLStampFactory.getStampFor(oclKind));
            }
            loweredCallTarget = (LoweredCallTargetNode)graph.add((Node)new TornadoDirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), returnStampPair, signature, callTarget.targetMethod(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, callTarget.invokeKind()));
            callTarget.replaceAndDelete((Node)loweredCallTarget);
        }
    }

    private void lowerFloatConvertNode(FloatConvertNode floatConvert) {
        StructuredGraph graph = floatConvert.graph();
        CastNode asFloat = (CastNode)graph.addWithoutUnique((Node)new CastNode(floatConvert.stamp(NodeView.DEFAULT), floatConvert.getFloatConvert(), floatConvert.getValue()));
        floatConvert.replaceAtUsages((Node)asFloat);
        floatConvert.safeDelete();
    }

    private void lowerNewArrayNode(NewArrayNonVirtualizableNode newArray) {
        StructuredGraph graph = newArray.graph();
        ValueNode firstInput = newArray.length();
        if (firstInput instanceof ConstantNode) {
            if (newArray.dimensionCount() == 1) {
                ConstantNode lengthNode = (ConstantNode)firstInput;
                if (lengthNode.getValue() instanceof PrimitiveConstant) {
                    int length = ((PrimitiveConstant)lengthNode.getValue()).asInt();
                    if (gpuSnippet) {
                        this.lowerLocalNewArray(graph, length, newArray);
                    } else {
                        this.lowerPrivateNewArray(graph, length, newArray);
                    }
                    newArray.clearInputs();
                    GraphUtil.unlinkFixedNode((FixedWithNextNode)newArray);
                    GraphUtil.removeFixedWithUnusedInputs((FixedWithNextNode)newArray);
                } else {
                    TornadoInternalError.shouldNotReachHere();
                }
            } else {
                TornadoInternalError.unimplemented((String)"multi-dimensional array declarations are not supported");
            }
        } else {
            TornadoInternalError.unimplemented((String)"dynamically sized array declarations are not supported");
        }
    }

    public int arrayBaseOffset(JavaKind kind) {
        return this.metaAccess.getArrayBaseOffset(kind);
    }

    public int arrayLengthOffset() {
        return this.vmConfig.arrayOopDescLengthOffset();
    }

    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        TornadoInternalError.unimplemented();
        return null;
    }

    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public int fieldOffset(ResolvedJavaField f) {
        HotSpotResolvedJavaField field = (HotSpotResolvedJavaField)f;
        return field.getOffset();
    }

    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        TornadoInternalError.unimplemented((String)"Create READ hub is not supported yet");
        return null;
    }

    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, boolean isKnownObjectArray, FixedNode anchor) {
        return null;
    }

    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        HotSpotResolvedJavaField field = (HotSpotResolvedJavaField)f;
        JavaConstant base = this.constantReflection.asJavaClass(field.getDeclaringClass());
        return ConstantNode.forConstant((JavaConstant)base, (MetaAccessProvider)this.metaAccess, (StructuredGraph)graph);
    }

    private AddressNode createArrayLocalAddress(StructuredGraph graph, ValueNode array, ValueNode index) {
        return (AddressNode)graph.unique((Node)new OffsetAddressNode(array, index));
    }

    private boolean isLocalIDNode(StoreIndexedNode storeIndexed) {
        Node nd = storeIndexed.inputs().first();
        InvokeNode node = (InvokeNode)nd.inputs().filter(InvokeNode.class).first();
        boolean willLowerToLocalArrayNode = node != null && "Direct#NewArrayNode.newArray".equals(node.callTarget().targetName()) && gpuSnippet;
        return nd instanceof MarkLocalArray || willLowerToLocalArrayNode;
    }

    private boolean isLocalIDNode(LoadIndexedNode loadIndexedNode) {
        Node nd = loadIndexedNode.inputs().first();
        InvokeNode node = (InvokeNode)nd.inputs().filter(InvokeNode.class).first();
        boolean willLowerToLocalArrayNode = node != null && "Direct#NewArrayNode.newArray".equals(node.callTarget().targetName()) && gpuSnippet;
        return nd instanceof MarkLocalArray || willLowerToLocalArrayNode;
    }

    private boolean isPrivateIDNode(StoreIndexedNode storeIndexed) {
        Node nd = storeIndexed.inputs().first();
        return nd instanceof FixedArrayNode;
    }

    private boolean isPrivateIDNode(LoadIndexedNode loadIndexedNode) {
        Node nd = loadIndexedNode.inputs().first();
        return nd instanceof FixedArrayNode;
    }

    private void lowerLocalNewArray(StructuredGraph graph, int length, NewArrayNonVirtualizableNode newArray) {
        ConstantNode newLengthNode = ConstantNode.forInt((int)length, (StructuredGraph)graph);
        LocalArrayNode localArrayNode = (LocalArrayNode)graph.addWithoutUnique((Node)new LocalArrayNode(OCLArchitecture.localSpace, newArray.elementType(), (ValueNode)newLengthNode));
        newArray.replaceAtUsages((Node)localArrayNode);
    }

    private void lowerPrivateNewArray(StructuredGraph graph, int size, NewArrayNonVirtualizableNode newArray) {
        ConstantNode newLengthNode = ConstantNode.forInt((int)size, (StructuredGraph)graph);
        FixedArrayNode fixedArrayNode = (FixedArrayNode)graph.addWithoutUnique((Node)new FixedArrayNode(OCLArchitecture.privateSpace, newArray.elementType(), newLengthNode));
        newArray.replaceAtUsages((Node)fixedArrayNode);
    }

    private AddressNode createArrayAccess(StructuredGraph graph, LoadIndexedNode loadIndexed, JavaKind elementKind) {
        AddressNode address = this.isLocalIDNode(loadIndexed) || this.isPrivateIDNode(loadIndexed) ? this.createArrayLocalAddress(graph, loadIndexed.array(), loadIndexed.index()) : this.createArrayAddress(graph, loadIndexed.array(), elementKind, loadIndexed.index());
        return address;
    }

    private AbstractWriteNode createMemWriteNode(JavaKind elementKind, ValueNode value, ValueNode array, AddressNode address, StructuredGraph graph, StoreIndexedNode storeIndexed) {
        if (this.isLocalIDNode(storeIndexed) || this.isPrivateIDNode(storeIndexed)) {
            address = this.createArrayLocalAddress(graph, array, storeIndexed.index());
        }
        ValueNode storeConvertValue = value;
        Stamp valueStamp = value.stamp(NodeView.DEFAULT);
        if (!(valueStamp instanceof OCLStamp) || !((OCLStamp)valueStamp).getOCLKind().isVector()) {
            storeConvertValue = this.implicitStoreConvert(graph, elementKind, value);
        }
        AbstractWriteNode memoryWrite = (AbstractWriteNode)graph.add((Node)new WriteNode(address, NamedLocationIdentity.getArrayLocation((JavaKind)elementKind), storeConvertValue, BarrierType.NONE, TornadoMemoryOrder.GPU_MEMORY_MODE));
        return memoryWrite;
    }
}

