/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

public class OCLLIRKindTool
implements LIRKindTool {
    private final OCLTargetDescription target;

    public OCLLIRKindTool(OCLTargetDescription target) {
        this.target = target;
    }

    public LIRKind getUnsignedIntegerKind(int numBits) {
        if (numBits <= 8) {
            return LIRKind.value((PlatformKind)OCLKind.UCHAR);
        }
        if (numBits <= 16) {
            return LIRKind.value((PlatformKind)OCLKind.USHORT);
        }
        if (numBits <= 32) {
            return LIRKind.value((PlatformKind)OCLKind.UINT);
        }
        if (numBits <= 64) {
            return LIRKind.value((PlatformKind)OCLKind.ULONG);
        }
        throw TornadoInternalError.shouldNotReachHere();
    }

    public LIRKind getIntegerKind(int numBits) {
        if (numBits <= 8) {
            return LIRKind.value((PlatformKind)OCLKind.CHAR);
        }
        if (numBits <= 16) {
            return LIRKind.value((PlatformKind)OCLKind.SHORT);
        }
        if (numBits <= 32) {
            return LIRKind.value((PlatformKind)OCLKind.INT);
        }
        if (numBits <= 64) {
            return LIRKind.value((PlatformKind)OCLKind.LONG);
        }
        throw TornadoInternalError.shouldNotReachHere();
    }

    public LIRKind getFloatingKind(int numBits) {
        switch (numBits) {
            case 32: {
                return LIRKind.value((PlatformKind)OCLKind.FLOAT);
            }
            case 64: {
                return LIRKind.value((PlatformKind)OCLKind.DOUBLE);
            }
        }
        throw TornadoInternalError.shouldNotReachHere();
    }

    public LIRKind getNarrowOopKind() {
        TornadoInternalError.unimplemented((String)"GetNarrowOop not supported yet");
        return null;
    }

    public LIRKind getNarrowPointerKind() {
        TornadoInternalError.unimplemented((String)"GetNarrowPointerKind not supported yet");
        return null;
    }

    public LIRKind getObjectKind() {
        return this.getWordKind();
    }

    public LIRKind getWordKind() {
        return LIRKind.value((PlatformKind)this.target.getArch().getWordKind());
    }
}

