/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import java.nio.ByteBuffer;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.InvalidInstalledCodeException;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.common.mm.PrimitiveSerialiser;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OCLProgram;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLKernelStackFrame;
import uk.ac.manchester.tornado.drivers.opencl.runtime.OCLTornadoDevice;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLGenericGPUScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLKernelScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLScheduler;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoInstalledCode;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLInstalledCode
extends InstalledCode
implements TornadoInstalledCode {
    private static final int CL_MEM_SIZE = 8;
    private final OCLKernelScheduler DEFAULT_SCHEDULER;
    private final ByteBuffer buffer = ByteBuffer.allocate(8);
    private final byte[] code;
    private final OCLProgram program;
    private final OCLDeviceContext deviceContext;
    private final OCLKernel kernel;
    private final OCLKernelScheduler scheduler;
    private final int[] internalEvents = new int[1];
    private final long[] singleThreadGlobalWorkSize = new long[]{1L};
    private final long[] singleThreadLocalWorkSize = new long[]{1L};
    private final boolean isSPIRVBinary;
    private boolean valid;
    TornadoLogger logger = new TornadoLogger(((Object)((Object)this)).getClass());

    public OCLInstalledCode(String entryPoint, byte[] code, OCLDeviceContext deviceContext, OCLProgram program, OCLKernel kernel, boolean isSPIRVBinary) {
        super(entryPoint);
        this.code = code;
        this.deviceContext = deviceContext;
        this.scheduler = OCLScheduler.create(deviceContext);
        this.DEFAULT_SCHEDULER = new OCLGenericGPUScheduler(deviceContext);
        this.kernel = kernel;
        this.program = program;
        this.valid = kernel != null;
        this.buffer.order(deviceContext.getByteOrder());
        this.isSPIRVBinary = isSPIRVBinary;
    }

    public void invalidate() {
        if (this.valid) {
            this.program.cleanup();
            this.valid = false;
        }
    }

    public OCLProgram getProgram() {
        return this.program;
    }

    public boolean isValid() {
        return this.valid;
    }

    public OCLKernel getKernel() {
        return this.kernel;
    }

    public Object executeVarargs(Object ... args) throws InvalidInstalledCodeException {
        return null;
    }

    public byte[] getCode() {
        return this.code;
    }

    public String getGeneratedSourceCode() {
        return new String(this.code);
    }

    private void setKernelArgs(OCLKernelStackFrame kernelArgs, XPUBuffer atomicSpace, TaskDataContext meta) {
        int index = 0;
        this.buffer.clear();
        this.buffer.putLong(kernelArgs.toBuffer());
        this.kernel.setArg(index, this.buffer);
        ++index;
        if (this.isSPIRVBinary) {
            int argIndex = 0;
            for (int i = 0; i < kernelArgs.getCallArguments().size(); ++i) {
                KernelStackFrame.CallArgument arg = kernelArgs.getCallArguments().get(i);
                if (arg.getValue() instanceof KernelStackFrame.KernelContextArgument) {
                    this.buffer.clear();
                    this.buffer.putLong(kernelArgs.toBuffer());
                    this.kernel.setArg(index + argIndex, this.buffer);
                    ++argIndex;
                    continue;
                }
                if (RuntimeUtilities.isBoxedPrimitive((Object)arg.getValue()) || arg.getValue().getClass().isPrimitive()) {
                    this.buffer.clear();
                    PrimitiveSerialiser.put((ByteBuffer)this.buffer, (Object)arg.getValue());
                    this.kernel.setArg(index + argIndex, this.buffer);
                } else {
                    TornadoInternalError.shouldNotReachHere();
                }
                ++argIndex;
            }
            return;
        }
        if (meta != null && meta.getConstantSize() > 0) {
            this.kernel.setArg(index, ByteBuffer.wrap(meta.getConstantData()));
        } else {
            this.buffer.clear();
            this.buffer.putLong(kernelArgs.toConstantAddress());
            this.kernel.setArg(index, this.buffer);
        }
        ++index;
        if (meta != null && meta.getLocalSize() > 0) {
            this.logger.info("\tallocating %s of local memory", new Object[]{RuntimeUtilities.humanReadableByteCount((long)meta.getLocalSize(), (boolean)true)});
            this.kernel.setLocalRegion(index, meta.getLocalSize());
        } else {
            this.kernel.setArgUnused(index);
        }
        this.buffer.clear();
        this.buffer.putLong(kernelArgs.toAtomicAddress());
        this.kernel.setArg(++index, this.buffer);
        ++index;
        int argIndex = 0;
        for (int i = 0; i < kernelArgs.getCallArguments().size(); ++i) {
            KernelStackFrame.CallArgument arg = kernelArgs.getCallArguments().get(i);
            if (arg.getValue() instanceof KernelStackFrame.KernelContextArgument) continue;
            if (RuntimeUtilities.isBoxedPrimitive((Object)arg.getValue()) || arg.getValue().getClass().isPrimitive()) {
                this.buffer.clear();
                PrimitiveSerialiser.put((ByteBuffer)this.buffer, (Object)arg.getValue());
                this.kernel.setArg(index + argIndex, this.buffer);
            } else {
                TornadoInternalError.shouldNotReachHere();
            }
            ++argIndex;
        }
    }

    private void printDebugLaunchInfo(TaskDataContext meta) {
        System.out.println("Running on: ");
        System.out.println("\tPlatform: " + meta.getXPUDevice().getPlatformName());
        if (meta.getXPUDevice() instanceof OCLTornadoDevice) {
            System.out.println("\tDevice  : " + ((OCLTornadoDevice)meta.getXPUDevice()).getPhysicalDevice().getDeviceName());
        }
    }

    public int submitWithEvents(long executionPlanId, OCLKernelStackFrame kernelArgs, XPUBuffer atomicSpace, TaskDataContext meta, int[] events, long batchThreads) {
        int task;
        TornadoInternalError.guarantee((this.kernel != null ? 1 : 0) != 0, (String)"kernel is null", (Object[])new Object[0]);
        if (TornadoOptions.DEBUG) {
            this.logger.info("kernel submitted: id=0x%x, method = %s, device =%s", new Object[]{this.kernel.getOclKernelID(), this.kernel.getName(), this.deviceContext.getDevice().getDeviceName()});
        }
        this.setKernelArgs(kernelArgs, atomicSpace, meta);
        this.internalEvents[0] = kernelArgs.enqueueWrite(executionPlanId, events);
        int[] waitEvents = this.internalEvents;
        this.updateProfilerKernelContextWrite(executionPlanId, this.internalEvents[0], meta, kernelArgs);
        if (meta == null) {
            task = this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, this.singleThreadGlobalWorkSize, this.singleThreadLocalWorkSize, waitEvents);
        } else if (meta.isParallel()) {
            task = this.scheduler.submit(executionPlanId, this.kernel, meta, waitEvents, batchThreads);
        } else {
            if (meta.isDebug()) {
                this.printDebugLaunchInfo(meta);
            }
            task = meta.getGlobalWork() == null ? this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, this.singleThreadGlobalWorkSize, this.singleThreadLocalWorkSize, waitEvents) : this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, meta.getGlobalWork(), meta.getLocalWork(), waitEvents);
        }
        return task;
    }

    private void executeSingleThread(long executionPlanId) {
        this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, this.singleThreadGlobalWorkSize, this.singleThreadLocalWorkSize, null);
    }

    private int submitSequential(long executionPlanId, TaskDataContext meta) {
        if (meta.isThreadInfoEnabled()) {
            meta.printThreadDims();
        }
        int task = meta.getGlobalWork() == null || meta.getGlobalWork().length == 0 ? this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, this.singleThreadGlobalWorkSize, this.singleThreadLocalWorkSize, null) : this.deviceContext.enqueueNDRangeKernel(executionPlanId, this.kernel, 1, null, meta.getGlobalWork(), meta.getLocalWork(), null);
        if (TornadoOptions.isProfilerEnabled()) {
            Event tornadoKernelEvent = this.deviceContext.resolveEvent(executionPlanId, task);
            tornadoKernelEvent.waitForEvents(executionPlanId);
            long timer = meta.getProfiler().getTimer(ProfilerType.TOTAL_KERNEL_TIME);
            meta.getProfiler().setTimer(ProfilerType.TOTAL_KERNEL_TIME, timer + tornadoKernelEvent.getElapsedTime());
            meta.getProfiler().setTaskTimer(ProfilerType.TASK_KERNEL_TIME, meta.getId(), tornadoKernelEvent.getElapsedTime());
            long dispatchValue = meta.getProfiler().getTimer(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME);
            meta.getProfiler().setTimer(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME, dispatchValue += tornadoKernelEvent.getDriverDispatchTime());
        }
        return task;
    }

    private int submitParallel(long executionPlanId, TaskDataContext meta, long batchThreads) {
        return this.scheduler.submit(executionPlanId, this.kernel, meta, batchThreads);
    }

    private void launchKernel(long executionPlanId, OCLKernelStackFrame callWrapper, TaskDataContext meta, long batchThreads) {
        if (meta.isParallel() || meta.isWorkerGridAvailable()) {
            this.submitParallel(executionPlanId, meta, batchThreads);
        } else {
            this.submitSequential(executionPlanId, meta);
        }
    }

    private void checkKernelNotNull() {
        if (this.kernel == null) {
            throw new TornadoRuntimeException("[ERROR] Generated Kernel is NULL. \nPlease report this issue to https://github.com/beehive-lab/TornadoVM");
        }
    }

    private void submitWithoutEvents(long executionPlanId, OCLKernelStackFrame oclKernelStackFrame, XPUBuffer atomicSpace, TaskDataContext meta, long batchThreads) {
        this.checkKernelNotNull();
        if (TornadoOptions.DEBUG) {
            this.logger.info("kernel submitted: id=0x%x, method = %s, device =%s", new Object[]{this.kernel.getOclKernelID(), this.kernel.getName(), this.deviceContext.getDevice().getDeviceName()});
        }
        this.setKernelArgs(oclKernelStackFrame, atomicSpace, meta);
        int kernelContextWriteEventId = oclKernelStackFrame.enqueueWrite(executionPlanId);
        this.updateProfilerKernelContextWrite(executionPlanId, kernelContextWriteEventId, meta, oclKernelStackFrame);
        if (meta == null) {
            this.executeSingleThread(executionPlanId);
        } else {
            this.launchKernel(executionPlanId, oclKernelStackFrame, meta, batchThreads);
        }
    }

    private void updateProfilerKernelContextWrite(long executionPlanId, int kernelContextWriteEventId, TaskDataContext meta, OCLKernelStackFrame callWrapper) {
        if (TornadoOptions.isProfilerEnabled()) {
            TornadoProfiler profiler = meta.getProfiler();
            Event event = this.deviceContext.resolveEvent(executionPlanId, kernelContextWriteEventId);
            event.waitForEvents(executionPlanId);
            long copyInTimer = meta.getProfiler().getTimer(ProfilerType.COPY_IN_TIME);
            profiler.setTimer(ProfilerType.COPY_IN_TIME, copyInTimer += event.getElapsedTime());
            profiler.addValueToMetric(ProfilerType.TOTAL_COPY_IN_SIZE_BYTES, meta.getId(), callWrapper.getSize());
            long dispatchValue = profiler.getTimer(ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME);
            profiler.setTimer(ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME, dispatchValue += event.getDriverDispatchTime());
        }
    }

    public int launchWithDependencies(long executionPlanId, KernelStackFrame callWrapper, XPUBuffer atomicSpace, TaskDataContext meta, long batchThreads, int[] waitEvents) {
        return this.submitWithEvents(executionPlanId, (OCLKernelStackFrame)callWrapper, atomicSpace, meta, waitEvents, batchThreads);
    }

    public int launchWithoutDependencies(long executionPlanId, KernelStackFrame callWrapper, XPUBuffer atomicSpace, TaskDataContext meta, long batchThreads) {
        this.submitWithoutEvents(executionPlanId, (OCLKernelStackFrame)callWrapper, atomicSpace, meta, batchThreads);
        return -1;
    }
}

