/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotStampProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.loop.LoopsDataProviderImpl;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.word.WordTypes;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDescription;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLCodeProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLLoweringProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLSuitesProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilerConfiguration;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.plugins.OCLGraphBuilderPlugins;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLAddressLowering;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.providers.TornadoMetaAccessExtensionProvider;
import uk.ac.manchester.tornado.drivers.providers.TornadoPlatformConfigurationProvider;
import uk.ac.manchester.tornado.drivers.providers.TornadoWordTypes;
import uk.ac.manchester.tornado.runtime.TornadoVMConfigAccess;
import uk.ac.manchester.tornado.runtime.graal.DummySnippetFactory;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoConstantFieldProvider;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoForeignCallsProvider;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoReplacements;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSnippetReflectionProvider;

public class OCLHotSpotBackendFactory {
    private static final HotSpotStampProvider stampProvider = new HotSpotStampProvider();
    private static final TornadoSnippetReflectionProvider snippetReflection = new TornadoSnippetReflectionProvider();
    private static final TornadoForeignCallsProvider foreignCalls = new TornadoForeignCallsProvider();
    private static final TornadoConstantFieldProvider constantFieldProvider = new TornadoConstantFieldProvider();
    private static final OCLCompilerConfiguration compilerConfiguration = new OCLCompilerConfiguration();
    private static final OCLAddressLowering addressLowering = new OCLAddressLowering();

    public static OCLBackend createJITCompiler(OptionValues options, HotSpotJVMCIRuntime jvmciRuntime, TornadoVMConfigAccess config, OCLContextInterface tornadoContext, OCLTargetDevice device) {
        OCLProviders providers;
        JVMCIBackend jvmciBackend = jvmciRuntime.getHostJVMCIBackend();
        HotSpotMetaAccessProvider metaAccess = (HotSpotMetaAccessProvider)jvmciBackend.getMetaAccess();
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)jvmciBackend.getConstantReflection();
        OCLKind wordKind = switch (device.getWordSize()) {
            case 4 -> OCLKind.UINT;
            case 8 -> OCLKind.ULONG;
            default -> {
                TornadoInternalError.shouldNotReachHere((String)"unknown word size for device: word size is %d on %s", (Object[])new Object[]{device.getWordSize(), device.getDeviceName()});
                yield OCLKind.ILLEGAL;
            }
        };
        OCLArchitecture arch = new OCLArchitecture(wordKind, device.getByteOrder());
        OCLTargetDescription target = new OCLTargetDescription(arch, device.isDeviceDoubleFPSupported(), device.getDeviceExtensions());
        OCLCodeProvider codeCache = new OCLCodeProvider(target);
        OCLDeviceContextInterface oclDeviceContextImpl = (OCLDeviceContextInterface)tornadoContext.createDeviceContext(device.getIndex());
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            TornadoPlatformConfigurationProvider platformConfigurationProvider = new TornadoPlatformConfigurationProvider();
            TornadoMetaAccessExtensionProvider metaAccessExtensionProvider = new TornadoMetaAccessExtensionProvider();
            OCLLoweringProvider lowerer = new OCLLoweringProvider((MetaAccessProvider)metaAccess, (ForeignCallsProvider)foreignCalls, (PlatformConfigurationProvider)platformConfigurationProvider, (MetaAccessExtensionProvider)metaAccessExtensionProvider, (ConstantReflectionProvider)constantReflection, config, target);
            TornadoWordTypes wordTypes = new TornadoWordTypes((MetaAccessProvider)metaAccess, wordKind.asJavaKind());
            LoopsDataProviderImpl lpd = new LoopsDataProviderImpl();
            Providers p = new Providers((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, (ConstantReflectionProvider)constantReflection, (ConstantFieldProvider)constantFieldProvider, (ForeignCallsProvider)foreignCalls, (LoweringProvider)lowerer, lowerer.getReplacements(), (StampProvider)stampProvider, (PlatformConfigurationProvider)platformConfigurationProvider, (MetaAccessExtensionProvider)metaAccessExtensionProvider, (SnippetReflectionProvider)snippetReflection, (WordTypes)wordTypes, (LoopsDataProvider)lpd);
            ClassfileBytecodeProvider bytecodeProvider = new ClassfileBytecodeProvider((MetaAccessProvider)metaAccess, (SnippetReflectionProvider)snippetReflection);
            GraalDebugHandlersFactory graalDebugHandlersFactory = new GraalDebugHandlersFactory((SnippetReflectionProvider)snippetReflection);
            TornadoReplacements replacements = new TornadoReplacements(graalDebugHandlersFactory, p, (SnippetReflectionProvider)snippetReflection, (BytecodeProvider)bytecodeProvider, (TargetDescription)target);
            GraphBuilderConfiguration.Plugins plugins = OCLHotSpotBackendFactory.createGraphBuilderPlugins(metaAccess, (Replacements)replacements, (SnippetReflectionProvider)snippetReflection, (LoweringProvider)lowerer);
            replacements.setGraphBuilderPlugins(plugins);
            OCLSuitesProvider suites = new OCLSuitesProvider(options, oclDeviceContextImpl, plugins, (MetaAccessProvider)metaAccess, compilerConfiguration, addressLowering);
            providers = new OCLProviders((MetaAccessProvider)metaAccess, codeCache, (ConstantReflectionProvider)constantReflection, (ConstantFieldProvider)constantFieldProvider, (ForeignCallsProvider)foreignCalls, (LoweringProvider)lowerer, (Replacements)replacements, (StampProvider)stampProvider, (PlatformConfigurationProvider)platformConfigurationProvider, (MetaAccessExtensionProvider)metaAccessExtensionProvider, (SnippetReflectionProvider)snippetReflection, (WordTypes)wordTypes, p.getLoopsDataProvider(), suites);
            lowerer.initialize(options, (SnippetCounter.Group.Factory)new DummySnippetFactory(), providers);
        }
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            OCLBackend oCLBackend = new OCLBackend(options, providers, target, codeCache, oclDeviceContextImpl);
            return oCLBackend;
        }
    }

    protected static GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotMetaAccessProvider metaAccess, Replacements replacements, SnippetReflectionProvider snippetReflectionProvider, LoweringProvider loweringProvider) {
        InvocationPlugins invocationPlugins = new InvocationPlugins();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        OCLGraphBuilderPlugins.registerParameterPlugins(plugins);
        OCLGraphBuilderPlugins.registerNewInstancePlugins(plugins);
        StandardGraphBuilderPlugins.registerInvocationPlugins((SnippetReflectionProvider)snippetReflectionProvider, (InvocationPlugins)invocationPlugins, (Replacements)replacements, (boolean)false, (boolean)false, (boolean)false, (LoweringProvider)loweringProvider);
        OCLGraphBuilderPlugins.registerInvocationPlugins(plugins, invocationPlugins, metaAccess);
        return plugins;
    }

    public String toString() {
        return "OpenCL";
    }
}

