/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.lir.framemap.FrameMap;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

public class OCLFrameMap
extends FrameMap {
    public OCLFrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.spillSize = this.initialSpillSize = this.returnAddressSize();
    }

    public int totalFrameSize() {
        return this.frameSize() + this.returnAddressSize();
    }

    public int currentFrameSize() {
        return this.alignFrameSize(this.outgoingSize + this.spillSize - this.returnAddressSize());
    }

    protected int alignFrameSize(int size) {
        return NumUtil.roundUp((int)(size + this.returnAddressSize()), (int)this.getTarget().stackAlignment) - this.returnAddressSize();
    }

    public StackSlot allocateDeoptimizationRescueSlot() {
        assert (this.spillSize == this.initialSpillSize || this.spillSize == this.initialSpillSize + this.spillSlotSize((ValueKind)LIRKind.value((PlatformKind)OCLKind.ULONG))) : "Deoptimization rescue slot must be the first or second (if there is an RBP spill slot) stack slot";
        return this.allocateSpillSlot((ValueKind)LIRKind.value((PlatformKind)OCLKind.ULONG));
    }
}

