/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal;

import java.nio.ByteOrder;
import java.util.Set;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.common.architecture.ArchitectureRegister;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.meta.OCLMemorySpace;

public class OCLArchitecture
extends Architecture {
    public static final Register.RegisterCategory OCL_ABI = new Register.RegisterCategory("abi");
    public static final OCLMemoryBase globalSpace = new OCLMemoryBase(0, "_global_region", OCLMemorySpace.GLOBAL, OCLKind.UCHAR);
    public static final OCLMemoryBase kernelContext = new OCLMemoryBase(1, "_kernel_context", OCLMemorySpace.GLOBAL, OCLKind.LONG);
    public static final OCLMemoryBase constantSpace = new OCLMemoryBase(2, "_constant_region", OCLMemorySpace.CONSTANT, OCLKind.UCHAR);
    public static final OCLMemoryBase localSpace = new OCLMemoryBase(3, "_local_region", OCLMemorySpace.LOCAL, OCLKind.UCHAR);
    public static final OCLMemoryBase privateSpace = new OCLMemoryBase(4, "_private_region", OCLMemorySpace.PRIVATE, OCLKind.UCHAR);
    public static final OCLMemoryBase atomicSpace = new OCLMemoryBase(5, "_atomics", OCLMemorySpace.GLOBAL, OCLKind.INT);
    public static OCLRegister[] abiRegisters;

    public OCLArchitecture(OCLKind wordKind, ByteOrder byteOrder) {
        super("Tornado OpenCL", (PlatformKind)wordKind, byteOrder, false, null, 10, 0, 0);
        abiRegisters = new OCLRegister[]{kernelContext, constantSpace, localSpace, atomicSpace};
    }

    public PlatformKind getPlatformKind(JavaKind javaKind) {
        OCLKind oclKind = OCLKind.ILLEGAL;
        switch (javaKind) {
            case Boolean: {
                oclKind = OCLKind.BOOL;
                break;
            }
            case Byte: {
                oclKind = OCLKind.CHAR;
                break;
            }
            case Short: {
                oclKind = javaKind.isUnsigned() ? OCLKind.USHORT : OCLKind.SHORT;
                break;
            }
            case Char: {
                oclKind = OCLKind.USHORT;
                break;
            }
            case Int: {
                oclKind = javaKind.isUnsigned() ? OCLKind.UINT : OCLKind.INT;
                break;
            }
            case Long: {
                oclKind = javaKind.isUnsigned() ? OCLKind.ULONG : OCLKind.LONG;
                break;
            }
            case Float: {
                oclKind = OCLKind.FLOAT;
                break;
            }
            case Double: {
                oclKind = OCLKind.DOUBLE;
                break;
            }
            case Object: {
                oclKind = (OCLKind)this.getWordKind();
                break;
            }
            case Void: 
            case Illegal: {
                break;
            }
            default: {
                TornadoInternalError.shouldNotReachHere((String)"illegal java type for %s", (Object[])new Object[]{javaKind.name()});
            }
        }
        return oclKind;
    }

    public Set<AMD64.CPUFeature> getFeatures() {
        TornadoInternalError.unimplemented();
        return null;
    }

    public int getReturnAddressSize() {
        return this.getWordSize();
    }

    public boolean canStoreValue(Register.RegisterCategory category, PlatformKind platformKind) {
        return false;
    }

    public PlatformKind getLargestStorableKind(Register.RegisterCategory category) {
        return OCLKind.LONG;
    }

    public String getABI() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < abiRegisters.length; ++i) {
            sb.append(abiRegisters[i].getDeclaration());
            if (i >= abiRegisters.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getCallingConvention() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < abiRegisters.length; ++i) {
            sb.append(abiRegisters[i].getName());
            if (i >= abiRegisters.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static class OCLRegister
    extends ArchitectureRegister {
        public OCLRegister(int number, String name, OCLKind lirKind) {
            super(number, name, (PlatformKind)lirKind);
        }
    }

    public static class OCLMemoryBase
    extends OCLRegister {
        final OCLMemorySpace memorySpace;

        public OCLMemoryBase(int number, String name, OCLMemorySpace memorySpace, OCLKind kind) {
            super(number, name, kind);
            this.memorySpace = memorySpace;
        }

        public OCLMemorySpace getMemorySpace() {
            return this.memorySpace;
        }

        public String getDeclaration() {
            return String.format("%s %s *%s", this.memorySpace.name(), this.lirKind.toString(), this.name);
        }
    }
}

