/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.enums;

public enum OCLDeviceType {
    Unknown(-1L),
    CL_DEVICE_TYPE_DEFAULT(1L),
    CL_DEVICE_TYPE_CPU(2L),
    CL_DEVICE_TYPE_GPU(4L),
    CL_DEVICE_TYPE_ACCELERATOR(8L),
    CL_DEVICE_TYPE_CUSTOM(16L),
    CL_DEVICE_TYPE_ALL(0xFFFFFFFFL);

    private final long value;

    private OCLDeviceType(long v) {
        this.value = v;
    }

    public long getValue() {
        return this.value;
    }

    public static OCLDeviceType toDeviceType(long v) {
        return switch ((int)v) {
            case 1 -> CL_DEVICE_TYPE_DEFAULT;
            case 2 -> CL_DEVICE_TYPE_CPU;
            case 4 -> CL_DEVICE_TYPE_GPU;
            case 8 -> CL_DEVICE_TYPE_ACCELERATOR;
            case 16 -> CL_DEVICE_TYPE_CUSTOM;
            case -1 -> CL_DEVICE_TYPE_ALL;
            default -> Unknown;
        };
    }
}

