/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.enums;

import uk.ac.manchester.tornado.api.enums.TornadoExecutionStatus;

public enum OCLCommandExecutionStatus {
    CL_UNKNOWN(4),
    CL_COMPLETE(0),
    CL_RUNNING(1),
    CL_SUBMITTED(2),
    CL_QUEUED(3),
    CL_ERROR(-1);

    private final int value;

    private OCLCommandExecutionStatus(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public static OCLCommandExecutionStatus createOCLCommandExecutionStatus(int v) {
        return switch (v) {
            case 0 -> CL_COMPLETE;
            case 1 -> CL_RUNNING;
            case 2 -> CL_SUBMITTED;
            case 3 -> CL_QUEUED;
            default -> CL_ERROR;
        };
    }

    public TornadoExecutionStatus toTornadoExecutionStatus() {
        TornadoExecutionStatus result = TornadoExecutionStatus.UNKNOWN;
        switch (this.ordinal()) {
            case 1: {
                result = TornadoExecutionStatus.COMPLETE;
                break;
            }
            case 4: {
                result = TornadoExecutionStatus.QUEUED;
                break;
            }
            case 2: {
                result = TornadoExecutionStatus.RUNNING;
                break;
            }
            case 3: {
                result = TornadoExecutionStatus.SUBMITTED;
                break;
            }
            default: {
                result = TornadoExecutionStatus.ERROR;
            }
        }
        return result;
    }
}

