/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import uk.ac.manchester.tornado.api.TornadoTargetDevice;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.drivers.opencl.OCLContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLPlatform;
import uk.ac.manchester.tornado.drivers.opencl.TornadoPlatformInterface;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.runtime.OCLTornadoDevice;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualDeviceDescriptor;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualJSONParser;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLPlatform;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.tasks.DataObjectState;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OpenCL {
    public static final String OPENCL_JNI_LIBRARY = "tornado-opencl";
    private static boolean initialised = false;
    private static final List<TornadoPlatformInterface> platforms = new ArrayList<TornadoPlatformInterface>();
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final int CL_TRUE = 1;
    public static final int CL_FALSE = 0;

    static native boolean registerCallback();

    static native int clGetPlatformCount();

    static native int clGetPlatformIDs(long[] var0);

    public static void cleanup() {
        if (initialised) {
            platforms.forEach(TornadoPlatformInterface::cleanup);
        }
    }

    public static TornadoPlatformInterface getPlatform(int index) {
        return platforms.get(index);
    }

    public static int getNumPlatforms() {
        return platforms.size();
    }

    private static void initializeVirtualPlatform() {
        if (!initialised) {
            VirtualDeviceDescriptor info = VirtualJSONParser.getDeviceDescriptor();
            VirtualOCLPlatform platform = new VirtualOCLPlatform(info);
            platforms.add(platform);
            initialised = true;
        }
    }

    public static void initialise() {
        if (!initialised) {
            try {
                int numPlatforms = OpenCL.clGetPlatformCount();
                long[] platformPointers = new long[numPlatforms];
                OpenCL.clGetPlatformIDs(platformPointers);
                for (int i = 0; i < platformPointers.length; ++i) {
                    OCLPlatform platform = new OCLPlatform(i, platformPointers[i]);
                    platforms.add(platform);
                }
                initialised = true;
            }
            catch (Exception e) {
                throw new TornadoRuntimeException("[ERROR] Problem with OpenCL bindings");
            }
        }
    }

    public static void run(Long executionContextId, OCLTornadoDevice tornadoDevice, OCLInstalledCode openCLCode, TaskDataContext taskMeta, Access[] accesses, Object ... parameters) {
        int i;
        if (parameters.length != accesses.length) {
            throw new TornadoRuntimeException("[ERROR] Accesses and objects array should match in size");
        }
        ArrayList<XPUDeviceBufferState> states = new ArrayList<XPUDeviceBufferState>();
        for (int i2 = 0; i2 < accesses.length; ++i2) {
            Access access = accesses[i2];
            Object object = parameters[i2];
            DataObjectState dataObjectState = new DataObjectState();
            XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState((TornadoDevice)tornadoDevice);
            switch (access) {
                case READ_WRITE: {
                    tornadoDevice.allocate(object, 0L, (DeviceBufferState)deviceState, Access.READ_WRITE);
                    tornadoDevice.ensurePresent(executionContextId, object, (DeviceBufferState)deviceState, null, 0L, 0L);
                    break;
                }
                case READ_ONLY: {
                    tornadoDevice.allocate(object, 0L, (DeviceBufferState)deviceState, Access.READ_ONLY);
                    tornadoDevice.ensurePresent(executionContextId, object, (DeviceBufferState)deviceState, null, 0L, 0L);
                    break;
                }
                case WRITE_ONLY: {
                    tornadoDevice.allocate(object, 0L, (DeviceBufferState)deviceState, Access.WRITE_ONLY);
                    break;
                }
            }
            states.add(deviceState);
        }
        int numArgs = parameters.length;
        KernelStackFrame callWrapper = tornadoDevice.createKernelStackFrame(executionContextId, numArgs, Access.NONE);
        callWrapper.reset();
        callWrapper.setKernelContext(new HashMap());
        for (i = 0; i < numArgs; ++i) {
            callWrapper.addCallArgument((Object)((XPUDeviceBufferState)states.get(i)).getXPUBuffer().toBuffer(), true);
        }
        openCLCode.launchWithoutDependencies(executionContextId, callWrapper, null, taskMeta, 0L);
        block10: for (i = 0; i < accesses.length; ++i) {
            Access access = accesses[i];
            switch (access) {
                case READ_WRITE: 
                case WRITE_ONLY: {
                    Object object = parameters[i];
                    XPUDeviceBufferState deviceState = (XPUDeviceBufferState)states.get(i);
                    tornadoDevice.streamOutBlocking(executionContextId, object, 0L, (DeviceBufferState)deviceState, null);
                    continue block10;
                }
            }
        }
    }

    public static List<TornadoPlatformInterface> platforms() {
        return platforms;
    }

    public static void exploreAllPlatforms() {
        for (int platformIndex = 0; platformIndex < platforms.size(); ++platformIndex) {
            TornadoPlatformInterface platform = platforms.get(platformIndex);
            System.out.printf("[%d]: platform: %s\n", platformIndex, platform.getName());
            OCLContextInterface context = platform.createContext();
            for (int deviceIndex = 0; deviceIndex < context.getNumDevices(); ++deviceIndex) {
                OCLDeviceContext deviceContext = (OCLDeviceContext)context.createDeviceContext(deviceIndex);
                System.out.printf("\t[%d:%d] device: %s\n", platformIndex, deviceIndex, deviceContext.getDeviceName());
            }
        }
    }

    public static TornadoTargetDevice getDevice(int platformIndex, int deviceIndex) {
        TornadoPlatformInterface platform = platforms.get(platformIndex);
        OCLDeviceContext deviceContext = (OCLDeviceContext)platform.createContext().createDeviceContext(deviceIndex);
        return deviceContext.getDevice();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            OpenCL.exploreAllPlatforms();
        } else if (args.length == 2) {
            int platformIndex = Integer.parseInt(args[0]);
            int deviceIndex = Integer.parseInt(args[1]);
            TornadoTargetDevice device = OpenCL.getDevice(platformIndex, deviceIndex);
            System.out.println(device.getDeviceInfo());
        } else {
            System.out.println("usage: OpenCL <platform> <device>");
        }
    }

    static {
        if (TornadoOptions.VIRTUAL_DEVICE_ENABLED) {
            OpenCL.initializeVirtualPlatform();
        } else {
            try {
                System.loadLibrary(OPENCL_JNI_LIBRARY);
            }
            catch (UnsatisfiedLinkError e) {
                throw new TornadoRuntimeException("[ERROR] OpenCL JNI Library not found");
            }
            try {
                OpenCL.initialise();
            }
            catch (TornadoRuntimeException e) {
                throw new TornadoRuntimeException("[ERROR] Initialization of the OpenCL platform is not correct");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Thread.currentThread().setName("OpenCL-Cleanup-Thread");
                OpenCL.cleanup();
            }));
        }
    }
}

