/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLBuildStatus;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLProgramBuildInfo;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLProgramInfo;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class OCLProgram {
    private final long programPointer;
    private final OCLDeviceContext deviceContext;
    private final long[] devices;
    private final List<OCLKernel> kernels;
    private final ByteBuffer buffer;
    private final TornadoLogger logger;

    public OCLProgram(long oclProgramPointer, OCLDeviceContext deviceContext) {
        this.programPointer = oclProgramPointer;
        this.deviceContext = deviceContext;
        this.devices = new long[]{deviceContext.getDeviceId()};
        this.kernels = new ArrayList<OCLKernel>();
        this.buffer = ByteBuffer.allocate(8192);
        this.buffer.order(OpenCL.BYTE_ORDER);
        this.logger = new TornadoLogger(this.getClass());
    }

    static native void clReleaseProgram(long var0) throws OCLException;

    static native void clBuildProgram(long var0, long[] var2, String var3) throws OCLException;

    static native void clGetProgramInfo(long var0, int var2, byte[] var3) throws OCLException;

    static native void clGetProgramBuildInfo(long var0, long var2, int var4, byte[] var5) throws OCLException;

    static native long clCreateKernel(long var0, String var2) throws OCLException;

    static native void getBinaries(long var0, long var2, ByteBuffer var4) throws OCLException;

    public OCLBuildStatus getStatus(long deviceId) {
        OCLBuildStatus result;
        this.buffer.clear();
        try {
            OCLProgram.clGetProgramBuildInfo(this.programPointer, deviceId, OCLProgramBuildInfo.CL_PROGRAM_BUILD_STATUS.getValue(), this.buffer.array());
            result = OCLBuildStatus.toEnum(this.buffer.getInt());
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public String getBuildLog(long deviceId) {
        String result = "";
        this.buffer.clear();
        try {
            OCLProgram.clGetProgramBuildInfo(this.programPointer, deviceId, OCLProgramBuildInfo.CL_PROGRAM_BUILD_LOG.getValue(), this.buffer.array());
            result = new String(this.buffer.array(), "ASCII");
        }
        catch (UnsupportedEncodingException | OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        result = result.substring(0, result.indexOf(0));
        return result;
    }

    public void build(String options) {
        this.buffer.clear();
        try {
            OCLProgram.clBuildProgram(this.programPointer, this.devices, options);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public void cleanup() {
        try {
            this.kernels.forEach(OCLKernel::cleanup);
            OCLProgram.clReleaseProgram(this.programPointer);
        }
        catch (OCLException e) {
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public int getNumDevices() {
        int result = 0;
        this.buffer.clear();
        try {
            OCLProgram.clGetProgramInfo(this.programPointer, OCLProgramInfo.CL_PROGRAM_NUM_DEVICES.getValue(), this.buffer.array());
            result = this.buffer.getInt();
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public long[] getDevices() {
        int numDevices = this.getNumDevices();
        long[] result = new long[numDevices];
        this.buffer.clear();
        try {
            OCLProgram.clGetProgramInfo(this.programPointer, OCLProgramInfo.CL_PROGRAM_DEVICES.getValue(), this.buffer.array());
            for (int i = 0; i < numDevices; ++i) {
                result[i] = this.buffer.getLong();
            }
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public long[] getBinarySizes() {
        int numDevices = this.getNumDevices();
        long[] result = new long[numDevices];
        this.buffer.clear();
        try {
            OCLProgram.clGetProgramInfo(this.programPointer, OCLProgramInfo.CL_PROGRAM_BINARY_SIZES.getValue(), this.buffer.array());
            for (int i = 0; i < numDevices; ++i) {
                result[i] = this.buffer.getLong();
            }
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public void dumpBinaries(String filenamePrefix) {
        int index;
        long[] devices = this.getDevices();
        int numDevices = this.getNumDevices();
        long[] sizes = this.getBinarySizes();
        int offset = 0;
        for (index = 0; index < devices.length && devices[index] != this.deviceContext.getDeviceId(); ++index) {
            offset = (int)((long)offset + sizes[index]);
        }
        int totalSize = 0;
        for (long size : sizes) {
            totalSize += (int)size;
        }
        ByteBuffer binary = ByteBuffer.allocateDirect(totalSize);
        try {
            OCLProgram.getBinaries(this.programPointer, numDevices, binary);
            this.logger.info("dumping binary %s", new Object[]{filenamePrefix});
            try (FileOutputStream fis = new FileOutputStream(filenamePrefix);
                 FileChannel vChannel = fis.getChannel();){
                binary.position(offset);
                binary.limit(offset + (int)sizes[index]);
                vChannel.write(binary);
            }
            catch (IOException e) {
                this.logger.error("unable to dump binary: %s", new Object[]{e.getMessage()});
            }
        }
        catch (OCLException e) {
            this.logger.error("unable to retrieve binary from OpenCL driver: %s", new Object[]{e.getMessage()});
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("program: id=0x%x, num devices=%d\n", this.programPointer, this.devices.length));
        for (long device : this.devices) {
            sb.append(String.format("device: id=0x%x, status=%s\n", new Object[]{device, this.getStatus(device)}));
        }
        return sb.toString();
    }

    public OCLKernel clCreateKernel(String entryPoint) {
        OCLKernel kernel;
        try {
            kernel = new OCLKernel(OCLProgram.clCreateKernel(this.programPointer, entryPoint), this.deviceContext);
            this.kernels.add(kernel);
        }
        catch (OCLException e) {
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return kernel;
    }

    public void dump() {
        int numDevices = this.getNumDevices();
        new TornadoLogger().debug("Num devices: %d", new Object[]{numDevices});
    }
}

