/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDevice;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.TornadoPlatformInterface;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLPlatformInfo;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;

public class OCLPlatform
implements TornadoPlatformInterface {
    private final int index;
    private final long oclPlatformPtr;
    private final List<OCLTargetDevice> devices;

    public OCLPlatform(int index, long platformPointers) {
        this.index = index;
        this.oclPlatformPtr = platformPointers;
        this.devices = new ArrayList<OCLTargetDevice>();
        int deviceCount = this.isVendor(Vendor.XILINX) ? this.clGetDeviceCount(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR.getValue()) : (this.isVendor(Vendor.MESA) ? this.clGetDeviceCount(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_GPU.getValue()) : this.clGetDeviceCount(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_ALL.getValue()));
        long[] ids = new long[deviceCount];
        if (this.isVendor(Vendor.XILINX)) {
            this.clGetDeviceIDs(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR.getValue(), ids);
        } else if (this.isVendor(Vendor.MESA)) {
            this.clGetDeviceIDs(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_GPU.getValue(), ids);
        } else {
            this.clGetDeviceIDs(platformPointers, OCLDeviceType.CL_DEVICE_TYPE_ALL.getValue(), ids);
        }
        for (int i = 0; i < ids.length; ++i) {
            this.devices.add(new OCLDevice(i, ids[i]));
        }
    }

    private boolean isVendor(Vendor vendor) {
        return this.getVendor().toLowerCase().startsWith(vendor.getVendorName().toLowerCase());
    }

    native String clGetPlatformInfo(long var1, int var3);

    native int clGetDeviceCount(long var1, long var3);

    native int clGetDeviceIDs(long var1, long var3, long[] var5);

    native long clCreateContext(long var1, long[] var3) throws OCLException;

    public List<OCLTargetDevice> getDevices() {
        return this.devices;
    }

    @Override
    public OCLContext createContext() {
        OCLContext contextObject;
        LongBuffer deviceIds = LongBuffer.allocate(this.devices.size());
        this.devices.stream().mapToLong(OCLTargetDevice::getDevicePointer).forEach(deviceIds::put);
        try {
            long contextPtr = this.clCreateContext(this.oclPlatformPtr, deviceIds.array());
            contextObject = new OCLContext(this, contextPtr, this.devices);
        }
        catch (OCLException e) {
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return contextObject;
    }

    @Override
    public void cleanup() {
    }

    public String getProfile() {
        return this.clGetPlatformInfo(this.oclPlatformPtr, OCLPlatformInfo.CL_PLATFORM_PROFILE.getValue());
    }

    @Override
    public String getVersion() {
        return this.clGetPlatformInfo(this.oclPlatformPtr, OCLPlatformInfo.CL_PLATFORM_VERSION.getValue());
    }

    @Override
    public boolean isSPIRVSupported() {
        return this.devices.stream().anyMatch(OCLTargetDevice::isSPIRVSupported);
    }

    @Override
    public String getName() {
        return this.clGetPlatformInfo(this.oclPlatformPtr, OCLPlatformInfo.CL_PLATFORM_NAME.getValue());
    }

    @Override
    public String getVendor() {
        return this.clGetPlatformInfo(this.oclPlatformPtr, OCLPlatformInfo.CL_PLATFORM_VENDOR.getValue());
    }

    public String getExtensions() {
        return this.clGetPlatformInfo(this.oclPlatformPtr, OCLPlatformInfo.CL_PLATFORM_EXTENSIONS.getValue());
    }

    public String toString() {
        String sb = String.format("name=%s, num. devices=%d, ", this.getName(), this.devices.size()) + String.format("version=%s", this.getVersion());
        return sb.trim();
    }

    public int getIndex() {
        return this.index;
    }

    private static enum Vendor {
        CODEPLAY("Codeplay"),
        INTEL("Intel"),
        AMD("AMD"),
        NVIDIA("Nvidia"),
        MESA("Mesa/X.org"),
        XILINX("Xilinx");

        final String vendorName;

        private Vendor(String vendorName) {
            this.vendorName = vendorName;
        }

        String getVendorName() {
            return this.vendorName;
        }
    }
}

