/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLKernelInfo;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class OCLKernel {
    private final long oclKernelID;
    private final OCLDeviceContext deviceContext;
    private final ByteBuffer buffer;
    private String kernelName;
    private final TornadoLogger logger;

    public OCLKernel(long id, OCLDeviceContext deviceContext) {
        this.oclKernelID = id;
        this.deviceContext = deviceContext;
        this.buffer = ByteBuffer.allocate(1024);
        this.buffer.order(OpenCL.BYTE_ORDER);
        this.kernelName = "unknown";
        this.logger = new TornadoLogger(this.getClass());
        this.queryName();
    }

    static native void clReleaseKernel(long var0) throws OCLException;

    static native void clSetKernelArg(long var0, int var2, long var3, byte[] var5) throws OCLException;

    static native void clSetKernelArgRef(long var0, int var2, long var3) throws OCLException;

    static native void clGetKernelInfo(long var0, int var2, byte[] var3) throws OCLException;

    public void setArg(int index, ByteBuffer buffer) {
        try {
            OCLKernel.clSetKernelArg(this.oclKernelID, index, buffer.position(), buffer.array());
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void setArgRef(int index, long devicePtr) {
        System.out.println("Calling the new function");
        try {
            OCLKernel.clSetKernelArgRef(this.oclKernelID, index, devicePtr);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void setArgUnused(int index) {
        try {
            OCLKernel.clSetKernelArg(this.oclKernelID, index, 8L, null);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void setConstantRegion(int index, ByteBuffer buffer) {
        long maxSize = this.deviceContext.getDevice().getDeviceMaxConstantBufferSize();
        TornadoInternalError.guarantee(((long)buffer.position() <= maxSize ? 1 : 0) != 0, (String)"constant buffer is too large for device", (Object[])new Object[0]);
        this.setArg(index, buffer);
    }

    public void setLocalRegion(int index, long size) {
        long maxSize = this.deviceContext.getDevice().getDeviceLocalMemorySize();
        TornadoInternalError.guarantee((size <= maxSize ? 1 : 0) != 0, (String)"local allocation is too large for device", (Object[])new Object[0]);
        try {
            OCLKernel.clSetKernelArg(this.oclKernelID, index, size, null);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void cleanup() {
        try {
            OCLKernel.clReleaseKernel(this.oclKernelID);
        }
        catch (OCLException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.kernelName;
    }

    private void queryName() {
        Arrays.fill(this.buffer.array(), (byte)0);
        this.buffer.clear();
        try {
            OCLKernel.clGetKernelInfo(this.oclKernelID, OCLKernelInfo.CL_KERNEL_FUNCTION_NAME.getValue(), this.buffer.array());
            this.kernelName = new String(this.buffer.array(), StandardCharsets.US_ASCII);
        }
        catch (OCLException e) {
            e.printStackTrace();
        }
    }

    public long getOclKernelID() {
        return this.oclKernelID;
    }
}

