/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.lang.reflect.Method;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompiler;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.profiler.EmptyProfiler;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLJIT {
    public static void main(String[] args) {
        String className = args[0];
        String methodName = args[1];
        try {
            Class<?> declaringClass = Class.forName(className);
            Class[] parameterTypes = null;
            if (args.length > 2) {
                parameterTypes = new Class[args.length - 2];
                for (int i = 2; i < args.length; ++i) {
                    parameterTypes[i - 2] = args[i].equals("int") ? Integer.TYPE : (args[i].equals("float") ? Float.TYPE : Class.forName(args[i]));
                }
            }
            Method method = declaringClass.getDeclaredMethod(methodName, parameterTypes);
            ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(method);
            System.out.printf("method: name=%s, signature=%s\n", resolvedMethod.getName(), resolvedMethod.getSignature());
            OCLBackend backend = ((OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class)).getDefaultBackend();
            TaskDataContext meta = TaskDataContext.create((ScheduleContext)new ScheduleContext("s0"), (String)methodName, (Method)method);
            OCLCompilationResult result = OCLCompiler.compileCodeForDevice(resolvedMethod, new Object[0], meta, (OCLProviders)backend.getProviders(), backend, (TornadoProfiler)new EmptyProfiler());
            long executionPlanId = 0L;
            TornadoXPUDevice device = ((OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class)).getDefaultDevice();
            OCLDeviceContext deviceContext = (OCLDeviceContext)device.getDeviceContext();
            OCLInstalledCode code = deviceContext.installCode(0L, result);
            for (byte b : code.getCode()) {
                System.out.printf("%c", b);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

