/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.util.Arrays;
import uk.ac.manchester.tornado.drivers.common.GridInfo;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLFPGAScheduler;

public class OCLGridInfo
implements GridInfo {
    OCLDeviceContext deviceContext;
    public final long[] localWork;

    public OCLGridInfo(OCLDeviceContext deviceContext, long[] localWork) {
        this.deviceContext = deviceContext;
        this.localWork = localWork;
    }

    private boolean checkFPGADefaultLocalWorkGroup() {
        return Arrays.equals(this.localWork, OCLFPGAScheduler.DEFAULT_LOCAL_WORK_SIZE);
    }

    public boolean checkGridDimensions() {
        if (this.deviceContext.isPlatformFPGA()) {
            return this.checkFPGADefaultLocalWorkGroup();
        }
        long[] blockMaxWorkGroupSize = this.deviceContext.getDevice().getDeviceMaxWorkGroupSize();
        long maxWorkGroupSize = Arrays.stream(blockMaxWorkGroupSize).sum();
        long totalThreads = Arrays.stream(this.localWork).reduce(1L, (a, b) -> a * b);
        return totalThreads <= maxWorkGroupSize;
    }
}

