/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.common.utils.EventDescriptor;
import uk.ac.manchester.tornado.drivers.opencl.OCLCommandQueue;
import uk.ac.manchester.tornado.drivers.opencl.OCLEvent;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLEventPool {
    public final long[] waitEventsBuffer;
    private final long[] events;
    private final EventDescriptor[] descriptors;
    private final BitSet retain;
    private final OCLCommandQueue[] eventQueues;
    private final OCLEvent internalEvent;
    private int eventIndex;
    private int eventPoolSize;
    private final TornadoLogger logger;

    public OCLEventPool(int poolSize) {
        this.eventPoolSize = poolSize;
        this.retain = new BitSet(this.eventPoolSize);
        this.retain.clear();
        this.events = new long[this.eventPoolSize];
        this.descriptors = new EventDescriptor[this.eventPoolSize];
        this.eventQueues = new OCLCommandQueue[this.eventPoolSize];
        this.eventIndex = 0;
        this.waitEventsBuffer = new long[TornadoOptions.MAX_WAIT_EVENTS];
        this.internalEvent = new OCLEvent();
        this.logger = new TornadoLogger(this.getClass());
    }

    public int registerEvent(long oclEventId, EventDescriptor descriptorId, OCLCommandQueue queue) {
        int currentEvent;
        if (this.retain.get(this.eventIndex)) {
            this.findNextEventSlot();
        }
        TornadoInternalError.guarantee((!this.retain.get(currentEvent = this.eventIndex) ? 1 : 0) != 0, (String)"overwriting retained event", (Object[])new Object[0]);
        if (oclEventId == -1L) {
            this.logger.fatal("invalid event: event=0x%x, description=%s\n", new Object[]{oclEventId, descriptorId.getNameDescription()});
            this.logger.fatal("terminating application as system integrity has been compromised.");
            System.exit(-1);
        }
        if (this.events[currentEvent] > 0L && !this.retain.get(currentEvent)) {
            this.internalEvent.setEventId(currentEvent, this.events[currentEvent]);
            this.releaseEvent(currentEvent);
            this.internalEvent.release();
        }
        this.events[currentEvent] = oclEventId;
        this.descriptors[currentEvent] = descriptorId;
        this.eventQueues[currentEvent] = queue;
        this.findNextEventSlot();
        return currentEvent;
    }

    private void findNextEventSlot() {
        this.eventIndex = this.retain.nextClearBit(this.eventIndex + 1);
        if (TornadoOptions.CIRCULAR_EVENTS && this.eventIndex >= this.events.length) {
            this.eventIndex = 0;
        }
        TornadoInternalError.guarantee((this.eventIndex != -1 ? 1 : 0) != 0, (String)"event window is full (retained=%d, capacity=%d)", (Object[])new Object[]{this.retain.cardinality(), this.eventPoolSize});
    }

    public boolean serialiseEvents(int[] dependencies, OCLCommandQueue queue) {
        boolean outOfOrderQueue;
        boolean bl = outOfOrderQueue = (queue.getProperties() & 1L) == 1L;
        if (dependencies == null || dependencies.length == 0 || !outOfOrderQueue) {
            return false;
        }
        Arrays.fill(this.waitEventsBuffer, 0L);
        int index = 0;
        for (int value : dependencies) {
            if (value == -1) continue;
            this.waitEventsBuffer[++index] = this.events[value];
            this.logger.debug("[%d] 0x%x - %s\n", new Object[]{index, this.events[value], this.descriptors[value].getNameDescription()});
        }
        this.waitEventsBuffer[0] = index;
        return index > 0;
    }

    public List<OCLEvent> getEvents() {
        ArrayList<OCLEvent> result = new ArrayList<OCLEvent>();
        for (int i = 0; i < this.eventIndex; ++i) {
            long eventId = this.events[i];
            if (eventId <= 0L) continue;
            result.add(new OCLEvent(this.getDescriptor(i).getNameDescription(), this.eventQueues[i], i, eventId));
        }
        return result;
    }

    public void reset() {
        for (int index = 0; index < this.events.length; ++index) {
            if (this.events[index] <= 0L) continue;
            this.internalEvent.setEventId(index, this.events[index]);
            this.releaseEvent(index);
            this.internalEvent.release();
        }
        Arrays.fill(this.events, 0L);
        this.eventIndex = 0;
    }

    protected void retainEvent(int localEventID) {
        this.retain.set(localEventID);
    }

    protected void releaseEvent(int localEventID) {
        this.retain.clear(localEventID);
    }

    public long getOCLEvent(int localEventID) {
        return this.events[localEventID];
    }

    public EventDescriptor getDescriptor(int localEventID) {
        return this.descriptors[localEventID];
    }
}

